#!/bin/bash

is_user_root () { [ "${EUID:-$(id -u)}" -eq 0 ]; }

log_file="/var/log/BESWebReports/PdfExport.log"
redirect_stderr=0
if [ $redirect_stderr -ne 0 ]; then
    exec 3>&1 1>> $log_file 2>&1
else
    exec 3>&1 1>> $log_file
fi

OLDIFS=$IFS
IFS=' ' read -ra ADDR <<< "$1"
IFS=$OLDIFS

arg1=`echo ${ADDR[0]} | cut -d "\"" -f 2`
arg2=`echo ${ADDR[1]} | cut -d "\"" -f 2`

pdflocation="$arg2"
url="$arg1"

if ! command -v google-chrome > /dev/null; then
    echo "Error: google-chrome is required in order to export reports to pdf."
    exit 1
fi

sandbox_option=''
if is_user_root; then
    sandbox_option='--no-sandbox --disable-setuid-sandbox'
fi

time_start=$(date +%s%N)
echo "Launching google-chrome."
google-chrome \
    $sandbox_option \
    --incognito \
    --ignore-certificate-errors \
    --headless=new \
    --timeout=15000 \
    --virtual-time-budget=5000 \
    --disable-dev-shm-usage \
    --run-all-compositor-stages-before-draw \
    --disable-pdf-tagging \
    --print-to-pdf-no-header \
    --disable-gpu \
    --print-to-pdf=$pdflocation \
    $url

if [ $? -eq 0 ]; then
    echo "Converted '$url' to PDF: '$pdflocation'."
    elapsed=$((($(date +%s%N) - $time_start)/1000000))
    echo "PDF Conversion: ${elapsed}ms"

else
    echo "Something went wrong converting to PDF. Check the documentation for troubleshooting options."
fi
