// ChartBox.js

// <?import /JavaScript/Charts/Charts.css?>
// <?import /JavaScript/Charts/Charts.js?>
// <?import /JavaScript/Charts/ChartData.js?>
// <?import /JavaScript/Charts/Graph.js?>
// <?import /JavaScript/Util/HTML.js?>
// <?import /JavaScript/Charts/HoverBox.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/Charts/PropertiesConfiguration.js?>
// <?import /JavaScript/Charts/HistoricalConfiguration.js?>
// <?import /JavaScript/Charts/SummaryTable.js?>

// <?import /JavaScript/json2.js?>
// <?import /JavaScript/yui-import/Dom.js?>
// <?import /JavaScript/yui-import/Animation.js?>
// <?import /JavaScript/jQuery/jquery.js?>
// <?import /JavaScript/Charts/IEPrintableCharts.js?>

WR.Charts.ChartBox = function( chartManager, dataType )
{
    this.chartManager = chartManager;
    this.data = new WR.Charts.ChartData([]);
    this.id = 'WR_ChartBox_' + WR.Charts.ChartBox._nextIdNo++;
    
    this.isVisible = true;
    this.currentView = WR.Charts.ChartBox.CONFIGURATION_VIEW;
    this.graphHasBeenCreated = false;
    this.dataType = dataType;
    
    if ( dataType == WR.Charts.ChartBox.DATATYPE_PROPERTIES )
        this.configuration = new WR.Charts.PropertiesConfiguration( this );
    else if ( dataType == WR.Charts.ChartBox.DATATYPE_HISTORICAL )
        this.configuration = new WR.Charts.HistoricalConfiguration( this );
    
    
    this.chartGraph = new WR.Charts.Graph( this );
    this.chartSummary = new WR.Charts.SummaryTable( this );
    this.chartHoverBox = new WR.Charts.HoverBox( this );
    
    this._initUI();
    this._initAnimation();
};

WR.Charts.ChartBox._nextIdNo = 0;

/* Chart Types */
WR.Charts.ChartBox.CHARTTYPE_PIE = 0;
WR.Charts.ChartBox.CHARTTYPE_BAR = 1;
WR.Charts.ChartBox.CHARTTYPE_LINE = 2;

/* Data Types */
WR.Charts.ChartBox.DATATYPE_PROPERTIES = 3;
WR.Charts.ChartBox.DATATYPE_HISTORICAL = 4;

/*  View modes */
WR.Charts.ChartBox.CONFIGURATION_VIEW = 0;
WR.Charts.ChartBox.PRESENTATION_VIEW = 1;

/* Colors */
WR.Charts.ChartBox.COLORS = [ "#3d6c9a", "#f94a4a", "#73d486", "#f6e17f", "#f47f55", "#72d4cf", "#62a9d1", "#a56ccf",
                       "#ff8dda", "#ffccff", "#afa8ef", "#f3d3c2", "#ccf397", "#f58282", "#f5b25c", "#c1c2c1"];


WR.Charts.ChartBox.prototype = {
    
    serializeForHistory : function()
    {
        return {
            configuration: this.configuration.serializeForHistory(),
            data: this.data.serializeForHistory()
        };
    },
    
    applyState : function ( state )
    {
        var currentState = JSON.stringify( this.serializeForHistory() );
        if ( currentState == JSON.stringify( state ) ) //Otherwise we refresh every chart as many times as there are charts!
            return;
        
        var me = this;
        this.configuration.applyState( state.configuration, state.rawData, function() { //have to wait for results to come back before applying data state
            me.chartManager.history.runWhileIgnoringUpdates( function() {
                if ( me.configuration.dataType == WR.Charts.ChartBox.DATATYPE_PROPERTIES )
                {
                    me.configuration.unloadedData.applyState( state.data );
                    me.data = me.configuration.unloadedData.copy();
                }
                me.configuration.refresh();
                me.applyConfiguration();
            } );
        });
    },
    
    
    
    _initUI : function()
    {
        this._initPresentationUI();
        this._initConfigurationUI();
        this._initContainerUI();
    },
    
    _initPresentationUI : function()
    {
        this.presentationDiv = new WR.DOM.Element( 'div' )
            .setProperty( 'id', this.id + '_presentation' )
            .setProperty( 'className', 'chartboxpresentation' )
            .appendChild( WR.DOM.el( 'label' )
                .addClass( 'chart-title' )
                .setProperty( 'id', this.id + '_titleLabel' )
                .finish() )
            .appendChild( WR.DOM.el( 'br' ).finish() );
        
        this.chartGraph.addTo( this.presentationDiv );
        this.chartSummary.addTo( this.presentationDiv );
    },
    
    _initConfigurationUI : function()
    {
        this.configurationDiv = this.configuration.generateConfigurationUI( WR.DOM.el( 'div' ) );
    },
    
    _initContainerUI : function()
    {
        this.innerDiv = new WR.DOM.Element( 'div' )
            .setProperty( 'id', this.id + '_inner' )
            .setProperty( 'className', 'chartboxinner' )
            .appendChild( this.presentationDiv.finish() )
            .appendChild( this.configurationDiv.finish() )
        
        this.outerDiv = new WR.DOM.Element( 'div' )
            .setProperty( 'id', this.id )
            .addClass( 'chartboxouter' )
            .appendChild( this.innerDiv.finish() );
        if ( this.dataType == WR.Charts.ChartBox.DATATYPE_PROPERTIES )
            this.outerDiv.addClass( 'PropertiesChart' );
        else if ( this.dataType == WR.Charts.ChartBox.DATATYPE_HISTORICAL )
            this.outerDiv.addClass( 'HistoricalChart' );
        this.chartHoverBox.addTo( this.outerDiv );
        
        var me = this;
        this.outerDiv.addListener( 'mouseover', function(e) {
            if ( me.chartHoverBox.enableHoverBox )
                me.chartHoverBox.cancelFadeAnimation();
        } );
        this.outerDiv.addListener( 'mouseout', function(e) {
            if ( me.chartHoverBox.enableHoverBox )
                me.chartHoverBox.startFadeAnimation();
        } );
    },
    
    domReady : function()
    {
        this.configuration.domReady();
    },
    
    generateClass : function( className )
    {
        return '#' + this.id + ' .' + className;
    },
    
    _createSwitchingAnimation : function ( fadingClass, risingClass )
    {
        var firstHalf = this._createSwitchingAnimationHalf( fadingClass, risingClass, true );
        var secondHalf = this._createSwitchingAnimationHalf( fadingClass, risingClass, false );
        firstHalf.onComplete.subscribe( function() { secondHalf.animate(); } );
        
        var me = this;
        firstHalf.onComplete.subscribe( function() { me.chartManager.resize(); } );
        
        return firstHalf;
    },
    
    _createSwitchingAnimationHalf : function( fadingClass, risingClass, fading )
    {
        var animation = new YAHOO.util.Anim();
        animation.duration = 0.3;
        animation.method = YAHOO.util.Easing.easeIn;
        
        if ( $.support.opacity )
        {
            animation.onTween.subscribe( function( type, data ) {
                var factor = data[0].duration / ( animation.duration * 1000 );
                var opacity = factor;
                if ( fading )
                    opacity = 1 - opacity;
                                
                var cssClass = fading? fadingClass : risingClass;
                $( cssClass ).css( { opacity: opacity } );
            });
        }
        
        var me = this;
        animation.onComplete.subscribe( function() {
            if ( fading )
            {
                $( fadingClass ).css( {  display: 'none'  } );
                $( risingClass ).css( {  display: 'block' } );
            }
        });
        
        return animation;
    },
    
    _initAnimation : function()
    {
        var presentationClass = this.generateClass( 'chartboxpresentation' );
        var configurationClass = this.generateClass( 'chartboxconfiguration' );
        this.switchToConfigurationAnimation = this._createSwitchingAnimation( presentationClass, configurationClass );
        this.switchToPresentationAnimation = this._createSwitchingAnimation( configurationClass, presentationClass );
        //This actually adds it to the end of the first half
        var me = this;
        this.switchToPresentationAnimation.onComplete.subscribe( function() {  
            me.draw();
            (new WR.DOM.Element( YAHOO.util.Dom.get( me.id + '_applyLink' ) ) ).innerHTML( '<?jformat Apply?>' );
            me.graphHasBeenCreated = true;
            me.currentView = WR.Charts.ChartBox.PRESENTATION_VIEW;
			WR.ApplyIEPrintablChartFixes( me.id );
        } );
        
        this.switchToConfigurationAnimation.onComplete.subscribe( function() {
            me.currentView = WR.Charts.ChartBox.CONFIGURATION_VIEW;
            me.chartHoverBox.startFadeAnimation();
        } );
        
    },
    
    draw : function()
    {
        WR.DOM.el( YAHOO.util.Dom.get( this.id + '_titleLabel' ) ).innerHTML( WR.HTML.escape( this.configuration.title ) );
        if ( this.configuration.showGraph )
        {
            $( this.generateClass( 'chartgraph' ) ).css( {  display: 'block'  } );
            this.chartGraph.draw();
        }
        else
        {
            $( this.generateClass( 'chartgraph' ) ).css( {  display: 'none'  } );
        }
        
        if ( this.configuration.showTable )
        {
            $( this.generateClass( 'chartsummary' ) ).css( {  display: 'block'  } );
            this.chartSummary.draw();
        }
        else
        {
            $( this.generateClass( 'chartsummary' ) ).css( {  display: 'none'  } );
        }
        
        this.chartManager.resize();
    },
    
    addTo : function( div )
    {
        div.appendChild( this.outerDiv.finish() );
    },
    
    hide : function()
    {
        this.isVisible = false;
        this.outerDiv.addClass( 'invisible' );
    },
    
    show : function()
    {
        this.isVisible = true;
        this.outerDiv.removeClass( 'invisible' );
    },
    
    applyConfiguration : function()
    {
        this.chartManager.updateHistory();
        this.switchToPresentationView();
        this.chartHoverBox.enableHoverBox = true;
    },
    
    switchToConfigurationView : function()
    {
        this.switchToConfigurationAnimation.animate();
    },
    
    switchToPresentationView :  function()
    {
        this.switchToPresentationAnimation.animate();
    },
    
    generatePieData : function()
    {
       return this.data.generatePieData();
    },
    
    generateBarData : function()
    {
        return this.data.generateBarData();
    },
    
    generateLineData : function()
    {
        return this.data.generateLineData();
    },
    
    generateSummaryData : function()
    {
        return this.data.generateSummaryData();
    },
    
    generateGroupingData : function()
    {
        return this.data.generateGroupingData();
    },
    
    filterChanged : function( xml )
    {
        var callback = null;
        
        var me = this;
        if ( this.currentView == WR.Charts.ChartBox.CONFIGURATION_VIEW && this.configuration.isLoadingResults )
        {
            callback = function()
            {
                me.configuration.refresh();
                me.applyConfiguration();
            }
        }
        else if ( this.currentView == WR.Charts.ChartBox.PRESENTATION_VIEW )
            callback = function() { me.draw(); };
        
        this.configuration.filterChanged( xml, callback );
    }
    
};
