// ChartData.js

// <?import /JavaScript/Charts/Charts.js?>
// <?import /JavaScript/Charts/Result.js?>
// <?import /JavaScript/Charts/Series.js?>

// rawData comes in the form that the server returns
WR.Charts.ChartData = function( rawData )
{
    this.series = [];
    this.numToShow = 10;
    
    this.replaceData( rawData );
};

WR.Charts.ChartData.prototype = {
    
    serializeForHistory : function()
    {
        var seriesSerialized = [];
        for ( i in this.series )
        {
            seriesSerialized.push( this.series[i].serializeForHistory() );
        }
        
        return {
            numToShow: this.numToShow,
            series: seriesSerialized
        };
    },
    
    applyState : function( state )
    {
        if ( state == null )
            return;
        
        this.numToShow = state.numToShow;
        for ( i in state.series )
        {
            while ( i >= this.series.length )
                this.series.push( new WR.Charts.Series( {} ) );
            this.series[i].applyState( state.series[i] );
        }
    },
    
    replaceData : function( rawData )
    {
        this.rawData = rawData;
    
        if ( this.series.length > rawData.length )
            this.series.splice( this.series.length, rawData.length - this.series.length );
        
        for ( var i in rawData )
        {
            if ( i < this.series.length )
                this.series[i].replaceData( rawData[i] );
            else
                this.series.push( new WR.Charts.Series( rawData[i] ) );
        }
    },
    
    copy : function()
    {
        var newChartData = new WR.Charts.ChartData( this.rawData );
        newChartData.applyState( this.serializeForHistory() );
        return newChartData;
    },
    
    getNumResults : function( seriesNo )
    {
        return this.series[0].getNumResults();
    },
    
    getNumGroupedResults: function()
    {
        return this.series[0].getNumGroupedResults();
    },
    
    getGroup: function( seriesNo, groupId )
    {
        return this.series[seriesNo].getGroup( groupId );
    },
    
    addNewGroup : function( groupName, seriesNo )
    {
        return this.series[seriesNo].addNewGroup( groupName );
    },
    
    removeGroup : function( groupId, seriesNo )
    {
        return this.series[seriesNo].removeGroup( groupId );
    },
    
    addResultToGroup : function( seriesNo, groupId, resultId )
    {
        this.series[seriesNo].addResultToGroup( groupId, resultId );    
    },
    
    removeFromGroup : function( seriesNo, groupId, resultId )
    {
        this.series[seriesNo].removeFromGroup( groupId, resultId );    
    },
    
    setGroupName : function( groupId, name, seriesNo )
    {
        this.series[seriesNo].setGroupName( groupId, name );
    },
    
    expandGroup : function( seriesNo, groupId )
    {
        this.series[seriesNo].expandGroup( groupId );
    },
    
    collapseGroup : function( seriesNo, groupId )
    {
        this.series[seriesNo].collapseGroup( groupId );
    },
    
    restrictVisibleTo : function( numToShow )
    {
        this.numToShow = numToShow;
    },
    
    /**
     * generates jqPlot formatted data to display a pie chart.  Only allows a single series.
     */
    generatePieData : function()
    {   
        var series0 = this.series[0].generatePieData();
        if ( series0.length <= this.numToShow )
            return [ series0 ];
        
        var unOtheredEntities = series0.splice( series0.length - ( this.numToShow - 1 ), ( this.numToShow - 1 ) );
        
        var count = 0;
        for ( i in series0 )
        {
            count += series0[i][1];
        }
        
        series0 = [ [ '<?jformat Other?>', count ] ].concat( unOtheredEntities );
        return [ series0 ];
    },
    
    /**
     * generates jqPlot formatted data to display a bar chart.  Only allows a single series (for now).
     */
    generateBarData : function()
    {
        var series0 = this.series[0].generateBarData();
        if ( series0.values.length <= this.numToShow )
            return series0 ;
       
        var extraCounts = series0.counts[0].splice( this.numToShow - 1, series0.counts[0].length - ( this.numToShow - 1) );
        series0.values.splice( this.numToShow - 1, series0.values.length - ( this.numToShow - 1 ) );
        
        var count = 0;
        for ( i in extraCounts )
        {
             count += extraCounts[i];
        }
        
        series0.values.push( '<?jformat Other?>' );
        series0.counts[0].push( count );
        return series0 ;
    },
    
    generateLineData : function()
    {
        var data = [];
        for ( i in this.series )
        {
            data.push( this.series[i].generateLineData() );
        }
        
        return data;
    },
    
    /**
     * generates YUI data table formatted data.  Only allows a single series (for now).
     */
    generateSummaryData : function()
    {
        var series0 = this.series[0].generateSummaryData();
        if ( series0.length <= this.numToShow )
        {
            for ( var i in series0 )
            {
                series0[i].entryNumber = i;
            }
            return series0 ;
        }
        
        var totalCount = 0;
        for ( var i in series0 )
        {
            totalCount += series0[i].count;
        }
        
        var extraEntries = series0.splice( this.numToShow - 1, series0.length - ( this.numToShow - 1 ) );
        
        var count = 0;
        for ( i in extraEntries )
        {
             count += extraEntries[i].count;
        }
        
        var otherObject = new WR.Charts.Result( -1,'<?jformat Other?>', count ).generateSummaryData( this.series[0].propertyId, totalCount );
        series0.push( otherObject );
        
        for ( i in series0 )
        {
            series0[i].entryNumber = i;
        }
        
        return series0;
    },
    
    /**
     * Generates YUI TreeView formatted data.  Only allows a single series.
     */
    generateGroupingData : function()
    {
        return this.series[0].generateGroupingData(); 
    }
    
};
