// ChartManager.js

// <?import /JavaScript/jQuery/jquery.js?>

// <?import /JavaScript/Charts/Charts.css?>
// <?import /JavaScript/Charts/Charts.js?>
// <?import /JavaScript/Charts/ChartBox.js?>
// <?import /JavaScript/Charts/Graph.js?>
// <?import /JavaScript/Charts/SummaryTable.js?>
// <?import /JavaScript/Charts/ChartData.js?>
// <?import /JavaScript/Charts/Series.js?>
// <?import /JavaScript/Charts/Group.js?>
// <?import /JavaScript/Charts/Result.js?>
// <?import /JavaScript/Charts/HoverBox.js?>
// <?import /JavaScript/Charts/Configuration.js?>
// <?import /JavaScript/Charts/PropertiesConfiguration.js?>
// <?import /JavaScript/Charts/HistoricalConfiguration.js?>
// <?import /JavaScript/Properties/PropertiesDataSource.js?>

//<?import /JavaScript/CollapsibleSection/CollapsibleSectionWithSpecialHeader.js?>

// <?import /JavaScript/jq-import/ui/Sortable.js?>

// <?import /JavaScript/yui/build/yahoo/yahoo.js?>

WR.Charts.ChartManager = function( divId, properties, addChartLinkText, makeCollapsible )
{  
    this.charts = new Array();
    this.div = new WR.DOM.Element( YAHOO.util.Dom.get( divId ) )
    this.divId = divId;
    this.propertiesDataSource = new WR.PropertiesDataSource( properties );
    
    var me = this;
    new WR.DOM.Element( window ).addListener( 'resize', function( e ) { me.resize(); } );
    $('#' + divId ).sortable( { handle: '.chartboxhandle', tolerance: 'pointer', stop:
                             function( event, ui )
                             {
                                me.updateHistory();
                                me.resize();
                             } } );
    
    var addChartLink = WR.HTMLGenerator.createJavaScriptLink( addChartLinkText, function( me )
    {  
        me.collapsibleSection.forceVisibility( true );
        var newChart = new WR.Charts.ChartBox( me, WR.Charts.NewChartType );
        me.addChart( newChart );
    }, this ).setProperty( 'id', 'addChartLink' );
    
    if ( makeCollapsible ) 
        this.collapsibleSection = WR.MakeSectionCollapsibleWithSpecialHeader( YAHOO.util.Dom.get( 'outerChartSection' ), '<?jformat Charts?>', 'Charts', addChartLink );
    
    this.history = new WR.History( this.divId, this, {
        generateState: me.serializeForHistory,
        loadInitialState: me.loadInitialState
    } );
    
    if ( WR.Filters != null )
        WR.Filters.filterChanged.subscribe( this._filterChanged, this );
};

WR.Charts.ChartManager.prototype = {
    
    serializeForHistory : function( me )
    {
        var charts = [];
        
        $( '#' + me.divId + ' .chartboxouter' ).map(
            function( index, el )
            {
                for ( i in me.charts )
                {
                    if ( me.charts[i].id == el.id )
                    {
                        if ( me.charts[i].isVisible )
                            charts.push( me.charts[i].serializeForHistory() );
                        break;
                    }
                }
            }
        );
        
        return charts;
    },
    
    updateHistory : function()
    {
        this.history.update();
    },
    
    loadInitialState: function( state, me )
    {
        WR.History.onLoadComplete.subscribe(
            function()
            {
                me.loadCharts( state );
            } );
    },
    
    loadCharts: function( state )
    {
        var me = this;
        
        if ( state != null && me.collapsibleSection != null && WR.CollapsibleSection.History != null )
            WR.CollapsibleSection.History.runWhileIgnoringUpdates(
                function()
                {
                    me.collapsibleSection.forceVisibility( true )
                }
            );
        
        me.history.runWhileIgnoringUpdates(
            function()
            {    
                for ( i in state )
                {
                    if ( me.charts.length > i )
                    {
                        me.charts[i].applyState( state[i] );
                    }
                    else
                    {
                        var dataType = state[i].configuration.dataType;
                
                        var newChart;
                        if ( dataType == WR.Charts.ChartBox.DATATYPE_PROPERTIES )  
                            newChart = new WR.Charts.ChartBox( me, WR.Charts.ChartBox.DATATYPE_PROPERTIES );
                        else if ( dataType == WR.Charts.ChartBox.DATATYPE_HISTORICAL )  
                            newChart = new WR.Charts.ChartBox( me, WR.Charts.ChartBox.DATATYPE_HISTORICAL );
                        me.addChart( newChart );
                        newChart.applyState( state[i] );
                    }
                }
            } );
    },
    
    addChart : function( chartBox ) 
    {
        this.charts.push( chartBox );
        chartBox.addTo( this.div );
        chartBox.domReady();
        this.resize();
    },
    
    removeChart : function( chartBox )
    {
        chartBox.hide();
        this.updateHistory();
        this.resize();
    },
    
    moveChart : function( fromLocation, toLocation )
    {
        //TODO: implement this
    },
    
    draw : function()
    {
        for( i in this.charts )
        {
            if ( this.charts[i].isVisible )
                this.charts[i].draw();
        }
    },
    
    getRow : function( chartBox )
    {
        var numChart = 0;
        for( i in this.charts )
        {
            if ( this.charts[i].isVisible )
            {
                if ( chartBox == this.charts[i] )
                    return Math.floor( numChart / 2 );
                
                numChart++;
            }
        }
        
        return -1; //Something's wrong, this chart wasn't in the list of charts
    },
    
    resize: function()
    {
        this._resizeWithWhitespace();
        this._resizeChartSection();
    },
    
     _resizeChartSection : function()
    {
        var max = 0;
        var min = 10000000;
        for ( i in this.charts )
        {
            if ( this.charts[i].isVisible )
            {
                var chartRegion = YAHOO.util.Region.getRegion( this.charts[i].outerDiv.finish() );
                if ( chartRegion.bottom > max )
                    max = chartRegion.bottom;
                if ( chartRegion.top < min )
                    min = chartRegion.top;
            }
        }
        
        if ( max == 0 )
            min = 0;
            
        $( '#chartSection' ).css( {  height: ( max - min + 30 ) + 'px'  } );
    },
    
    _resizeWithWhitespace : function()
    {
        var chartIndices = [];
        var children = YAHOO.util.Dom.getChildren( YAHOO.util.Dom.get( this.div.finish() ) );
        
        for( childIndex in children )
        {
            var chartDiv = children[childIndex];
            var id = YAHOO.util.Dom.getAttribute( chartDiv, 'id' );
            if ( id != null )
            {
                id = id.slice( 'WR_ChartBox_'.length );
                if ( id.length > 0 )
                    chartIndices.push( id );
            }
        }
        
        var lastTop = 0;
        var row = -1;
        var maxForRow = [];
        for( chartIndex in chartIndices )
        {
            var chart = this.charts[chartIndices[chartIndex]];
            
            if ( chart.isVisible )
            {
                var height = chart.innerDiv.finish().clientHeight;
                lastTop = top;
                var top = $( chart.innerDiv.finish() ).offset().top;
                if ( top != lastTop )
                    row++;
                
                if ( maxForRow.length - 1 < row )
                    maxForRow.push( 0 );
                
                chart.outerDiv.setProperty( 'className', 'chartboxouter chartrow' + row );
                
                if ( chart.dataType == WR.Charts.ChartBox.DATATYPE_PROPERTIES )
                    chart.outerDiv.addClass( 'PropertiesChart' );
                else if ( chart.dataType == WR.Charts.ChartBox.DATATYPE_HISTORICAL )
                    chart.outerDiv.addClass( 'HistoricalChart' );
                
				if( !YAHOO.env.ua.gecko )
					chart.outerDiv.addClass( 'NonFFChartBoxOuter' );
				
                if ( height > maxForRow[row] )
                    maxForRow[row] = height;
            }
        }
        
        for ( i in maxForRow )
        {
            $( '.chartrow' + i ).css( {  height: maxForRow[i] + 'px'  } );
        }
    },
    
    _filterChanged : function( type, args, me )
    {
        if ( !WR.History.isLoadComplete )
            return;
        
        for ( i in me.charts )
        {
            me.charts[i].filterChanged( args[0] );
        }
    }
    
};


