// ChartGroup.js

// <?import /JavaScript/Util/HTML.js?>
// <?import /JavaScript/Charts/Charts.js?>

// rawData is the raw data for this series that came from the server
WR.Charts.Group = function( id, name, series )
{
    this.name = name;
    this.series = series;
    this.id = id;
    this.expanded = true;
    
    /**
     * A list of the indices in this.chartSeries.results that are the values in this group
     */
    this.members = [];
};

WR.Charts.Group.prototype = {
    
    serializeForHistory : function()
    {
        var entries = [];
        for ( i in this.members )
        {
            entries.push( this.series.results[this.members[i]].name );
        }
        
        return {
            name: this.name,
            entries: entries
        };
    },
    
    addMember : function( resultId )
    {
        this.members.push( resultId );
    },
    
    removeMember : function( resultId )
    {
        for ( i in this.members )
        {
            if ( this.members[i] == resultId )
            {
                delete this.members[i];
                break;
            }
        }
    },
    
    getNumChildren : function()
    {
        var count = 0;
        for ( i in this.members ) //Doesn't iterate on members that have been deleted
            count++;
        
        return count;
    },
    
    convertToNewData : function( newData )
    {
        var newMembers = [];
        for ( var i in this.members )
        {
            var found = false;
            for ( var j in newData.values )
            {
                if ( newData.values[j] == this.series.results[this.members[i]].name )
                {
                    newMembers.push( j );
                    found = true;
                }
            }
        }
        
        this.members = newMembers;
    },
    
    generatePieData : function()
    {
        return [ this.name, this.getCount() ];
    },
    
    generateBarData : function()
    {
        return { name: this.name, count: this.getCount() };
    },
    
    generateLineData : function()
    {
        
    },
    
    generateSummaryData : function( propertyId, totalCount )
    {
        var count = this.getCount();
        var dataObject = { count : count, percent : ( 100 * count / totalCount ) };
        dataObject[ propertyId ] = WR.HTML.escape( this.name );
        return dataObject;
    },
    
    generateGroupingData : function()
    {
        var data = {
            type : 'Text',
            editable : true,
            expanded : this.expanded,
            children: [],
            name: this.name,
            groupId: this.id,
            resultId: -1,
            isGroup: true
        }
        
        for ( i in this.members )
        {
            data.children.push( this.series.results[this.members[i]].generateGroupingData() );
        }
        
        
        var count = this.getCount();
        
        data.label = WR.HTML.escape( this.name + '  (' + count + ')' );
        data.count = count;
        
        return data;
    },
    
    getCount : function()
    {
        var count = 0;
        for ( i in this.members )
        {
            count += this.series.results[this.members[i]].count;
        }
        
        return count;
    }
    
};
