// HistoricalConfiguration.js

// <?import /JavaScript/Charts/Charts.css?>
// <?import /JavaScript/Util/HTMLGenerator.js?>
// <?import /JavaScript/Charts/Charts.js?>
// <?import /JavaScript/Util/Array.js?>
// <?import /JavaScript/Charts/ChartBox.js?>
// <?import /JavaScript/Notification/Notification.js?>
// <?import /JavaScript/Util/JSONRequest.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/Charts/Configuration.js?>

// <?import /JavaScript/json2.js?>
// <?import /JavaScript/yui-import/Dom.js?>
// <?import /JavaScript/yui-import/YahooGlobalObject.js?>

// <?import /JavaScript/jQuery/jquery.js?>
// <?import /JavaScript/jq-import/ui/DatePicker.js?>


WR.Charts.HistoricalConfiguration = function( chartBox )
{
    WR.Charts.HistoricalConfiguration.superclass.constructor.call( this, chartBox );
    
    this.dataType = WR.Charts.ChartBox.DATATYPE_HISTORICAL;
    this.chartType = WR.Charts.ChartBox.CHARTTYPE_LINE;
    this.showGraph = true;
    this.showTable = false;
    this.requestDataConnection = null;
};

WR.Charts.HistoricalConfiguration.prototype = {
    
    generateConfigurationUI : function()
    {
        this.startDatePickerField = WR.DOM.el( 'input' )
            .addClass( 'DatePickerField' );
        this.startTimePickerField = this._createTimeSelector()
            .addClass( 'TimePickerField' );
            
        this.endDatePickerField = WR.DOM.el( 'input' )
            .addClass( 'DatePickerField' )
        this.endTimePickerField = this._createTimeSelector()
            .addClass( 'TimePickerField' );
        
        var me = this;
        var div = new WR.DOM.Element( 'div' )
            .setProperty( 'id', this.chartBox.id + '_configuration' )
            .addClass( 'chartboxconfiguration' )
            .appendChild( WR.DOM.el( 'img' )
                         .setProperty( 'src', '/JavaScript/yui/build/assets/skins/sam/ajax-loader.gif' )
                         .addClass( 'invisible' )
                         .addClass( 'Spinner' )
                         .finish() );
        
        WR.Charts.HistoricalConfiguration.superclass.generateConfigurationUI.call( this, div );

        div.appendChild( WR.DOM.el( 'div' )
                .setProperty( 'id', 'datePickingDiv' )
                .appendChild( WR.DOM.el( 'label' )
                    .addClass( 'HistoricalConfigSectionTitle' )
                    .innerText( '<?jformat Time Span?>' )
                    .finish() )
                .appendChild( WR.DOM.el( 'div' )
                    .setProperty( 'id', 'startDatePickingDiv' )
                    .appendChild( WR.DOM.el( 'label' ).innerText( '<?jformat Start date:?>' ).finish() )
                    .appendChild( this.startDatePickerField.finish() )
                    .appendChild( this.startTimePickerField.finish() )
                    .finish() )
                .appendChild( WR.DOM.el( 'div' )
                    .setProperty( 'id', 'endDatePickingDiv' )
                    .appendChild( WR.DOM.el( 'label' ).innerText( '<?jformat End date:?>' ).finish() )
                    .appendChild( this.endDatePickerField.finish() ) 
                    .appendChild( this.endTimePickerField.finish() ) 
                    .finish() )
                .finish() )
            .appendChild( WR.DOM.el( 'div' )
                .setProperty( 'id', 'groupIntervalDiv' )
                .appendChild( WR.DOM.el( 'label' ).innerText( '<?jformat Group By:?>' ).finish() )
                .appendChild( WR.HTMLGenerator.createRadioButton( this.chartBox.id + '_groupInterval' )
                    .setProperty( 'id', 'groupByHourRadio' )
                    .setProperty( 'value', 'hour' )
                    .setProperty( 'disabled', 'disabled' )
                    .addClass( 'GroupIntervalRadio' )
                    .finish() )
                .appendChild( WR.DOM.el( 'label' )
                    .setProperty( 'for', 'groupByHourRadio' )
                    .innerText( '<?jformat Hour?>' )
                    .addClass( 'GroupIntervalLabel' )
                    .finish() )
                .appendChild( WR.HTMLGenerator.createRadioButton( this.chartBox.id + '_groupInterval' )
                    .setProperty( 'id', 'groupByDayRadio' )
                    .setProperty( 'value', 'day' )
                    .setProperty( 'checked', 'true' )
                    .setProperty( 'defaultChecked', 'true' )
                    .addClass( 'GroupIntervalRadio' )
                    .finish() )
                .appendChild( WR.DOM.el( 'label' )
                    .setProperty( 'for', 'groupByDayRadio' )
                    .innerText( '<?jformat Day?>' )
                    .addClass( 'GroupIntervalLabel' )
                    .finish() )
                .appendChild( WR.HTMLGenerator.createRadioButton( this.chartBox.id + '_groupInterval' )
                    .setProperty( 'id', 'groupByWeekRadio' )
                    .setProperty( 'value', 'week' )
                    .addClass( 'GroupIntervalRadio' )
                    .finish() )
                .appendChild( WR.DOM.el( 'label' )
                    .setProperty( 'for', 'groupByWeekRadio' )
                    .innerText( '<?jformat Week?>' )
                    .addClass( 'GroupIntervalLabel' )
                    .finish() )
                .finish() );
                             
        this.addApplyConfirmDiv( div );
        
        return div;
    },
    
    _updateGroupingOptions : function()
    {
        try {
            var startDate = $.datepicker.parseDate( $.datepicker._defaults.dateFormat, $( this.startDatePickerField.finish() ).val() )
            var endDate = $.datepicker.parseDate( $.datepicker._defaults.dateFormat, $( this.endDatePickerField.finish() ).val() )
        }
        catch( e ){
            $( '#' + this.chartBox.id + ' #groupByHourRadio' ).prop( 'disabled', true );
            return;
        }
        
        if ( startDate == null || endDate == null )
        {
            $( '#' + this.chartBox.id + ' #groupByHourRadio' ).prop( 'disabled', true );
            return;
        }
        
        var differenceInMilliseconds = endDate.getTime() - startDate.getTime();
        var oneMonthInMilliseconds = 1000 * 60 * 60 * 24 * 30;
        
        if ( differenceInMilliseconds < oneMonthInMilliseconds )
            $( '#' + this.chartBox.id + ' #groupByHourRadio' ).prop( 'disabled', false );
        else
            $( '#' + this.chartBox.id + ' #groupByHourRadio' ).prop( 'disabled', true );
    },
    
    _updateCreateChartEnabled : function()
    {
        this.readConfigurationFromUI();
        
        if ( this.showTotalComputers || this.showAffectedComputers || this.showRelevantIssues || this.showAverageRelevantIssues )
        {
            var me = this;
            $( '#' + this.chartBox.id + '_applyLink' ).removeClass( 'wr_disabled' ).unbind( 'click' )
                .bind( 'click', function( e ) {
                    me._applyChanges();
                } );
        }
        else
        {
            $( '#' + this.chartBox.id + '_applyLink' ).addClass( 'wr_disabled' )
                .unbind( 'click' );
        }
        
    },
    
    serializeForHistory : function()
    {
        var config = WR.Charts.HistoricalConfiguration.superclass.serializeForHistory.call( this );
        
        config.startDate = this.startDate;
        config.endDate = this.endDate;
        config.startTime = this.startTime;
        config.endTime = this.endTime;
        config.groupingInterval = this.groupingInterval;
        
        return config;
    },
    
    applyState : function( state, rawData, onCompletion )
    {
        WR.Charts.HistoricalConfiguration.superclass.applyState.call( this, state, onCompletion );
        
        this.startDate = state.startDate;
        this.endDate = state.endDate;
        this.startTime = state.startTime;
        this.endTime = state.endTime;
        this.groupingInterval = state.groupingInterval;
        
        this.writeConfigurationToUI();
        
        if ( rawData == null )
        {
            var me = this;
            this._requestData( { success: function( response )
                                {
                                    me.chartBox.data.replaceData( response );
                                    onCompletion();
                                } } );
        }
        else
        {
            this.chartBox.data.replaceData( rawData );
            onCompletion();
        }
    },
    
    refresh : function()
    {
        
    },
    
    domReady : function()
    {
        WR.Charts.HistoricalConfiguration.superclass.domReady.call( this );
        
        this._setupDatePickingLayout();
        
        var me = this;
        $( '.chartboxconfigurationconfirmapply').removeClass( 'wr_disabled' );
        
        $( '#' + me.chartBox.id + '_applyLink' ).bind( 'click', function( e ) {
            me._applyChanges();
        } );
        
        $( this.startDatePickerField.finish() )
            .datepicker( { constrainInput: false } )
            .change( function() { me._updateGroupingOptions(); } );
        $( this.endDatePickerField.finish() )
            .datepicker( { constrainInput: false } )
            .change( function() { me._updateGroupingOptions(); } );
        $( '#ui-datepicker-div' ).css( 'display', 'none' );
                
        new WR.DefaultTextField( this.startDatePickerField.finish(), '<?jformat Earliest Date?>' );
        new WR.DefaultTextField( this.endDatePickerField.finish(), '<?jformat Latest Date?>' );
        
        this.readConfigurationFromUI();
        this.writeConfigurationToUI();
    },
    
    _setupDatePickingLayout : function()
    {
        if ( jQuery.browser.msie && jQuery.browser.version == '7.0' )
            $( '#datePickingDiv' ).css( 'margin-left', '0px' );        
    },
    
    _applyChanges : function()
    {
        var me = this;
        
        this.readConfigurationFromUI();
        this._requestData( { success: function( response )
                        {
                            me.chartBox.data.replaceData( response );
                            me.chartBox.applyConfiguration();
                        } } );
    },
    
    _createTimeSelector : function()
    {
        var names = [];
        var values = [];
        
        for ( var h = 0; h < 24; h++ )
        {
            for ( var m = 0; m < 60; m += 15 )
            {
                var amPM = h > 12? 'PM' : 'AM';
                var displayHour = h;
                if ( h > 12 )
                    displayHour = h - 12;
                else if ( h == 0 )
                    displayHour = 12;
                
                var displayMin = m;
                if ( m < 10 )
                    displayMin = '0' + m;
                
                names.push( displayHour + ':' + displayMin + ' ' + amPM );
                values.push( h + ':' + displayMin );
            }
        }
        
        return WR.HTMLGenerator.createSelectFromEscapedEntries( '', names, '', values );
    },
    
    generateRequestParams : function()
    {
        return {
            dataType:this.dataType,
            startTime: this.startDate + ' ' + this.startTime,
            endTime: this.endDate + ' ' + this.endTime,
            groupingInterval: this.groupingInterval
        };
    },
    
    _hideSpinner : function()
    {
        this.isLoadingResults = false;
        $( '#' + this.chartBox.id + ' .Spinner' ).hide();
    },
    
    _showSpinner : function()
    {
        this.isLoadingResults = true;
        $( '#' + this.chartBox.id + ' .Spinner' ).show();
    },
    
    _requestData : function( callbacks )
    {
        if ( this.requestDataConnection != null && this.requestDataConnection.isInProgress() )
            this.requestDataConnection.abort();
        
        this._showSpinner();
        WR.jsonRequest( 'chartdata', {
            success: function( o, me ) {
                me._hideSpinner();
                callbacks.success( o, me );
            },
            failure: callbacks.failure,
            start : function( connection, me )
            {
                me.requestDataConnection = connection;
            }
        }, this.generateRequestParams(), this );
    },
    
    writeConfigurationToUI : function()
    {
        WR.Charts.HistoricalConfiguration.superclass.writeConfigurationToUI.call( this );
        
        if ( this.startDate )
            $( this.startDatePickerField.finish() ).datepicker( 'setDate', $.datepicker.parseDate( 'yy-mm-dd',this.startDate ) );
        if ( this.endDate )
            $( this.endDatePickerField.finish() ).datepicker( 'setDate',  $.datepicker.parseDate( 'yy-mm-dd',this.endDate ) );
        if( this.startTime )    
            $( this.startTimePickerField.finish() ).val( this.startTime );
        if ( this.endTime )
            $( this.endTimePickerField.finish() ).val( this.endTime );
        
        $( '#' + this.chartBox.id + ' .GroupIntervalRadio[value=' + this.groupingInterval + ']' ).prop( 'checked', true );
    },
    
    readConfigurationFromUI : function()
    {
        WR.Charts.HistoricalConfiguration.superclass.readConfigurationFromUI.call( this );
        
        try {
            this.startDate = $.datepicker.formatDate( 'yy-mm-dd', $.datepicker.parseDate( $.datepicker._defaults.dateFormat, $( this.startDatePickerField.finish() ).val() ) );
        }
        catch( e ){
            this.startDate = null;
        }
        
        try {
            this.endDate = $.datepicker.formatDate( 'yy-mm-dd', $.datepicker.parseDate( $.datepicker._defaults.dateFormat, $( this.endDatePickerField.finish() ).val() ) );            
        }
        catch( e ) {
            this.endDate = null;
        }
        this.startTime = $( this.startTimePickerField.finish() ).val();
        this.endTime = $( this.endTimePickerField.finish() ).val();
        
        this.groupingInterval = $( '#' + this.chartBox.id + ' .GroupIntervalRadio:checked' ).val();
    },
    
    filterChanged : function( xml, callback )
    {
        var me = this;
        this._requestData( { success: function( response )
                            {
                                me.chartBox.data.replaceData( response );
                                if ( callback != null ) 
                                    callback();
                            } } );
    }
};

YAHOO.lang.extend( WR.Charts.HistoricalConfiguration, WR.Charts.Configuration, WR.Charts.HistoricalConfiguration.prototype );
