// ChartHoverBox.js

// <?import /JavaScript/Charts/Charts.css?>
// <?import /JavaScript/Charts/Charts.js?>
// <?import /JavaScript/Util/DOM.js?>

// <?import /JavaScript/yui-import/Animation.js?>
// <?import /JavaScript/jQuery/jquery.js?>


WR.Charts.HoverBox = function( chartBox )
{
    this.id = 'WR_ChartHoverBox_' + WR.Charts.HoverBox._nextIdNo++;
    this.chartBox = chartBox;
   
    this.isFading = false;
    this.mouseIsOverChart = false;
    this.opacity = 1.0;
    this.enableHoverBox = false;
   
    this.div = new WR.DOM.Element( 'div' );
    this.div.setProperty( 'id', this.id );
    this.div.setProperty( 'className', 'charthoverbox' );
    
    this.innerBox = WR.DOM.el( 'div' ).setStyle( 'display', 'none' );
    this.div.appendChild( this.innerBox.finish() );
    
    var me = this;
    
    this.deleteButton = new WR.DOM.Element( 'input' );
    this.deleteButton.setProperty( 'type', 'image' );
    this.deleteButton.setProperty( 'src', '/images/besreports/' + WR.Charts.Language + '/delete.png');
    this.deleteButton.addListener( 'click', function(e) { me.chartBox.chartManager.removeChart( me.chartBox ) } );
    this.innerBox.appendChild( this.deleteButton.finish() );
    
    this.innerBox.appendChild( ( new WR.DOM.Element( 'br' ) ).finish() );
    
    this.configButton = new WR.DOM.Element( 'input' );
    this.configButton.setProperty( 'type', 'image' );
    this.configButton.setProperty( 'src', '/images/besreports/' + WR.Charts.Language + '/wrench.png');
    this.configButton.addListener( 'click', function(e) {
        if ( me.enableHoverBox )
        {
            me.chartBox.switchToConfigurationView();
            me.enableHoverBox = false;
        } } );
    this.innerBox.appendChild( this.configButton.finish() );
    
    this.innerBox.appendChild( ( new WR.DOM.Element( 'br' ) ).finish() );
    
    this.dragHandle = new WR.DOM.Element( 'img' );
    this.dragHandle.setProperty( 'src', '/images/besreports/' + WR.Charts.Language + '/handle.png');
    this.dragHandle.setProperty( 'className', 'chartboxhandle' );
    this.innerBox.appendChild( this.dragHandle.finish() );
    
    this._initAnimation();
        
};

WR.Charts.HoverBox._nextIdNo = 0;

WR.Charts.HoverBox.prototype = {
    
    _initAnimation : function()
    {
        this.animation = new YAHOO.util.Anim( this.id );
        this.animation.duration = 1.5;
        this.animation.method = YAHOO.util.Easing.easeIn;
        
        var me = this;
        this.animation.onTween.subscribe( function( type, data ) {
            var factor = data[0].duration / ( me.animation.duration * 1000 );
            var opacity = 1 - factor;
            $( me.chartBox.generateClass( 'charthoverbox' ) ).css( {  opacity: opacity, filters: 'alpha( opacity=' + ( 100 * opacity ) + ' )'  } );
        });
        this.animation.onComplete.subscribe( function( type, data ) {
            if ( data[0].duration >= 1.5 ) //make sure the animation actually completed
                me.innerBox.setStyle( 'display', 'none' );
        });
    },
    
    cancelFadeAnimation : function()
    {
        this.innerBox.setStyle( 'display', 'block' );
        $( this.chartBox.generateClass( 'charthoverbox' ) ).css( {  opacity: 1, filters: 'alpha( opacity=100 )' } );
        this.animation.stop();
    },
    
    startFadeAnimation: function()
    {
        this.animation.animate();
    },
    
    draw : function()
    {
        
    },
    
    addTo : function( div )
    {
        div.appendChild( this.div.finish() );
    }
    
};
