// PropertiesConfiguration.js

// <?import /JavaScript/yui-import/TreeView.js?>
// <?import /JavaScript/Charts/ChartBox.js?>
// <?import /JavaScript/json2.js?>
// <?import /JavaScript/Charts/PropertiesConfiguration.js?>
// <?import /JavaScript/GroupableTreeView/GroupableTreeView.js?>
// <?import /JavaScript/Charts/ChartData.js?>
// <?import /JavaScript/yui-import/Dom.js?>
// <?import /JavaScript/Properties/PropertiesComboBox.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/Util/Format.js?>
// <?import /JavaScript/Charts/Configuration.js?>
// <?import /JavaScript/yui-import/YahooGlobalObject.js?>
// <?import /JavaScript/jQuery/jquery.js?>
// <?import /JavaScript/Util/JSONRequest.js?>
// <?import /JavaScript/Charts/Charts.css?>
// <?import /JavaScript/Util/HTML.js?>


WR.Charts.PropertiesConfiguration = function( chartBox )
{
    WR.Charts.PropertiesConfiguration.superclass.constructor.call( this, chartBox );
    
    this.dataType = WR.Charts.ChartBox.DATATYPE_PROPERTIES;
    this.requestDataConnection = null;
};

WR.Charts.PropertiesConfiguration.prototype = {
    
    generateConfigurationUI : function( div )
    {
        div.setProperty( 'id', this.chartBox.id + '_configuration' )
            .setProperty( 'className', 'chartboxconfiguration' );
        
        WR.Charts.PropertiesConfiguration.superclass.generateConfigurationUI.call( this, div );
        
        var me = this;
        
        div.appendChild( new WR.DOM.Element( 'label' )
                .innerHTML( '<?jformat Computer property: ?>' )
                .finish() )
            .appendChild( new WR.DOM.Element( 'div' )
                .setProperty( 'id', this.chartBox.id + '_propertyPicker' )
                .finish() )
            .appendChild( new WR.DOM.Element( 'br' ).finish() )
            .appendChild( new WR.DOM.Element( 'br' ).finish() )
            .appendChild( new WR.DOM.Element( 'input' )
                .setProperty( 'type', 'checkbox' )
                .setProperty( 'checked', true )
                .setProperty( 'defaultChecked', true )
                .setProperty( 'id', this.chartBox.id + '_showGraphCheckbox' )
                .finish() )
            .appendChild( new WR.DOM.Element( 'label' )
                .setProperty( 'for', this.chartBox.id + '_showGraphCheckbox' )
                .innerHTML( '<?jformat  Show chart: ?>' )
                .finish() )
            .appendChild( new WR.DOM.Element( 'select' )
                .setProperty( 'id', this.chartBox.id + '_chartTypeSelect' )
                .addListener( 'change', function( e ) { me._chartTypeChanged(); } )
                .appendChild( new WR.DOM.Element( 'option' )
                    .setProperty( 'value', 'pie' )
                    .innerHTML( '<?jformat Pie?>' )
                    .finish() )
                .appendChild( new WR.DOM.Element( 'option' )
                    .setProperty( 'value', 'bar' )
                    .innerHTML( '<?jformat Bar?>' )
                    .finish() )
                .finish() )
            .appendChild( new WR.DOM.Element( 'br' ).finish() )
            .appendChild( new WR.DOM.Element( 'input' )
                .setProperty( 'type', 'checkbox' )
                .setProperty( 'checked', true )
                .setProperty( 'defaultChecked', true )
                .setProperty( 'disabled', true )
                .setProperty( 'id', this.chartBox.id + '_showSummaryCheckbox' )
                .finish() )
            .appendChild( new WR.DOM.Element( 'label' )
                .setProperty( 'for', this.chartBox.id + '_showSummaryCheckbox' )
                .innerHTML( '<?jformat  Show table?>' )
                .finish() );
            
        this.addApplyConfirmDiv( div );
        
        div.appendChild( new WR.DOM.Element( 'br' ).finish() )
            .appendChild( new WR.DOM.Element( 'br' ).finish() )
            .appendChild( new WR.DOM.Element( 'div' )
                .setProperty( 'id', this.chartBox.id + '_grouping' )
                .setProperty( 'className', 'chartboxgrouping' )
                .appendChild( WR.DOM.el( 'div' )
                    .addClass( 'GroupingResultsDiv' )
                    .setProperty( 'id', this.chartBox.id + '_grouping_results' )
                    .finish() )
                .appendChild( WR.DOM.el( 'div' )
                    .addClass( 'chartResultsWarningDiv' )
                    .setStyle( 'display', 'none' )
                    .appendChild( WR.DOM.el( 'label' )
                        .addClass( 'chartResultsWarningLabel' )
                        .finish() )
                    .appendChild( WR.DOM.el( 'div' )
                        .addClass( 'chartResultsWarningLinks' )
                        .appendChild( WR.DOM.el( 'a' )
                            .addClass( 'acceptChartWarningLink' )
                            .setProperty( 'href', 'javascript:void(0)' )
                            .innerText( '<?jformat Continue?>' )
                            .finish() )
                        .appendChild( WR.DOM.el( 'a' )
                            .addClass( 'rejectChartWarningLink' )
                            .setProperty( 'href', 'javascript:void(0)' )
                            .innerText( '<?jformat Cancel?>' )
                            .finish() )
                        .finish() )
                    .finish() )
                .finish() ); 
            
        
        return div;
    },
    
    serializeForHistory : function()
    {
        var config = WR.Charts.PropertiesConfiguration.superclass.serializeForHistory.call( this );
        
        config.properties = this.properties;
        
        return config;
        
    },
    
    applyState : function( state, rawData, onCompletion )
    {
        WR.Charts.PropertiesConfiguration.superclass.applyState.call( this, state, onCompletion );
        
        this.properties = state.properties;
        
        this.writeConfigurationToUI();
        
        if ( rawData == null )
            this._getDataAndPopulateGroupingTree( onCompletion );
        else
        {
            this.unloadedData = new WR.Charts.ChartData( rawData );
            onCompletion();
        }
        
        this.readConfigurationFromUI();
    },
    
    _chartTypeChanged : function()
    {
        var selectEl = YAHOO.util.Dom.get( this.chartBox.id + '_chartTypeSelect' );
        var selected = selectEl.options[ selectEl.selectedIndex ].value;
        
        if ( selected == 'pie' )
        {
            var checkbox = YAHOO.util.Dom.get( this.chartBox.id + '_showSummaryCheckbox' );
            checkbox.disabled = true;
            checkbox.checked = true;
        }
        else if ( selected == 'bar' )
        {
            YAHOO.util.Dom.get( this.chartBox.id + '_showSummaryCheckbox' ).disabled = false;
        }
    },
    
    _loadNewData : function( data, keepGroups, successCallback )
    {
        var me = this;
        
        $( '.chartboxconfigurationconfirmapply' ).removeClass( 'wr_disabled' );
        WR.DOM.el( YAHOO.util.Dom.get( me.chartBox.id + '_applyLink' ) )
            .addListener( 'click',
            function( e ) {
                if ( !YAHOO.widget.TreeView.editorData.active )
                {
                    me.chartBox.data = me.unloadedData.copy();
                    me.readConfigurationFromUI();
                    me.chartBox.applyConfiguration();
                }
            } );
        
        if ( keepGroups )
        {
            me.unloadedData = me.chartBox.data.copy();
            me.unloadedData.replaceData( data );
        }
        else
            me.unloadedData = new WR.Charts.ChartData( data );
        me.refresh();
        
        if ( successCallback != null )
            successCallback();
    },
    
    _warnAboutTooManyResults : function( data, keepGroups, successCallback, isUnparsed )
    {
        var me = this;
        
        if ( isUnparsed )
            $( '#' + this.chartBox.id + ' .chartResultsWarningLabel' ).html( '<?jformat There are a large number of results for this property.  Loading this many results may result in poor browser performance. <br/><br/> Would you like to continue??>' );
        else if ( $.browser.msie )
            $( '#' + this.chartBox.id + ' .chartResultsWarningLabel' ).html( WR.format( '<?jformat There are {num} results for this property.  Loading this many results may result in poor browser performance, and grouping will not be available. <br/><br/> Would you like to continue??>', data[0].values.length ) );
        else
            $( '#' + this.chartBox.id + ' .chartResultsWarningLabel' ).html( WR.format( '<?jformat There are {num} results for this property.  Grouping will not be available for this many results. <br/><br/> Would you like to continue??>', data[0].values.length ) );

        $( '#' + this.chartBox.id + ' .acceptChartWarningLink' ).unbind().bind( 'click',
            function()
            {
                var parsedData;
                if ( isUnparsed )
                    parsedData = JSON.parse( data );
                else
                    parsedData = data;
                    
                $( '#' + me.chartBox.id + ' .GroupingResultsDiv' ).show();
                $( '#' + me.chartBox.id + ' .chartResultsWarningDiv' ).hide(); 
                me.chartBox.data = new WR.Charts.ChartData( data );
                me.readConfigurationFromUI();
                me.chartBox.applyConfiguration();
            } );
        
        $( '#' + this.chartBox.id + ' .rejectChartWarningLink' ).unbind().bind( 'click',
            function()
            {
                $( '#' + me.chartBox.id + ' .GroupingResultsDiv' ).show();
                $( '#' + me.chartBox.id + ' .chartResultsWarningDiv' ).hide();
                me._loadNewData( [{values:[], counts:[]}], keepGroups, successCallback );
            } );
        
        $( '#' + this.chartBox.id + ' .GroupingResultsDiv' ).hide();
        $( '#' + this.chartBox.id + ' .chartResultsWarningDiv' ).show();
    },
    
    _getDataAndPopulateGroupingTree : function( successCallback, keepGroups, properties )
    {
        $( '.chartboxconfigurationconfirmapply' ).addClass( 'wr_disabled' );
        
        var me = this;
        this.groupingTree.loadDataAsync(
            function( callbacks, scope )
            {
                me._requestData( callbacks, scope, properties );
            }, this,
            {
                success: function( response ) {
                    var data = response;
                    if ( data[0].values.length < 500 )
                        me._loadNewData( data, keepGroups, successCallback );
                    else
                        me._warnAboutTooManyResults( data, keepGroups, successCallback );
                },
                
                failure: function( response, scope, message ) {
                    WR.Notify.error( '<?jformat There was an error processing the chart data returned from the server.?>' );
                },
                
                failureTooLong: function( o, scope )
                {
                    me._warnAboutTooManyResults( o.responseText, keepGroups, successCallback, true );
                }
            } );
        this.chartBox.chartManager.resize();
    },
    
    refresh : function()
    {
        this.groupingTree.updateData( this.unloadedData.generateGroupingData() );
        this.chartBox.chartManager.resize();
    },
    
    _enterDefaultTitle : function()
    {
        var titleInput = YAHOO.util.Dom.get( this.chartBox.id + '_titleInput' );
        if ( titleInput.value == '' )
            titleInput.value = this.propertyPicker.getCurrentData().name;
        
    },
    
    _requestData : function( callbacks, me, properties )
    {
        if ( me.requestDataConnection != null && me.requestDataConnection.isInProgress() )
            me.requestDataConnection.abort();
            
        if ( properties == null )
            properties = me.properties;
        
        var propertyIds = [];
        for ( i in properties )
        {
            propertyIds[i] = properties[i].id;
        }
        
        var params = {
            dataType: me.dataType,
            properties: propertyIds
        };
        
        if ( callbacks.start == null )
        {
            callbacks.start = function( connection )
            {
                me.requestDataConnection = connection;
            }
        }
        
        WR.jsonRequest( 'chartdata', callbacks, params );
    },
    
    domReady : function()
    {
        WR.Charts.PropertiesConfiguration.superclass.domReady.call( this );
        
        this._setupGroupingTree();
        this._setupPropertyPicker();
    },
    
    _setupGroupingTree : function()
    {
        this.groupingTree = new WR.GroupableTreeView( this.chartBox.id + '_grouping_results', [] );
        
        var me = this;
        this.groupingTree.subscribe( 'expand', function( node ) {
            me.unloadedData.expandGroup( 0, node.data.groupId ); //series 0
        });
        
        this.groupingTree.subscribe( 'clickEvent', function( e ) {
            var node = e.node;
            node.label = node.data.name;
            node.editNode();
            return false;
        });
        
        this.groupingTree.subscribe( 'expandComplete', function( node ) {
            me.chartBox.chartManager.resize();
        });
        
        this.groupingTree.subscribe( 'collapse', function( node ) {
            me.unloadedData.collapseGroup( 0, node.data.groupId ); //series 0
            me.chartBox.chartManager.resize();
        });
        
        this.groupingTree.subscribe( 'collapseComplete', function( node ) {
            me.chartBox.chartManager.resize();
        });
        
        this.groupingTree.createGroup.subscribe( this._createGroup, this );
        this.groupingTree.removeFromGroup.subscribe( this._removeFromGroup, this );
        this.groupingTree.addToGroup.subscribe( this._addResultToGroup, this );
        this.groupingTree.removeGroup.subscribe( this._removeGroup, this );
        this.groupingTree.refreshData.subscribe( this._refreshData, this );
        
        // This event seems to be fired after editing a name, so it's used to reset the label
        this.groupingTree.validator =  function( newValue, oldValue, nodeInstance ) {
            var newNode = nodeInstance;
            
            if ( newNode.data.isGroup )
            {
                me.unloadedData.setGroupName( newNode.data.groupId, newValue, 0 );
                newNode.data.name = newValue;
            }
            
            return WR.HTML.escape( newValue ) + ' (' + newNode.data.count + ')';
        };
        
    },
    
    _createGroup : function( type, args, me )
    {
        var name = args[0];
        var children = args[1];
        var doEditName = args[2];
        
        //Just for series 0 for now
        var newGroup = me.unloadedData.addNewGroup( name, 0 );
        for ( childIndex in children )
        {
            //Just series 0 for now
            me.unloadedData.addResultToGroup( 0, newGroup.id, children[childIndex].data.resultId );
        }
        
        me.refresh();
        
        var newNode = me.groupingTree.getNodeByProperty( 'groupId', newGroup.id );
        newNode.label = newNode.data.name;
        
        if ( doEditName )
            newNode.editNode();
        
    },
    
    _removeFromGroup : function( type, args, me )
    {
        var groupId = args[0];
        var resultId = args[1];
        me.unloadedData.removeFromGroup( 0, groupId, resultId );
        
        if ( me.unloadedData.getGroup( 0, groupId ).getNumChildren() == 0 )
            me.unloadedData.removeGroup( groupId, 0 );
    },
    
    _addResultToGroup : function( type, args, me )
    {
        var groupId = args[0];
        var resultId = args[1];
        me.unloadedData.addResultToGroup( 0, groupId, resultId );
    },
    
    _removeGroup : function( type, args, me )
    {
        var groupId = args[0];
        me.unloadedData.removeGroup ( groupId, 0 );
    },
    
    _refreshData : function( type, args, me )
    {
        me.refresh();
    },
    
    _setupPropertyPicker : function()
    {
        this.propertyPicker = new WR.PropertiesComboBox( YAHOO.util.Dom.get( this.chartBox.id + '_propertyPicker' ),
                                                        this.chartBox.chartManager.propertiesDataSource );
        
        var me = this;
        this.propertyPicker.itemSelectEvent.subscribe( function( sType, sArgs ) {
            me._enterDefaultTitle();
            
            var property = me.propertyPicker.getCurrentData();
            me._getDataAndPopulateGroupingTree( null, false, [ {id: property.id, name: property.name } ] );
        });
    },
    
    writeConfigurationToUI : function()
    {
        WR.Charts.PropertiesConfiguration.superclass.writeConfigurationToUI.call( this );
        
        YAHOO.util.Dom.get( this.chartBox.id + '_showGraphCheckbox' ).checked = this.showGraph;
        var showSummaryCheckbox = YAHOO.util.Dom.get( this.chartBox.id + '_showSummaryCheckbox' );
        showSummaryCheckbox.checked = this.showTable;
        
        var chartTypeString = (this.chartType == WR.Charts.ChartBox.CHARTTYPE_PIE? 'pie' : 'bar' );
        var chartTypeSelect = YAHOO.util.Dom.get( this.chartBox.id + '_chartTypeSelect' );
        chartTypeSelect.value = chartTypeString;
        
        if ( chartTypeString == 'pie' )
        {
            chartTypeSelect.selectedIndex = 0;
            showSummaryCheckbox.disabled = true;
        }
        else{
            chartTypeSelect.selectedIndex = 1;
            showSummaryCheckbox.disabled = false;
        }
        
        var property = this.properties[0];
        property.name = WR.HTML.unescape( property.name );
        property.displayName = WR.HTML.unescape( property.displayName );
        this.propertyPicker.forceSetCurrentData( property );
    },
    
    readConfigurationFromUI : function()
    {
        WR.Charts.PropertiesConfiguration.superclass.readConfigurationFromUI.call( this );
        
        var property = this.propertyPicker.getCurrentData();
        
        var showGraph = YAHOO.util.Dom.get( this.chartBox.id + '_showGraphCheckbox' ).checked;
        var showTable = YAHOO.util.Dom.get( this.chartBox.id + '_showSummaryCheckbox' ).checked;
        var chartType = YAHOO.util.Dom.get( this.chartBox.id + '_chartTypeSelect' ).value;
        
        this.properties = [ {id: property.id, name: WR.HTML.escape( property.name ), displayName: WR.HTML.escape( property.displayName ) } ];
        this.showGraph = showGraph;
        this.showTable = showTable;
        if ( chartType == 'pie' )
            this.chartType = WR.Charts.ChartBox.CHARTTYPE_PIE;
        else if ( chartType == 'bar' )
            this.chartType = WR.Charts.ChartBox.CHARTTYPE_BAR;

    },
    
    filterChanged : function( xml, callback )
    {
        var me = this;
        if ( this.properties != null )
        {
            this._getDataAndPopulateGroupingTree(
                function()
                {
                    if ( me.chartBox.currentView == WR.Charts.ChartBox.PRESENTATION_VIEW )
                        me.chartBox.data = me.unloadedData.copy();
                    if ( callback != null )
                        callback();
                }, true );
        }
        else if ( me.chartBox.currentView == WR.Charts.ChartBox.CONFIGURATION_VIEW )
        {
            var property = me.propertyPicker.getCurrentData();
            me._getDataAndPopulateGroupingTree( callback, false, [ {id: property.id, name: property.name } ] );
        }

    }
};

YAHOO.lang.extend( WR.Charts.PropertiesConfiguration, WR.Charts.Configuration, WR.Charts.PropertiesConfiguration.prototype );
