// ChartResult.js

// <?import /JavaScript/Util/HTML.js?>
// <?import /JavaScript/Charts/Charts.js?>

// rawData is the raw data for this series that came from the server
WR.Charts.Result = function( id, name, count )
{
    this.name = name;
    this.count = count;
    this.id = id;
};

WR.Charts.Result.prototype = {
    
    generatePieData : function()
    {
        return [ this.name, this.count ];
    },
    
    generateBarData : function()
    {
        return { name: this.name, count: this.count };
    },
    
    generateLineData : function()
    {
        return [ this.name, this.count ];
    },
    
    generateSummaryData : function( propertyId, totalCount )
    {
        var dataObject = { count : this.count, percent : ( 100 * this.count / totalCount ) };
        dataObject[ propertyId ] = WR.HTML.escape( this.name );
        return dataObject;
    },
    
    generateGroupingData : function()
    {
        var me = this;
        return {
            type : 'Text',
            label : WR.HTML.escape( this.name + '  (' + this.count + ')' ),
            editable : false,
            expanded : false,
            count: this.count,
            name: this.name,
            groupId: -1,
            resultId: this.id,
            isGroup: false
        };
    }
    
};
