// ChartSeries.js

// <?import /JavaScript/Charts/Charts.js?>
// <?import /JavaScript/Charts/Group.js?>
// <?import /JavaScript/Charts/Series.js?>

// rawData is the raw data for this series that came from the server
WR.Charts.Series = function( rawData )
{
    this.propertyId = rawData.id;
    
    this.replaceData( rawData );
    
    this.groups = [];
};

WR.Charts.Series.prototype = {
    
    serializeForHistory : function()
    {
        var groups = [];
        for ( i in this.groups )
        {
            groups.push( this.groups[i].serializeForHistory() );
        }
        
        return {
            groups: groups
        };
    },
    
    applyState : function( state )
    {
        this.groups = [];
        
        var groups = state.groups;
        for ( i in groups )
        {
            var newGroup = this.addNewGroup( groups[i].name );
            
            for ( entryIndex in groups[i].entries )
            {
                for ( resultIndex in this.results )
                {
                    if ( groups[i].entries[entryIndex] == this.results[resultIndex].name )
                    {
                        this.addResultToGroup( newGroup.id, this.results[resultIndex].id );
                    }
                }
            }
        }
    },
    
    replaceData : function( rawData )
    {
        for ( var i in this.groups )
        {
            this.groups[i].convertToNewData( rawData );
            if ( this.groups[i].getNumChildren() == 0 )
                delete this.groups[i];
        }
        
        this.results = [];
        for ( i in rawData.values )
        {
            this.results[i] = new WR.Charts.Result( i, rawData.values[i], rawData.counts[i] );
        }
    },
    
    getNumResults : function()
    {
        return this.results.length;
    },
    
    getNumGroupedResults: function()
    {
        return this.generateSummaryData().length;
    },
    
    getGroup : function( groupId )
    {
        return this.groups[groupId];
    },
    
    addNewGroup: function( groupName )
    {
        var group = new WR.Charts.Group( this.groups.length, groupName, this );
        this.groups.push( group );
        return group;
    },
    
    removeGroup: function( groupId )
    {
        delete this.groups[groupId];
    },
    
    addResultToGroup : function( groupId, resultId )
    {
        this.groups[groupId].addMember( resultId );
    },
    
    removeFromGroup : function( groupId, resultId )
    {
        this.groups[groupId].removeMember( resultId );
    },
    
    setGroupName : function( groupId, name )
    {
        this.groups[ groupId ].name = name;
    },
    
    expandGroup : function( groupId )
    {
        this.groups[groupId].expanded = true;
    },
    
    collapseGroup : function( groupId )
    {
        this.groups[groupId].expanded = false;
    },
    
    /**
     * Looks up data in reverse order in order for the pie slices to get smaller going counter-clockwise.
     */
    generatePieData : function()
    {
        var data = [];
        
        var itemIsInAGroup = [];
        for ( resultIndex in this.results )
            itemIsInAGroup[resultIndex] = false;
            
        for ( groupIndex in this.groups )
        {
            var members = this.groups[groupIndex].members;
            for ( memberIndex in this.groups[groupIndex].members )
            {
                itemIsInAGroup[members[memberIndex]] = true;
            }
            
            data.push( this.groups[groupIndex].generatePieData() );
        }
        
        for ( resultIndex in this.results )
        {
            if ( !itemIsInAGroup[resultIndex] )
            {
                data.push( this.results[resultIndex].generatePieData() );
            }
        }
        
        return data.sort( this._sortByCountArrayVersion ).reverse();
    },
    
    generateBarData : function()
    {
        var data = [];
        
        var itemIsInAGroup = [];
        for ( resultIndex in this.results )
            itemIsInAGroup[resultIndex] = false;
            
        for ( groupIndex in this.groups )
        {
            var members = this.groups[groupIndex].members;
            for ( memberIndex in this.groups[groupIndex].members )
            {
                itemIsInAGroup[members[memberIndex]] = true;
            }
            
            data.push( this.groups[groupIndex].generateBarData() );
        }
        
        for ( resultIndex in this.results )
        {
            if ( !itemIsInAGroup[resultIndex] )
            {
                data.push( this.results[resultIndex].generateBarData() );
            }
        }
        
        var sortedData =  data.sort( this._sortByCount );
        
        var values = [];
        var counts = [];
        
        for ( i in sortedData )
        {
            values.push( sortedData[i].name );
            counts.push( sortedData[i].count );
        }
        
        return { values: values, counts: [counts] };
    },
    
    generateLineData : function()
    {
        var data = [];
        for ( i in this.results )
        {
            data.push( this.results[i].generateLineData() );
        }
        
        data.name = this.propertyId;
        
        return data;
    },
    
    generateSummaryData : function()
    {
        var totalCount = 0;
        for ( i in this.results )
        {
            totalCount += this.results[i].count;
        }
        
        var data = [];
        
        var itemIsInAGroup = [];
        for ( resultIndex in this.results )
            itemIsInAGroup[resultIndex] = false;
            
        for ( groupIndex in this.groups )
        {
            var members = this.groups[groupIndex].members;
            for ( memberIndex in this.groups[groupIndex].members )
            {
                itemIsInAGroup[members[memberIndex]] = true;
            }
            
            var entry = this.groups[groupIndex].generateSummaryData( this.propertyId, totalCount );
            data.push( entry );
        }
        
        for ( resultIndex in this.results )
        {
            if ( !itemIsInAGroup[resultIndex] )
            {
                var entry = this.results[resultIndex].generateSummaryData( this.propertyId, totalCount );
                data.push( entry );
            }
        }
        
        return data.sort( this._sortByCount );
    },
    
    generateGroupingData : function()
    {
        var data = [];
        
        var itemIsInAGroup = [];
        for ( resultIndex in this.results )
            itemIsInAGroup[resultIndex] = false;
            
        for ( groupIndex in this.groups )
        {
            var members = this.groups[groupIndex].members;
            for ( memberIndex in this.groups[groupIndex].members )
            {
                itemIsInAGroup[members[memberIndex]] = true;
            }
            
            data.push( this.groups[groupIndex].generateGroupingData() );
        }
        
        for ( resultIndex in this.results )
        {
            if ( !itemIsInAGroup[resultIndex] )
            {
                data.push( this.results[resultIndex].generateGroupingData() );
            }
        }
        
        return data.sort( this._sortByCount );
    },
    
    _sortByCount : function( a, b )
    {
        return b.count - a.count;
    },
    
    _sortByCountArrayVersion : function( a, b )
    {
        return b[1] - a[1];
    }
    
};
