// <?import /JavaScript/Notification/Notification.js?>
// <?import /JavaScript/Util/URL.js?>
// WARNING: This file depends on HTML/ReportCustom/reportcustom.body.html
// <?import /JavaScript/yui-import/ConnectionManager.js?>

var StoreSharedVariable;
var DeleteSharedVariable;

(function() {

    postDashboardVariableRequest = function( url, dashboardID, variableName, paramMap, callback, databaseID ) {
        paramMap.add( 'DashboardID', dashboardID );
        paramMap.add( 'Name', variableName );
        if ( databaseID )
            paramMap.add( 'DatabaseID', databaseID );
        paramMap.add( 'DashboardVariableToken', WR.dashboardVariableRequestToken );
        YAHOO.util.Connect.asyncRequest( 'POST', url, {
            success: function( o ) {
                if ( callback && callback.success )
                    callback.success(o);
            },
            failure: function(o) {
                if ( callback && callback.failure )
                    callback.failure( o );
                else
                    WR.Notify.error( 'HTTP POST Request "' + url + '" failed: ' + o.responseText );
            } 
        }
      , paramMap.finish());
    };


    StoreSharedVariable = function( dashboardID, variableName, variableValue, callback, databaseID ) {
        if ( !dashboardID || !variableName || !variableValue ) 
        {
            WR.Notify.error( '<?jformat Attempt to set dashboard datastore value failed: missing required arguments.?>' );
            return;
        }
        var paramMap = new WR.URL.ParamMap();
        paramMap.add( 'Value', variableValue );
        postDashboardVariableRequest( '/post/store-shared-variable', dashboardID, variableName, paramMap, callback, databaseID );
    }

    DeleteSharedVariable = function( dashboardID, variableName, callback, databaseID ) {
        if ( !dashboardID || !variableName ) {
            WR.Notify.error( '<?jformat Attempt to delete dashboard datastore value failed: missing required arguments.?>' );
            return;
        }
        var paramMap = new WR.URL.ParamMap();
        postDashboardVariableRequest( '/post/delete-shared-variable', dashboardID, variableName, paramMap, callback, databaseID );
    }

})();
