// <?import /JavaScript/WR.js?>
// <?import /JavaScript/yui-import/DataSource.js?>
// <?import /JavaScript/Util/GetRequest.js?>
// <?import /JavaScript/Util/URL.js?>

WR.DataSource = function( dataURL, fieldArray, initialRequest, initialResponse )
{
    WR.DataSource.superclass.constructor.call( this, dataURL );
    
    this.responseType = YAHOO.util.DataSource.TYPE_JSON;
    this.connXhrMode = "cancelStaleRequests";
    this.responseSchema = {
        resultsList: "results",
        fields: fieldArray,
        metaFields: {
            totalRecords: "totalRecords",
            startIndex: "startIndex",
            pageSize: "pageSize",
            sort: "sort",
            dir: "dir",
            totalRecordsUnknown : "totalRecordsUnknown",
            columns : "columns"
        }
    };
    
    this.initialRequest = initialRequest;
    this.initialResponse = initialResponse;
};

WR.DataSource.prototype = {
    sendRequest : function( oRequest, oCallback, oCaller ) {
        this.lastRequest = oRequest;
        
        var me = this;
        WR.buildGetParams( WR.URL.ParseParams( oRequest ), function( newRequest ) {
            YAHOO.util.XHRDataSource.prototype.sendRequest.call( me, newRequest, oCallback, oCaller );
        });
    },
    
    getCachedResponse : function( oRequest, oCallback, oCaller ) {
        if ( !this.initialResponse )
            return null;
        
        var initialResponse = this.initialResponse;
        this.initialResponse = null;
        
        if ( this.initialRequest != oRequest )
            return null;
        
        return initialResponse;
    },
    
    addMetaField : function( name ) {
        this.responseSchema.metaFields[name] = name;
    }
};

WR.DataSource.getFieldsFromColumns = function( columns, meta )
{
    var fields = [];
    for ( i in columns )
    {
        if( columns[i].dataSource )
            fields.push( { key : columns[i].key } );
    }
    
    for ( i in meta )
        fields.push( { key : meta[i] } );
                
    return fields;
};

YAHOO.lang.extend( WR.DataSource, YAHOO.util.XHRDataSource, WR.DataSource.prototype );
