// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/DataTable/ActionPropertiesDataTable.js?>
// <?import /JavaScript/DataTable/PropertiesDataTable.js?>
// <?import /JavaScript/Util/URL.js?>
// <?import /JavaScript/DataSource/DataSource.js?>
// <?import /JavaScript/yui-import/YahooGlobalObject.js?>

WR.ActionPropertiesDataTable = function( opts, columns )
{  
    opts.dataSource = new WR.DataSource( WR.URL( '/json/actions?' ), [ "properties", "href" ] );
    opts.sortKey = 'name';
    
    opts.customPropertyFormatters =
    {
        'name' : function( elCell, oRecord, oColumn, datatable, span, property )
        {
            span.appendChild(
                WR.DOM.el( 'a' )
                    .setProperty( 'href', oRecord.getData( 'href' ) )
                    .innerText( property.result )
                    .finish()
            );
            return true;
        }
    };
    
    opts.csvURL = '/csv/ExploreActions.csv';
    opts.pdfURL = '/pdf/ExploreActions.pdf';
    opts.printableURL = '/printable/ExploreActions';
    
    WR.ActionPropertiesDataTable.superclass.constructor.call( this, opts, columns );
};

WR.ActionPropertiesDataTable.prototype = {};

YAHOO.lang.extend( WR.ActionPropertiesDataTable, WR.PropertiesDataTable, WR.ActionPropertiesDataTable.prototype );

