// <?import /JavaScript/WR.js?>
// <?import /JavaScript/Util/Set.js?>
// <?import /JavaScript/DropDownPicker/DropDownPicker.js?>

WR.ColumnPicker = function( id, buttontext, dataTable, formatter, entryFormatter, availableItemsText, activeItemsText )
{
    var columnPicker = this;
    
    this.labelPicker = new WR.DropDownPicker( {
        id : id,
        buttonText : buttontext,
        addLabel : function( label ) {
            columnPicker.addColumn( label, columnPicker.columnMap[ label ].name );
        },
        removeLabel : function( label ) {
            columnPicker.removeColumn( label );
        },
        getActiveLabels : function() {
            columnPicker.columnSet = new WR.Set();
            var columns = columnPicker.dataTable.getColumnSet();
            for ( var i in columns.keys )
                columnPicker.columnSet.insert( columns.keys[ i ].key );
            
            return columnPicker.columnSet;
        },
        availableItemsText : availableItemsText,
        activeItemsText : activeItemsText
    } );
    
    this.labelPicker.getLabelHTML = function( key ) {
        return entryFormatter( columnPicker.columnMap[ key ] );
    };
    
    this.labelPicker.entryMatches = function( key, regex ) {
        return columnPicker.columnMap[ key ].name.search( regex ) != -1;
    };
    
    this.columnSet = new WR.Set();
    this.dataTable = dataTable;
    this.formatter = formatter;
};

WR.ColumnPicker.prototype = {

    addColumn : function( key, name )
    {
        this.columnSet.insert( key );
        
        this.dataTable.insertColumn(
            {
                key : key,
                label : name,
                formatter : this.formatter,
                sortable : true,
                resizeable : true,
                dataSource : true
            },
            this.columnSet.length > 1 ? 1 : 0 );
        
        this.dataTable.update();
    },
    
    removeColumn : function( key )
    {
        this.columnSet.remove( key );
        this.dataTable.removeColumnFromTable( this.dataTable.getColumnByName( key ) );
        this.dataTable.update();
    },
    
    setColumnOptions : function( columnArray )
    {
        var labelArray = new Array( columnArray.length );
        this.columnMap = {};
        var me = this;
        function stripLabel( item )
        {
            me.columnMap[ item.id ] = item;
            return item.id;
        }
        for ( var i in columnArray )
        {
            
            if( columnArray[i].items )
            {
                labelArray[i] = { id:     stripLabel( columnArray[i] ),
                                  items:  new Array( columnArray[i].items.length ) };
                for ( var j in columnArray[i].items )
                    labelArray[i].items[j] = stripLabel( columnArray[i].items[j] );
                continue;
            }
            labelArray[i] = stripLabel( columnArray[i] );
        }
        
        this.labelPicker.setLabels( labelArray );
    },
    
    setColumnName : function( id, name )
    {
        this.columnMap[ id ].name = name;
    },
	
	enable : function()
	{
		this.labelPicker.enable()
	},
	
	disable : function()
	{
		this.labelPicker.disable()
	},
	
	setExpandableColumns : function( opts )
	{
		this.expandColumn = opts.expandColumn;
		this.collapseColumn = opts.collapseColumn;
		this.expandColumnToolText = opts.expandColumnToolText;
		this.collapseColumnToolText = opts.collapseColumnToolText;
		this.splitImageSrc = '/JavaScript/DataTable/images/split.png';
		this.unsplitImageSrc = '/JavaScript/DataTable/images/unsplit.png';
		
		var me = this;
		
		this.labelPicker.formatLabelUI = function( label, container, activeColumn, isInActiveList ) {
			if( !activeColumn || !isInActiveList )
				return;
		
			var expandElement = WR.DOM.el( 'img' )
				.addClass( 'expandColumnImage' );
			
			var onClickFunction = function( e, o ) {
				var expandIndex = WR.Array.indexOf( o.picker.dataTable.expandedColumns, label );
				var target = e.target || e.srcElement;
				if ( expandIndex == -1 ) {
					o.picker.expandColumn( o.label )
					target.src = o.picker.unsplitImageSrc;
					target.title = o.picker.collapseColumnToolText;
				} else {
					o.picker.collapseColumn( expandIndex );
					target.src = o.picker.splitImageSrc;
					target.title = o.picker.expandColumnToolText;
				}
			}
			
			if( WR.Array.indexOf( me.dataTable.expandedColumns, label ) == -1 ){
				expandElement.setProperty( 'src', me.splitImageSrc )
					.setProperty( 'title', me.expandColumnToolText );
			}else{
				expandElement.setProperty( 'src', me.unsplitImageSrc )
					.setProperty( 'title', me.collapseColumnToolText );
			}
			
			expandElement.addListener( 'click', onClickFunction, { picker :  me, label : label } );
			
			WR.DOM.el( container )
				.appendChild( expandElement.finish() )
			.finish();
		}
		
		this.labelPicker.unformatLabelUI = function( container ) {
			WR.DOM.el( container ).innerHTML( '' );
		}
	}
    
};
