// <?import /JavaScript/WR.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/DataTable/PropertiesDataTable.js?>
// <?import /JavaScript/Util/URL.js?>
// <?import /JavaScript/Util/HTML.js?>
// <?import /JavaScript/DataSource/DataSource.js?>
// <?import /JavaScript/yui-import/YahooGlobalObject.js?>
// <?import /JavaScript/jQuery/jquery.js?>

// <?import /JavaScript/jq-import/ui/ProgressBar.js?>

WR.ContentPropertiesDataTable = function( opts, columns )
{  
    var me = this;
    
    opts.dataSource = new WR.DataSource( WR.URL( '/json/fixletproperties?' ), [ "properties", "fixletHref", "computerHref" ] );
    opts.sortKey = 'Name';
    
    opts.customPropertyFormatters =
    {
        'Name' : function( elCell, oRecord, oColumn, datatable, span, property )
        {
            var s = WR.HTML.escape( property.result );
            span
                .setProperty( "title", s )
                .appendChild(
                    new WR.DOM.Element( 'a' )
                        .setProperty( 'href', oRecord.getData( 'fixletHref' ) )
                        .innerHTML( s )
                        .finish()
                );
                
            return true;
        },
        
        'Computer' : function( elCell, oRecord, oColumn, datatable, span, property )
        {
            var s = WR.HTML.escape( property.result );
            span
                .setProperty( "title", s )
                .appendChild(
                    new WR.DOM.Element( 'a' )
                        .setProperty( 'href', oRecord.getData( 'computerHref' ) )
                        .innerHTML( s )
                        .finish()
                );
            
            return true;
        },
        
        'Progress' : function( elCell, oRecord, oColumn, datatable, span, property )
        {
            if ( !property.plural && isFinite( property.result ) )
            {
                var div = WR.DOM.el( 'div' );
                span.appendChild( div.finish() );
                var val = property.result > 0 && property.result < .001 
							? .1 
							: property.result < .1 
								? Math.floor( property.result * 1000 ) / 10 
								: Math.floor( property.result * 100 );
                span.appendChild( WR.DOM.el( 'label' ).addClass( 'ProgressLabel' ).innerText( val + '%' ).finish() );
                $( div.finish() ).progressbar( { value: property.result * 100 } );
            }
            else
                return false;
                
            return true;
        },
        
        'Relevance' : function( elCell, oRecord, oColumn, datatable, span, property )
        {
            if ( property.plural && property.result.length == 0 )
            {
                setSpanText( span, '<?jformat <not applicable>?>' ), 'empty_result';
                return true;
            }
            else
                return false;
        }
    };
    
    opts.expandColumnNames = [ 'Computer', 'Relevance' ];
    opts.csvURL = '/csv/ExploreContent.csv';
    opts.pdfURL = '/pdf/ExploreContent.pdf';        
    opts.printableURL = '/printable/ExploreContent';
    
    WR.ContentPropertiesDataTable.superclass.constructor.call( this, opts, columns );
};

WR.ContentPropertiesDataTable.prototype = {
    
};

YAHOO.lang.extend( WR.ContentPropertiesDataTable, WR.PropertiesDataTable, WR.ContentPropertiesDataTable.prototype );

