// <?import /JavaScript/yui-import/Container.js?>
// <?import /JavaScript/yui-import/Button.js?>
// <?import /JavaScript/yui-import/Dom.js?>
// <?import /JavaScript/yui-import/Event.js?>
// <?import /JavaScript/yui-import/DragDrop.js?>

// <?import /JavaScript/Util/Array.js?>

var Dom = YAHOO.util.Dom;
var Event = YAHOO.util.Event;
var DDM = YAHOO.util.DragDropMgr;
 
//////////////////////////////////////////////////////////////////////////////
// custom drag and drop implementation
//////////////////////////////////////////////////////////////////////////////
 
YAHOO.example.DDList = function( id, sortMenu, isSortedColumn, sGroup, config ) {
 
    YAHOO.example.DDList.superclass.constructor.call( this, id, sGroup, config );
 
    this.logger = this.logger || YAHOO;
    var el = this.getDragEl();
    Dom.setStyle( el, "opacity", 0.67 ); // The proxy is slightly transparent
 
    this.goingUp = false;
    this.lastY = 0;
	this.sortMenu = sortMenu;
	this.isSortedColumn = isSortedColumn;
};
 
YAHOO.extend( YAHOO.example.DDList, YAHOO.util.DDProxy, {
 
	onMouseDown: function( e ) {
		var target = e.target ? e.target : e.srcElement;
		var tag = target.tagName.toLowerCase();
		if( tag == 'input' || tag == 'img' )
			return false;
	},
 
    startDrag: function( x, y ) {
	
        var dragEl = this.getDragEl();
        var clickEl = this.getEl();
        Dom.setStyle( clickEl, "visibility", "hidden" );
 
        dragEl.innerHTML = clickEl.innerHTML;
		
        Dom.setStyle( dragEl, "color", Dom.getStyle( clickEl, "color" ) );
        Dom.setStyle( dragEl, "backgroundColor", Dom.getStyle( clickEl, "backgroundColor" ) );
		Dom.setStyle( dragEl, "height", "18px" );
        Dom.setStyle( dragEl, "border", "1px solid gray" );
    },
 
    endDrag: function( e ) {
        var srcEl = this.getEl();
        var proxy = this.getDragEl();
		
		var me = this;
		
		var changeSort = function() {
			if ( me.isSortedColumn ) {
				if ( me.lastDropId == me.sortMenu.unsortedListId() )
					me.sortMenu.removeSortColumnById( srcEl.id );
				else if ( me.lastDropId == me.sortMenu.sortedListId() && me.destId )
					me.sortMenu.changeSortOrderById( srcEl.id, me.goingUp, me.destId )
			} else if ( !me.isSortedColumn && me.lastDropId == me.sortMenu.sortedListId() )
				me.sortMenu.addSortColumnById( srcEl.id, me.goingUp, me.destId );
		}
       
		
        var proxyid = proxy.id;
        var thisid = this.id;
		
		if ( YAHOO.env.ua.ie ) {
			Dom.setStyle( proxyid, "visibility", "hidden" );
			Dom.setStyle( thisid, "visibility", "" );
			changeSort();
		} else {
			Dom.setStyle( proxy, "visibility", "" );
			
			var a = new YAHOO.util.Motion( 
				proxy, { 
					points: { 
						to: Dom.getXY(srcEl)
					}
				}, 
				0.2, 
				YAHOO.util.Easing.easeOut 
			)
			
			a.onComplete.subscribe(function() {
				Dom.setStyle( proxyid, "visibility", "hidden" );
				Dom.setStyle( thisid, "visibility", "" );
				changeSort();
			});
			
			a.animate();
		}
    },
 
    onDragDrop: function( e, id ) {
	
		if ( id == this.sortMenu.sortedListId() || id == this.sortMenu.unsortedListId() )
			this.lastDropId = id;
    },
 
    onDrag: function( e ) {
 
        // Keep track of the direction of the drag for use during onDragOver
        var y = Event.getPageY( e );
 
        if ( y < this.lastY ) {
            this.goingUp = true;
        } else if ( y > this.lastY ) {
            this.goingUp = false;
        }
 
        this.lastY = y;
    },
 
    onDragOver: function( e, id ) {
    
        var srcEl = this.getEl();
        var destEl = Dom.get( id );
 

        if ( destEl.nodeName.toLowerCase() == "li" ) {
            var p = destEl.parentNode;
			
			if( p.id == this.sortMenu.sortedListId() || p.id == this.sortMenu.unsortedListId() )
				this.lastDropId = p.id;

            if (this.goingUp) {
                p.insertBefore( srcEl, destEl ); // insert above
            } else {
                p.insertBefore( srcEl, destEl.nextSibling ); // insert below
            }
			
			this.destId = id;
 
            DDM.refreshCache();
        }
    }
} );