// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/DataTable/ExpandColumnPicker.js?>
// <?import /JavaScript/DataTable/ComputerPropertiesDataTable.js?>

// <?import /JavaScript/yui-import/YahooGlobalObject.js?>

// <?import /JavaScript/DataTable/ExpandCollapseColumnPicker.css?>


WR.ExpandCollapseColumnPicker = function( id, buttontext, dataTable, formatter, entryFormatter, availableItemsText, activeItemsText, expandColumns )
{
    WR.ExpandCollapseColumnPicker.superclass.constructor.call( this, id, buttontext, dataTable, formatter, entryFormatter, availableItemsText, activeItemsText, expandColumns );
};

WR.ExpandCollapseColumnPicker.prototype = {
    
    updateDataTableFromModifyView : function()
    {
        this.dataTable.setCollapseComputers( $( '#collapseComputers' ).prop( 'checked' ) );
        WR.ExpandCollapseColumnPicker.superclass.updateDataTableFromModifyView.call( this );
    },
    
    init: function( expandColumns )
    {
        WR.ExpandCollapseColumnPicker.superclass.init.call( this, expandColumns );
        var params = WR.URL.ParseParams( this.dataTable.lastRequest );
        $( '#collapseComputers' ).prop( 'checked', ( params.collapsedColumn != null ) );
        
        this._updateCollapseColumnName( params.collapsedColumn != null );
        
        var me = this;
        this.dataTable.onComputersCollapsed.subscribe(
            function()
            {
                me._updateCollapseColumnName( true );
            } );
        
        this.dataTable.onComputersExpanded.subscribe(
            function()
            {
                me._updateCollapseColumnName( false );
            } );
    },
    
    _updateCollapseColumnName : function( isCollapsed )
    {
        if ( isCollapsed )
            this.setColumnName( 'R-Computer Name', '<?jformat Count?>' );
        else
            this.setColumnName( 'R-Computer Name', '<?jformat Computer Name?>' );
        this.labelPicker.updateOptions();
    },

    addUI : function( expandColumns )
    {
        WR.ExpandCollapseColumnPicker.superclass.addUI.call( this, expandColumns );
        
        WR.DOM.get( 'labelpickermenu' )
            .appendChild( WR.DOM.el( 'div' )
                .setProperty( 'id', 'collapseComputersDiv' )
                .appendChild(
                    WR.DOM.el( 'input' )
                        .setProperty( 'id', 'collapseComputers' )
                        .setProperty( 'type', 'checkbox' )
                        .addClass( 'ModifyCheckbox' )
                        .finish() )
                .appendChild( WR.DOM.el( 'span' )
                            .addClass( 'labelPickerText' )
                            .innerHTML( '<label for="collapseComputers"><?jformat Hide Individual Computers?></label>' )
                            .finish() )
                .finish() );
    }
    
    
};

YAHOO.lang.extend( WR.ExpandCollapseColumnPicker, WR.ExpandColumnPicker, WR.ExpandCollapseColumnPicker.prototype );
