// <?import /JavaScript/WR.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/DataTable/ColumnPicker.js?>
// <?import /JavaScript/Util/History.js?>

// <?import /JavaScript/jQuery/jquery.js?>
// <?import /JavaScript/yui-import/YahooGlobalObject.js?>

// <?import /JavaScript/DataTable/ExpandColumnPicker.css?>

WR.ExpandColumnPicker = function( id, buttontext, dataTable, formatter, entryFormatter, availableItemsText, activeItemsText, expandColumns )
{
    WR.ExpandColumnPicker.superclass.constructor.call( this, id, buttontext, dataTable, formatter, entryFormatter, availableItemsText, activeItemsText );
    
    var initialized = false;
    
    this.expandColumns = expandColumns;
    
    var me = this;
    this.labelPicker.overlay.showEvent.subscribe( function( type, args ) {
        if ( !initialized )
        {
            me.init( expandColumns );
            initialized = true;
        }
    } );
};

WR.ExpandColumnPicker.prototype = {
    
    updateDataTableFromModifyView : function()
    {   
        this.dataTable.expandedProperties = [];
        for ( var i in this.expandColumns )
        {
            if ( $( '#' + this.expandColumns[i].id ).prop( 'checked' ) )
                this.dataTable.expandedProperties.push( this.expandColumns[i].property ); 
        }
        
        var me = this;
        //If you call YAHOO.util.History.navigate twice before going idle, it won't update its state correctly and the first call won't be committed
        setTimeout( function() {
            me.dataTable.setToFirstPageUpdate();
            me.dataTable.history.update();
        }, 1 );
    },
    
    init: function( expandColumns )
    {
        this.addUI( expandColumns );
        this._loadInitialState();
        this._addChangeListeners();
    },

    addUI : function( expandColumns )
    {
        WR.DOM.get( 'labelpickermenu' )
            .appendChild(
                WR.DOM.el( 'div' )
                    .addClass( 'expandColumnPickerItems' )
                    .appendChild(
                        WR.DOM.el( 'h3' )
                            .innerHTML( '<?jformat Expand?>' )
                            .finish()
                    )
                    .appendChild(
                        WR.DOM.el( 'ol' )
                            .setProperty( 'id', this.labelPicker.id + '_expandItems' )
                            .finish()
                    )
                    .finish() );
            
        for ( var i in expandColumns )
        {
            var label = expandColumns[i].name;
            var labelUI = WR.DOM.el( 'span' );
            
            this.labelPicker.formatLabelUI( label, labelUI.finish() );
            
            var listElement = WR.DOM.el( 'li' )
                .appendChild( WR.DOM.el( 'span' )
                    .appendChild( WR.DOM.el( 'input' )
                        .setProperty( 'id', expandColumns[i].id )
                        .setProperty( 'type', 'checkbox' )
                        .addClass( 'ModifyCheckbox' )
                        .finish() )
                    .appendChild( WR.DOM.el( 'span' )
                        .addClass( 'labelPickerText' )
                        .innerHTML( '<label for="' + this.labelPicker.id + '_' + label + '">' + label + '</label>' )
                        .finish() )
                    .finish() )
                    .appendChild( labelUI.finish() );
            
            WR.DOM.get( this.labelPicker.id + '_expandItems' ).appendChild( listElement.finish() );
        }
    },
    
    _loadInitialState : function()
    {
        var params = WR.URL.ParseParams( this.dataTable.lastRequest );
        for ( var i in params.expandedProperties )
        {
            var index = -1;
            for ( var j in this.expandColumns )
            {
                if ( this.expandColumns[j].property == params.expandedProperties[i] )
                {
                    index = j;
                    break;
                }
            }
            if ( index >= 0 )
                $( '#' + this.expandColumns[i].id ).prop( 'checked', true );
            else
                throw "Unknown property for expand column picker.";
        }
    },
    
    _addChangeListeners : function()
    {
        var me = this;
        $( '.ModifyCheckbox' ).click( function() {
            me.updateDataTableFromModifyView();
        } );
        
    }
    
    
};

YAHOO.lang.extend( WR.ExpandColumnPicker, WR.ColumnPicker, WR.ExpandColumnPicker.prototype );
