// FiltersDataTable.js

// <?import /JavaScript/WR.js?>
// <?import /JavaScript/Util/Array.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/Util/HTML.js?>
// <?import /JavaScript/Filter/AutoCompleteFilter.js?>
// <?import /JavaScript/DataTable/DataTableStrings.js?>
// <?import /JavaScript/DataTable/DataTable.css?>
// <?import /css/besreports/WebReports;Language/dataTableFilter.css?>
// <?import /css/besreports/WebReports;Language/datatable.css?>

// <?import /JavaScript/yui-import/DataSource.js?>
// <?import /JavaScript/yui-import/DataTable.js?>
// <?import /JavaScript/yui-import/Dom.js?>
// <?import /JavaScript/yui-import/Event.js?>

// <?import /JavaScript/jQuery/jquery.js?>


WR.FiltersDataTable = function( pageElements, columns )
{
    this.filterID = pageElements.filterID;
    this.filterQuery = '';
    
    var allColumnDefs = [ { key: 'filterName', label: '<?jformat Name?>', formatter: function( elCell, oRecord, oColumn, oData ) {
                            elCell.innerHTML = '<a href="javascript:void(0)" onclick="WR.Filters.FilterManagementSettings.onFilterClick(' + oRecord.getData().filterID + ')" >' + WR.HTML.escape( oData ) + '</a>';
                       } },
                       { key: 'creatorName', label: '<?jformat Creator?>' },
                       { key: 'lastModified', label: '<?jformat Last Modified?>', formatter: function( elCell, oRecord, oColumn, oData ) {
                            elCell.innerHTML = new Date( oData ).toLocaleString();
                       } },
                       { key: 'isPublic', label: '<?jformat Visibility?>', formatter: function( elCell, oRecord, oColumn, oData ) {
                            elCell.innerHTML = oData == true? '<?jformat Public?>' : '<?jformat Private?>';
                       }
                         } ];
    if ( WR.Filters.FilterManagementSettings.showCheckboxes )
    {
        allColumnDefs = [ { key: 'filterID', label: '', formatter: function( elCell, oRecord, oColumn, oData ) {
                            elCell.innerHTML = '<input class="FilterCheckbox" name="' + oRecord.getData().filterID + '" type="checkbox"' + ( oRecord.getData().currentUserCanModify? '' : 'disabled="disabled"' ) +  ' onclick="WR.Filters.FilterManagementSettings.onCheckboxClick()" />';
                       } } ].concat( allColumnDefs );
    }
    
    var columnDefs = [];
    for ( var i in allColumnDefs )
    {
        if ( WR.Array.indexOf( columns, allColumnDefs[i].key ) >= 0 )
        {
            columnDefs.push( allColumnDefs[i] );
        }
    }
    
    
    this.dataSource = new YAHOO.util.FunctionDataSource( this._generateFilteredFilters );
    this.dataSource.scope = this;
    
    this.dataSource.responseType = YAHOO.util.XHRDataSource.TYPE_JSARRAY;
    this.dataSource.responseSchema = { fields: columns };
    
    var config = {};
    config.MSG_EMPTY =    WR.DataTableStrings.MSG_EMPTY;
    config.MSG_ERROR =    WR.DataTableStrings.MSG_ERROR;
    config.MSG_LOADING =  WR.DataTableStrings.MSG_LOADING;
    config.MSG_SORTASC =  WR.DataTableStrings.MSG_SORTASC;
    config.MSG_SORTDESC = WR.DataTableStrings.MSG_SORTDESC;

    WR.FiltersDataTable.superclass.constructor.call( this, pageElements.tableID, columnDefs, this.dataSource, config );

    this._setupFilter( pageElements.filterID, pageElements.filterContainerID );
    
    this._setupSelectLinks( pageElements.selectAllID, pageElements.selectNoneID );
    
};

WR.FiltersDataTable.prototype = {
    
    _generateFilteredFilters : function()
    { 
        var filters = [];
        for ( i in WR.Filters.SavedFilterNames )
        {
            var filter = WR.Filters.SavedFilterNames[i].info;
            if ( filter.filterName.toLowerCase().indexOf( this.filterQuery ) >= 0 ||
                    filter.creatorName.toLowerCase().indexOf( this.filterQuery ) >= 0 )
            {
                filter.currentUserCanModify = WR.Filters.SavedFilterNames[i].currentUserCanModify;
                filters.push( filter );
            }
        }
        
        return filters;
    },
    
    addOnResizeListener : function( fn, arg )
    {
        var table = this.getTableEl();
        var events = [ "columnSetWidthEvent", "postRenderEvent" ];
        
        for( var i in events )
        {
            this.subscribe( events[ i ], function() {
                fn( YAHOO.util.Dom.getRegion( table ), arg );
            });
        }
        
        YAHOO.util.Event.addListener( window, "resize", function() {
            fn( YAHOO.util.Dom.getRegion( table ), arg );
        });
    },
    
    getCheckedFilterIDs : function()
    {
        var ids = [];
        $( '.FilterCheckbox:checked' ).each( function() {
            ids.push( this.name );
        } )
        
        return ids;
    },
    
    refreshData : function()
    {
        var oCallback = {
             success : this.onDataReturnInitializeTable,
             failure : this.onDataReturnInitializeTable,
             scope : this
        };
                 
        this.dataSource.sendRequest( '', oCallback );
    },
    
    _setupFilter : function( filterID, filterContainerID )
    {
        var filterOpts = {
            filterInputID : filterID,
            filterContainerID : filterContainerID,
            defaultText : '<?jformat Search Filters?>'
        };
            
        this.filter = new WR.AutoCompleteFilter( filterOpts );
        
        
        this.filter.subscribeToQueryChange( function( e, el, me ) {
            me.filterQuery = this.value().toLowerCase();
            me.refreshData();
        }, this );        
    },
    
    _setupSelectLinks : function( selectAllID, selectNoneID )
    {
        if ( selectAllID != null )
        {
            WR.DOM.el( YAHOO.util.Dom.get( selectAllID ) ).addListener( 'click', function() {
                $( '.FilterCheckbox:enabled' ).prop( 'checked', true );
                WR.Filters.FilterManagementSettings.onCheckboxClick();
            } );
        }
        
        if ( selectNoneID != null )
        {
            WR.DOM.el( YAHOO.util.Dom.get( selectNoneID ) ).addListener( 'click', function() {
                $( '.FilterCheckbox:enabled' ).prop( 'checked', false );
                WR.Filters.FilterManagementSettings.onCheckboxClick();
            } );
        }
    },
    
    showSpinner : function ()
    {
        this.showTableMessage(
            '<img style="display: block; margin-left: auto; margin-right: auto"' +
            'src="/JavaScript/yui/build/assets/skins/sam/ajax-loader.gif"/>');
    },
    
    hideSpinner : function ()
    {
        this.hideTableMessage();
    }
    
};

YAHOO.lang.extend( WR.FiltersDataTable, YAHOO.widget.DataTable, WR.FiltersDataTable.prototype );
