// DefaultTextField.js
//
// <?import /JavaScript/WR.js?>
// <?import /JavaScript/yui-import/Dom.js?>
// <?import /JavaScript/yui-import/Event.js?>

WR.DefaultTextField = function( inputEl, defaultText )
{
    this.inputEl = YAHOO.util.Dom.get( inputEl );
    this.unselectedText = ' ' + ( defaultText ? defaultText : '' );
    
    this.unselected = null;
    this.format();
    
    YAHOO.util.Event.addListener( inputEl, 'focus', function() {
        if( this.unselected )
        {
            YAHOO.util.Dom.setStyle( this.inputEl, 'color', 'black' );
            this.inputEl.value = '';
            this.unselected = false;
        }
    }, this, true );
    
    YAHOO.util.Event.addListener( inputEl, 'change', function() {
        if( this.inputEl.value != this.unselectedText )
            this.format();
    }, this, true);
    
};

WR.DefaultTextField.prototype = {
    
    format : function( override ) {
        if( !this.unselected && (override ||
            this.inputEl.value.length == 0 ||
            ( this.unselectedText && this.inputEl.value == this.unselectedText ) ) )
        {
            YAHOO.util.Dom.setStyle( this.inputEl, 'color', 'gray' );
            this.inputEl.value = ( this.unselectedText ? this.unselectedText : '' );
            this.unselected = true;
        }
        else if ( this.unselected )
        {
            YAHOO.util.Dom.setStyle( this.inputEl, 'color', 'black' );
            this.unselected = false;
        }
    },
    
    clear : function() {
        YAHOO.util.Dom.setStyle( this.inputEl, 'color', 'gray' );
        this.inputEl.value = ( this.unselectedText ? this.unselectedText : '' );
        this.unselected = true;
        this.inputEl.blur();
    },

    setValue : function( value ) {
        this.inputEl.value = ( value == undefined ? "" : value );
        this.format();
    },

    value : function() {
        if ( this.unselected )
            return '';
        
        return this.inputEl.value;
    },
    
    focus : function() {
        this.inputEl.focus();
    },
    
    blur : function() {
        this.inputEl.blur();
    }
};
