// DropDownPicker.js

// <?import /JavaScript/WR.js?>
// <?import /JavaScript/DropDownPicker/DropDownPicker.css?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/Filter/AutoCompleteFilter.js?>
// <?import /JavaScript/Util/HTML.js?>
// <?import /JavaScript/Util/RegExp.js?>

// <?import /JavaScript/yui-import/Container.js?>
// <?import /JavaScript/yui-import/Button.js?>
// <?import /JavaScript/yui-import/Dom.js?>
// <?import /JavaScript/yui-import/Event.js?>

WR.DropDownPicker = function( opts ) {
    this.id = opts.id;
    this.createNewText = opts.createNewText;
    this.getActiveLabels = opts.getActiveLabels;
    this.addLabelCallback = opts.addLabel;
    this.removeLabelCallback = opts.removeLabel;
    this.availableItemsText = opts.availableItemsText;
    this.submitFormBtnText = opts.submitFormBtnText;
    this.cancelFormBtnText = opts.cancelFormBtnText;
    this.activeItemsText = opts.activeItemsText;
    this.isAdmin = opts.isAdmin;
    this.isReadOnly = opts.isReadOnly;
    this.ldap = opts.ldap;
    this.formBehavior = opts.formBehavior;
    this.initDataCallback = opts.initData;
    this.onSubmitFormCallback = opts.onSubmitForm;
    this.onCancelFormCallback = opts.onCancelForm;
    
    if ( opts.getLabelHTML )
        this.getLabelHTML = opts.getLabelHTML;
    
    if ( opts.entryMatches )
        this.entryMatches = opts.entryMatches;
    
    this.overlay = new YAHOO.widget.Overlay( "labelpickermenu", { visible: false } );
    
    this.menuButton = new YAHOO.widget.Button( {
        type : 'menu',
        label : opts.buttonText,
        menu : this.overlay,
        container : opts.id
    } );
    
    this.overlay.showEvent.subscribe( function( type, args, labelPicker ) {
        labelPicker.init();
        labelPicker.autoComplete.clear();
        
        //TODO: find a better way to maintain the focus than using a timer
        setTimeout( function() {
            labelPicker.autoComplete.focus();
        }, 50 );

        if ( opts.initData ) {
            labelPicker.initDataCallback();
            $("body").append("<div id=\"role-overlay\"></div>");
            $("div#labelpickermenu").addClass("labelpicker-stick-out");
        }
    }, this );

    if ( opts.formBehavior ) {
        // to hide overlay, you have to set the overlayForceClosing property to true
        // because it will act as a form and it's better to prevent autoclose on click
        this.overlay.beforeHideEvent.subscribe(function(actionName, args, dropDownPicker) {
            if (!dropDownPicker.overlayForceClosing)
                return false
            $("div#role-overlay").remove();
            $("div#labelpickermenu").removeClass("labelpicker-stick-out");
            dropDownPicker.overlayForceClosing = false;
        }, this);
    }
};

WR.DropDownPicker.prototype = {
    init : function() {
        if ( this.initialized )
            return;

        YAHOO.util.Dom.setStyle( "labelpickermenu", "z-index", 1 );
        
        var labelpickermenuEl = WR.DOM.el( YAHOO.util.Dom.get( 'labelpickermenu' ) );
        labelpickermenuEl.appendChild(
                WR.DOM.el( 'div' )
                    .addClass( 'labelPickerLabels' )
                    .appendChild(
                        WR.DOM.el( 'h3' )
                            .innerHTML( this.availableItemsText )
                            .finish()
                    )
                    .appendChild(
                        WR.DOM.el( 'input' )
                            .setProperty( 'id', this.id + '_ac' )
                            .setProperty( 'type', 'text' )
                            .addClass( 'labelPickerInput' )
                            .finish()
                    )
                    .appendChild(
                        WR.DOM.el( 'span' )
                            .setProperty( 'id', this.id + '_ac_container' )
                            .finish()
                    )
                    .appendChild(
                        WR.DOM.el( 'ol' )
                            .setProperty( 'id', this.id + '_labelsList' )
                            .finish()
                    )
                    .finish()
            )
            .appendChild(
                WR.DOM.el( 'div' )
                    .addClass( 'labelPickerActiveItems' )
                    .appendChild(
                        WR.DOM.el( 'h3' )
                            .innerHTML( this.activeItemsText )
                            .finish()
                    )
                    .appendChild(
                        WR.DOM.el( 'ol' )
                            .setProperty( 'id', this.id + '_activeItems' )
                            .finish()
                    )
                    .finish()
            );

            if ( this.formBehavior ) {
                labelpickermenuEl.appendChild(
                    WR.DOM.el( 'div' )
                    .addClass( 'role-form-btn-container' )
                    .appendChild(
                        WR.DOM.el( 'button' )
                            .setProperty( 'id', 'assign-role-submit-btn' )
                            .addClass( 'role-form-btn' )
                            .addClass( 'submit' )
                            .innerHTML( this.submitFormBtnText )
                            .finish()
                    )
                    .appendChild(
                        WR.DOM.el( 'button' )
                            .setProperty( 'id', 'assign-role-cancel-btn' )
                            .addClass( 'role-form-btn' )
                            .addClass( 'cancel' )
                            .innerHTML( this.cancelFormBtnText )
                            .finish()
                    )
                    .finish()
                );

                $( '#assign-role-submit-btn' ).click({picker: this}, this.onSubmitFormCallback);

                $( '#assign-role-cancel-btn' ).click({picker: this}, this.onCancelFormCallback);
            }

        this.labelsList = YAHOO.util.Dom.get( this.id + '_labelsList' );
        this.activeItems = YAHOO.util.Dom.get( this.id + '_activeItems' );

        this.floatingHeaders = {
            labelsList: WR.DOM.el( 'div' )
                .addClass( 'labelpickergroupheader')
                .setStyle( 'display', 'none' )
                .finish(),
            activeItems: WR.DOM.el( 'div' )
                .addClass( 'labelpickergroupheader')
                .setStyle( 'display', 'none' )
                .finish()
        };
        $( this.labelsList ).parent().append( this.floatingHeaders.labelsList );
        $( this.activeItems ).parent().append( this.floatingHeaders.activeItems );
        $( this.labelsList ).bind( 'scroll', {picker: this}, function( ev ) { ev.data.picker._onContainerScroll( "labelsList", $(this) ); } );
        $( this.activeItems ).bind( 'scroll', {picker: this}, function( ev ) { ev.data.picker._onContainerScroll( "activeItems", $(this) ); } );
        
        this.autoComplete = new WR.AutoCompleteFilter( {
            filterInputID : this.id + '_ac',
            filterContainerID : this.id + '_ac_container'
        });
        
        this.autoComplete.subscribeToQueryChange( function( type, args, labelPicker ) {
            labelPicker.updateOptions( this.value() );
        }, this );
        
        this.initialized = true;
    },

    _onContainerScroll : function( el, container ) {
        var groups = this.groupIDs.getSortedArray();

        if ( groups.length == 0 || container.scrollTop() < $(this.groupEls[groups[0]][el]).position().top ) {
            this.hideFloatingHeader( el );
            return;
        }

        var i;
        for ( i = 0; i < groups.length; ++i ) {
            if ( container.scrollTop() < $(this.groupEls[groups[i]][el]).position().top )
                break;
        }
        i--;
        if ( groups.length > i+1 && container.scrollTop() + $(this.floatingHeaders[el]).length.height > $(this.groupEls[groups[i+1]][el]).position().top )
            this.hideFloatingHeader( el );
        else
            this.showFloatingHeader( el, groups[i] );
    },

    showFloatingHeader : function( el, groupID ) {
        var label = this.labels[ groupID ];
        el = $(this.floatingHeaders[el]);
        el.innerHTML = this.getLabelHTML( label.id );
        el.show();  
    },

    hideFloatingHeader : function( el ) {
        el = $(this.floatingHeaders[el]);
        el.hide();
    },
    
    setLabels : function( labels ) {
        this.labels = labels;
    },
    
    getLabelHTML : function( key ) {
        return WR.HTML.escape( key );
    },
    
    formatLabelUI : function( key, container, activeColumn, isInActiveList ) {
    },
	
	unformatLabelUI : function( key ) {
    },
    
    getIsEnabled : function( key ) {
    	return true;
    },
    
    entryMatches : function( key, regex ) {
        return key.search( regex ) != -1;
    },
    
    setInputWidth : function( width ) {
        WR.DOM.el( YAHOO.util.Dom.get( this.id + '_ac' ) )
            .setStyle( 'width', width + 'px' )
            .setStyle( 'border', '1px' );
    },
    
    reset : function() {
        this.labelsList.innerHTML = '';
        this.activeItems.innerHTML = '';
        this.setInputWidth( 50 );
        this.groupIDs = new WR.Set();
        this.groupEls = {};
    },
    
    appendLabelToList : function( label, index, els, isActive, isVisible ) {
        
        var labelItem = function( me, type, isChecked, isActiveList ) {
            
			var labelUI = WR.DOM.el( 'span' );
			me.formatLabelUI( label, labelUI.finish(), isChecked, isActiveList );
			
			var checkbox = WR.DOM.el( 'input' )
                .setProperty( 'id', me.id + '_options_' + type + '_' + index )
                .setProperty( 'type', 'checkbox' )
                .setProperty( 'checked', isChecked )
                .setProperty( 'defaultChecked', isChecked )
                .setProperty( 'disabled', me.getIsEnabled( label ) ? '' : '1' )
                .addListener( 'click', function( e, o ) {
                    var otherCheckbox = YAHOO.util.Dom.get( me.id + '_options_' + ( type == 'visible' ? 'active' : 'visible' ) + '_' + index );
                    if( otherCheckbox ) {
                        otherCheckbox.checked = ( this.checked );
						if ( !this.checked )
							me.unformatLabelUI( labelUI.finish() );
						else
							me.formatLabelUI( label, labelUI.finish(), true, true );
                    } else if ( this.checked && type == 'visible' )
                        WR.DOM.el( o.picker.activeItems ).appendChild( labelItem( o.picker, 'active', true, true ) ).finish();
                    
                    this.checked
                        ? o.picker.addLabelCallback( o.label, o.picker )
                        : o.picker.removeLabelCallback( o.label, o.picker );						
                }, { picker : me, label : label } )
                .finish();
			
            return WR.DOM.el( 'li' )
				.setProperty( 'id', 'li_' + index )
                .appendChild( WR.DOM.el( 'span' )
                    .addClass( 'checkLabel' )
                    .appendChild( checkbox )
                    .appendChild( WR.DOM.el( 'span' )
                        .addClass( 'labelPickerText' )
                        .innerHTML( '<label for="' + checkbox.id + '" title="' + me.getLabelHTML( label ) + '">' + me.getLabelHTML( label ) + '</label>' )
                        .finish() )
                    .finish() )
                .appendChild( labelUI.finish() )
                .finish()
        };
        
        if ( isVisible )
            els.labelsList = WR.DOM.el( els.labelsList ).appendChild( labelItem( this, 'visible', isActive, false ) ).finish();
            
        if ( isActive )
            els.activeItems = WR.DOM.el( els.activeItems ).appendChild( labelItem( this, 'active', isActive, true ) ).finish();
        return els;
    },

    appendLabelGroup : function( id, group, firstID, query, regex, activeLabelSet ) {
        var hasVisibleItems = false;
        var hasActiveItems = false;

        var els = {
            labelsList: WR.DOM.el( 'ol' )
                            .setProperty( 'id', 'optgroup_' + this.groupIDs.length )
                            .addClass( 'labelpickergroup' )
                            .appendChild( WR.DOM.el( 'li' )
                                .addClass( 'labelpickergroupheader' )
                                .innerHTML( this.getLabelHTML( group.id ) )
                                .finish() )
                            .finish(),
            activeItems: WR.DOM.el( 'ol' )
                            .setProperty( 'id', 'optgroup_active_' + this.groupIDs.length )
                            .addClass( 'labelpickergroup' )
                            .appendChild( WR.DOM.el( 'li' )
                                .addClass( 'labelpickergroupheader' )
                                .innerHTML( this.getLabelHTML( group.id ) )
                                .finish() )
                            .finish()
        };
        
        var allowNewLabel = true;
        for( var i in group.items ) {
            var isVisible = !query || this.getLabelHTML( group.items[ i ] ).search( regex ) != -1;
            var isActive = activeLabelSet.contains( group.items[ i ] );

            if ( !isVisible && !isActive )
                continue;
            
            if ( isVisible )
                hasVisibleItems = true;
            if ( isActive )
                hasActiveItems = true;

            if( allowNewLabel && query == group.items[ i ] )
                allowNewLabel = false;

            els = this.appendLabelToList( group.items[ i ], firstID + i, els, isActive, isVisible );
        }

        if ( hasVisibleItems )
            WR.DOM.el( this.labelsList ).appendChild( els.labelsList ).finish();
        if ( hasActiveItems )
            WR.DOM.el( this.activeItems ).appendChild( els.activeItems ).finish();

        this.groupIDs.insert( id );
        this.groupEls[id] = els;
        return allowNewLabel;
    },

    appendLabels : function( query, regex, activeLabelSet ) {
        var allowNewLabel = true;
        var currentID = 0;
        var els = { labelsList: this.labelsList,
                    activeItems: this.activeItems };

        var maxNumLabels = 1000;
        var numNoActiveLabels = 0, numActiveLabels = 0;
        var maxNumNoActiveLabels = ( query ? maxNumLabels : maxNumLabels - activeLabelSet.length );
        var hasVisibleItems = false;

        WR.DOM.el( YAHOO.util.Dom.get( this.id + '_labelsList' ) )
            .setStyle( 'height', 'auto' );
        WR.DOM.el( YAHOO.util.Dom.get( this.id + '_activeItems' ) )
            .setStyle( 'height', 'auto' );

        for ( var i in this.labels ){
            if( typeof this.labels[i] == 'object' ) {
                allowNewLabel = this.appendLabelGroup( i, this.labels[i], currentID, query, regex, activeLabelSet ) && allowNewLabel;
                currentID += this.labels[i].items.length;
            }
            else {
                if( query == this.labels[ i ] )
                    allowNewLabel = false;

                var isActive = activeLabelSet.contains( this.labels[ i ] );
                if ( isActive && ++numActiveLabels > maxNumLabels )
                    break;
                if ( numNoActiveLabels < maxNumNoActiveLabels || isActive ) {
                    var isVisible = !query || this.getLabelHTML( this.labels[ i ] ).search( regex ) != -1;
                    if ( !isVisible )
                        continue;
                    this.appendLabelToList( this.labels[ i ], currentID, els, isActive, isVisible );
                    currentID++;
                    if ( !isActive )
                        numNoActiveLabels++;
                    hasVisibleItems = true;
                }
            }
        }

        if ( !hasVisibleItems ) {
            WR.DOM.el( YAHOO.util.Dom.get( this.id + '_labelsList' ) )
                .setStyle( 'height', 20 + 'px' );
            WR.DOM.el( YAHOO.util.Dom.get( this.id + '_activeItems' ) )
                .setStyle( 'height', 20 + 'px' );
        }

        return allowNewLabel;
    },

    updateOptions : function( query, activeLabel ) {
        this.reset();
        
        var regex = new RegExp( WR.RegExp.escape( WR.HTML.escape( query ) ), "i" );
        
        var activeLabelSet = this.getActiveLabels();
        if( activeLabel )
            activeLabelSet.insert( activeLabel );
        
        var allowNewLabel = ( this.createNewText ? true : false ) && ( this.isAdmin || !this.isReadOnly );
        allowNewLabel = this.appendLabels( query, regex, activeLabelSet ) && allowNewLabel;

        if ( query && allowNewLabel )
        {
            WR.DOM.el( this.labelsList )
                .appendChild(
                    WR.DOM.el( 'li' )
                        .appendChild(
                            WR.DOM.el( 'span' )
                                .addClass( 'newLabel' )
                                .appendChild(
                                    WR.DOM.el( 'a' )
                                        .setProperty( 'href', '#newLabel' )
                                        .innerHTML( WR.HTML.escape( '"' + query + '" ' + this.createNewText ) )
                                        .addListener( 'click', function( e, o ) {
                                            YAHOO.util.Event.preventDefault( e );
                                            o.picker.addLabelCallback( o.label, o.picker );
                                            o.picker.overlay.hide();
                                        }, { picker : this, label : query } )
                                        .finish()
                                )
                                .finish()
                        )
                        .finish()
                );
        }
        
        var labelRegion = YAHOO.util.Dom.getRegion( this.labelsList );
        var activeRegion = YAHOO.util.Dom.getRegion( this.activeItems );
        this.setInputWidth( Math.max( labelRegion.right - labelRegion.left, activeRegion.right - activeRegion.left ) );
    },
	
	enable : function() {
		this.menuButton.set( "disabled", false );
	},
	
	disable : function() {
		this.menuButton.set( "disabled", true );
	}

};