// <?import /JavaScript/WR.js?>
// <?import /JavaScript/Util/DOM.js?>

// options: [ { name : string, value : string, callback : function, selected : bool  } ]
//
WR.DropDownSelect = function( options )
{
    var select = WR.DOM.el( 'select' );
    
    for ( var i=0; i<options.length; i++ )
    {
        var option = options[i];
        
        select.appendChild( WR.DOM.el( 'option' )
            .setProperty( 'selected', option.selected ? 'selected' : '' )
            .innerText( option.name )
            .finish() );
    }
    
    select.addListener( 'change', function()
    {
        options[ select.finish().selectedIndex ].callback();
    } );
    
    this.select = select.finish();
};

WR.DropDownSelect.prototype = {
    
    finish : function() {
        return this.select;
    }
    
};
