// <?import /JavaScript/Util/Set.js?>
// <?import /JavaScript/Util/Array.js?>
// <?import /JavaScript/Filter/AutoCompleteFilter.js?>
// <?import /JavaScript/Util/HTML.js?>
// <?import /JavaScript/yui-import/Event.js?>
// <?import /JavaScript/yui-import/Dom.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/Util/RegExp.js?>
// <?import /JavaScript/Util/History.js?>

/*
 opts.id
 opts.options : WR.Set
 opts.defaultText
 opts.titleText
 opts.clearText
 opts.addOption( option )
 opts.removeOption( option )
 opts.removeAll()
*/
WR.MultiSelectionFilter = function( opts ) {
    this.opts = opts;
    this.activeFilters = new WR.Set( this.opts.activeFilters );
    
    if ( opts.getItemText )
        this.getItemText = opts.getItemText;
    
    var el = WR.DOM.el( YAHOO.util.Dom.get( this.opts.id ) );
    el.appendChild(
        WR.DOM.el( 'div' )
            .addClass( 'yui-g' )
            .appendChild(
                WR.DOM.el( 'div' )
                    .addClass( 'filterTitle' )
                    .addClass( 'yui-u' )
                    .addClass( 'first' )
                    .innerHTML( WR.HTML.escape( this.opts.titleText ) )
                    .finish()
            )
            .appendChild(
                WR.DOM.el( 'div' )
                    .addClass( 'yui-u' )
                    .addClass( 'filterClearLink' )
                    .appendChild(
                        WR.DOM.el( 'a' )
                            .setProperty( 'id', this.opts.id + '_clear' )
                            .setProperty( 'href', '#' + this.opts.id + '/none' )
                            .addClass( 'filterClearLink' )
                            .innerHTML( WR.HTML.escape( this.opts.clearText ) )
                            .addListener( 'click', function( e ) {
                                    YAHOO.util.Event.preventDefault( e );
                                    this.clear();
                                }, this, true )
                            .finish()
                    )
                    .finish()
            )
            .finish()
    );
    el.appendChild(
        WR.DOM.el( 'input' )
            .setProperty( 'id', opts.id + '_ac' )
            .setProperty( 'type', 'text' )
            .addClass( 'filterAutoComplete' )
            .finish()
    );
    el.appendChild(
        WR.DOM.el( 'span' )
            .setProperty( 'id', opts.id + '_ac_container' )
            .appendTo( opts.id )
            .finish()
    );
    el.appendChild(
        WR.DOM.el( 'div' )
            .addClass( 'filterOptions' )
            .appendChild(
                WR.DOM.el( 'ol' )
                    .setProperty( 'id', opts.id + '_optionsList' )
                    .finish()
            )
            .finish()
    );
    el.appendChild(
        WR.DOM.el( 'div' )
            .addClass( 'chosenOptions' )
            .appendChild(
                WR.DOM.el( 'div' )
                    .addClass( 'chosenOptionsText' )
                    .innerHTML( WR.HTML.escape( this.opts.chosenOptionsText + ':' ) )
                    .finish()
            )
            .appendChild(
                WR.DOM.el( 'ol' )
                    .setProperty( 'id', opts.id + '_chosenOptionsList' )
                    .finish()
            )
            .finish()
    )


    if ( this.activeFilters.length == 0 )
        YAHOO.util.Dom.addClass( this.opts.id + '_clear', 'filterClearLink-inactive' );
        
    this.optionsList = YAHOO.util.Dom.get( opts.id + '_optionsList' );
    this.chosenOptionsList = YAHOO.util.Dom.get( opts.id + '_chosenOptionsList' );
    
    this.autoComplete = new WR.AutoCompleteFilter( {
        filterInputID : opts.id + '_ac',
        filterContainerID : opts.id + '_ac_container',
        defaultText : opts.defaultText
    });
    
    this.autoComplete.subscribeToQueryChange( function( type, args, filter ) {
        filter.updateOptions( this.value() );
    }, this );
    
    this.updateOptions();
    this.updateChosenOptions();
};

WR.MultiSelectionFilter.prototype = {
    clear : function() {
        if ( this.activeFilters.length > 0 )
        {
            this.clearLinks();
            this.autoComplete.clear();
            this.opts.removeAll();
        }
    },
    
    clearLinks : function() {
        this.activeFilters.forEach( function( option, me ) {
            me.opts.removeOption( option );
        }, this );
        
        this.activeFilters.erase();
        
        for ( var i = 0; i < this.optionsList.childNodes.length; i++ )
            YAHOO.util.Dom.removeClass( this.optionsList.childNodes[i].firstChild, 'activeFilterOption' );
        
        YAHOO.util.Dom.addClass( this.opts.id + '_clear', 'filterClearLink-inactive' );
        this.updateChosenOptions();
    },
    
    updateOptions : function( query ) {
        this.optionsList.innerHTML = '';
        
        var regex = new RegExp( WR.RegExp.escape( query ), "i" );
        
        var me = this;
        var sortedOptions = this.opts.options.getSortedArray( function ( a, b ) {
            return WR.Array.caseInsensitiveCompare( me.getItemText( a ), me.getItemText( b ) );
        });
        
        for ( var i in sortedOptions )
        {
            var option = sortedOptions[i];
            var optionText = this.getItemText( option );
            
            if ( !query || optionText.search( regex ) != -1 )
            {
                var escapedValue = WR.HTML.escape( optionText );
                
                var callback = function( option ) {
                    return function( e, filter ) {
                        YAHOO.util.Event.preventDefault( e );
                        filter.activeFilters.contains( option )
                            ? filter.removeActiveOption( this, option )
                            : filter.addActiveOption( this, option );
                    };
                }( option );
                
                isActive = this.activeFilters.contains( option );
                WR.DOM.el( this.optionsList )
                    .appendChild(
                        WR.DOM.el( 'li' )
                            .appendChild(
                                WR.DOM.el( 'span' )
                                    .appendChild(
                                        WR.DOM.el( 'img' )
                                            .setProperty( 'src', isActive ? '/images/besreports/' + WR.language + '/selected_checkbox.png' : '/images/besreports/' + WR.language + '/unselected_checkbox.png' )
                                            .setProperty( 'id', this.opts.id + '/' + escapedValue )
                                        .finish()
                                    )
                                    .appendChild(
                                        WR.DOM.el( 'span' )
                                            .addClass( 'optionPickerText' )
                                            .innerHTML( '<label class="' + ( isActive ? 'activeFilterOption' : 'filterOption' ) + '" for="' + this.opts.id + '/' + escapedValue + '">' + escapedValue + '</label>' )
                                        .finish()
                                    )
                                    .addListener( 'click', callback, this )
                                .finish()
                            )
                            .finish()
                    );
            }
        }
    },
    
    updateChosenOptions : function () {
        this.chosenOptionsList.innerHTML = '';
        if ( this.activeFilters.length == 0 ) {
            WR.DOM.el( this.chosenOptionsList )
                .appendChild(
                    WR.DOM.el( 'li' )
                        .innerHTML( WR.HTML.escape( this.opts.defaultOptionsText ) )
                        .addClass( 'defaultText' )
                    .finish()
                    );
        }
        var me = this;
        var sortedOptions = this.activeFilters.getSortedArray( function ( a, b ) {
            return WR.Array.caseInsensitiveCompare( me.getItemText( a ), me.getItemText( b ) );
        });
        
        for ( var i in sortedOptions )
        {
            var option = sortedOptions[i];
            
            var callback = function( option ) {
            return function( e, filter ) {
                filter.removeActiveOption( this, option )
            };
        }( option );
            
            WR.DOM.el( this.chosenOptionsList )
                .appendChild(
                    WR.DOM.el( 'li' )
                        .appendChild(
                            WR.DOM.el( 'img' )
                                .setProperty( 'src', '/images/besreports/' + WR.language + '/selected_checkbox.png' )
                            .finish()
                        )
                        .appendChild( 
                            WR.DOM.el( 'span' )
                                .innerHTML( WR.HTML.escape( this.getItemText( option ) ) )
                            .finish()
                        )
                        .addListener( 'click', callback, this )
                    .finish()
                );
        }
        
        if ( this.opts.history != null )
            this.opts.history.update();
    },
    
    addActiveOption : function( el, option ) {
        this.activeFilters.insert( option );
        YAHOO.util.Dom.removeClass( this.opts.id + '_clear', 'filterClearLink-inactive' );
        this.opts.addOption( option );
        this.updateOptions( this.autoComplete.value() );
        this.updateChosenOptions();
    },
    
    removeActiveOption : function( el, option ) {
        this.activeFilters.remove( option );
        if ( this.activeFilters.length == 0 )
            YAHOO.util.Dom.addClass( this.opts.id + '_clear', 'filterClearLink-inactive' );
        
        this.opts.removeOption( option );
        this.updateOptions( this.autoComplete.value() );
        this.updateChosenOptions();
    },
    
    setOptions : function( optionSet ) {
        this.opts.options = optionSet;
        this.updateOptions( this.autoComplete.value() );
        this.updateChosenOptions();
    },
    
    getItemText : function( item ) {
        return item;
    },
    
    getActiveFilters : function() {
        return this.activeFilters.getArray();
    }
};
