// Condition.js

// <?import /JavaScript/FilterCreation/FilterCreation.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/json2.js?>
// <?import /JavaScript/FilterCreation/FilterCreation.css?>
// <?import /JavaScript/jQuery/jquery.js?>


WR.Filters.Condition = function( parent, contentTypes, conditionManagementCallbacks )
{
    this.id = parent.finish().id + '_condition' + WR.Filters.Condition.nextIdNo++;
    this.el = WR.DOM.el( 'div' )
                .setProperty( 'id', this.id )
                .addClass( 'Condition-Div' );
    WR.DOM.el( parent ).appendChild( this.el.finish() );
    
    this.contentTypes = contentTypes;
    this.conditionManagementCallbacks = conditionManagementCallbacks;
    
    var me = this;
    this.contentTypePicker = this.contentTypes.generateSelect( '',
            function( contentType ) { if ( contentType ) me._contentTypeSelected( contentType ); } );
    this.contentTypePicker.addClass( 'Condition-ContentTypePicker' );
    
    this._initChildren();
    
    this.propertyPicker = null;
    this.selectedContentType = this.contentTypes.get( 0 );
    this.selectedProperty = null;
    this.selectorList = null;
    
    this._setupPropertyPicker( true );
    
};

WR.Filters.Condition.nextIdNo = 0;

WR.Filters.Condition.prototype = {
    
    generateState : function()
    {
        return {
            selectedContentTypeName: this.selectedContentType.id,
            selectorList: this.selectorList? this.selectorList.generateState() : null,
            selectedProperty: this.selectedProperty
        };
    },
    
    applyState : function( state )
    {
        var newContentType = this.contentTypes.findContentTypeByName( state.selectedContentTypeName );
        if ( newContentType != this.selectedContentType )
        {
            $( this.contentTypePicker.finish() ).val( state.selectedContentTypeName );
            this._contentTypeSelected( newContentType );
        }
        
        this.selectedProperty = state.selectedProperty;
        
        if ( this.selectedProperty != null )
            this.propertyPicker.setSelected( this.selectedProperty );
        
        if ( state.selectorList )
        {
            if ( !this.selectorList )
                this._setupSelector();
                
            this.selectorList.applyState( state.selectorList );
        }
    },
    
    isComplete : function()
    {
        return this.selectedProperty != null;
    },
    
    _initChildren : function()
    {
        var me = this;
        this.propertyPickerDiv = WR.DOM.el( 'div' )
                        .addClass( 'Condition-PropertyPickerDiv' );
        this.selectorListDiv = WR.DOM.el( 'div' )
                        .setProperty( 'id', this.id + '_selectorList' )
                        .addClass( 'Condition-SelectorListDiv' );
                        
        this.el.appendChild( WR.DOM.el( 'label' )
                    .addClass( 'OuterBooleanLabel' )
                    .innerText( WR.Filters.OuterBooleanString )
                    .finish() )
                .appendChild( WR.DOM.el( 'div' )
                    .addClass( 'Condition-ContentDiv' )
                    .appendChild( this.contentTypePicker.finish() ) 
                    .appendChild( WR.DOM.el( 'div' )
                        .addClass( 'Condition-Sizer' )
                        .appendChild( this.propertyPickerDiv.finish() )
                        .appendChild( this.selectorListDiv.finish() )
                        .finish() )
                    .finish() )
                .appendChild( WR.DOM.el( 'div' )
                        .addClass( 'Condition-AddRemoveDiv' )
                        .appendChild( WR.DOM.el( 'input' )
                            .setProperty( 'type', 'button' )
                            .setProperty( 'value', '-' )
                            .addClass( 'Condition-RemoveButton' )
                            .addClass( 'WR-button')
                            .addListener( 'click', function( e ) {
                                me.conditionManagementCallbacks.remove( me, me.conditionManagementCallbacks.scope );
                            } )
                            .finish() )
                        .appendChild( WR.DOM.el( 'input' )
                            .setProperty( 'type', 'button' )
                            .setProperty( 'value', '+' )
                            .addClass( 'Condition-AddButton' )
                            .addClass( 'WR-button' )
                            .addListener( 'click', function( e ) {
                                me.conditionManagementCallbacks.add( me, me.conditionManagementCallbacks.scope );
                            } )
                            .finish() )
                        .finish() )
            .appendChild( WR.DOM.el( 'div' ).addClass( 'wr_dummy' ).finish() );
    },
    
    _contentTypeSelected : function( contentType )
    {
        this.selectorList = null;
        this.selectedProperty = null;
        this.selectedContentType = contentType;
        this._setupPropertyPicker();
    
        this.conditionManagementCallbacks.updateContentVisibility( this.conditionManagementCallbacks.scope );
    },
    
    _setupPropertyPicker : function( dontNeedToRemovePickers )
    {
        if ( !dontNeedToRemovePickers )
            $( this.propertyPickerDiv.finish() ).children().remove();
        
        if ( !this.selectedContentType )
            this.propertyPicker = null;
        else
        {
            this.propertyPicker = this.selectedContentType.generatePropertyPicker( this.propertyPickerDiv.finish() );
            
            if ( this.propertyPicker.hasOnlyOneProperty() )
            {
                this._propertySelected( '', [ this.propertyPicker.generateOnlyProperty() ], this );
            }
            else
            {
                $( this.selectorListDiv.finish() ).children().remove();
                this.propertyPicker.onPropertySelected.subscribe( this._propertySelected, this );
            }
        }
    },
    
    _propertySelected : function( type, args, me )
    {
        var propertyData = args[0];
        
        if ( JSON.stringify( me.selectedProperty ) != JSON.stringify( propertyData ) )
        {
            me.selectedProperty = propertyData;
            me._setupSelector();
            WR.Filters.update();
        }
    },
    
    _setupSelector : function()
    {
        var freshSelectorList = this.selectedContentType.generateSelectorList( WR.DOM.el( 'div' ), this.selectedProperty );
        if ( this.selectorList == null
            || freshSelectorList.selectorClass != this.selectorList.selectorClass
            || freshSelectorList.optionalSelectorArgument != this.selectorList.optionalSelectorArgument ) //Preserve old list of selectors if type is the same
        {
            $( this.selectorListDiv.finish() ).children().remove();
            this.selectorList = this.selectedContentType.generateSelectorList( this.selectorListDiv, this.selectedProperty );
        }
    }
    
};