// FilterCreationManager.js

// <?import /JavaScript/Util/HTMLGenerator.js?>
// <?import /JavaScript/CollapsibleSection/CollapsibleSectionWithSpecialHeader.js?>
// <?import /JavaScript/FilterCreation/ContentTypes/ComputerContentType.js?>
// <?import /JavaScript/FilterCreation/ContentTypes/SavedFilterContentType.js?>
// <?import /JavaScript/FilterCreation/ContentTypes/FixletContentType.js?>
// <?import /JavaScript/FilterCreation/ContentTypes/ActionContentType.js?>
// <?import /JavaScript/Properties/PropertiesDataSource.js?>
// <?import /JavaScript/yui-import/Event.js?>
// <?import /JavaScript/FilterCreation/ContentTypes/SiteContentType.js?>
// <?import /JavaScript/Util/JSONRequest.js?>
// <?import /JavaScript/FilterCreation/FilterCreator.js?>
// <?import /JavaScript/json2.js?>
// <?import /JavaScript/Util/Array.js?>
// <?import /JavaScript/Util/URL.js?>
// <?import /JavaScript/FilterCreation/FilterCreation.js?>
// <?import /JavaScript/Util/PostRequest.js?>
// <?import /JavaScript/Notification/Notification.js?>
// <?import /JavaScript/FilterCreation/FilterCreationManager.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/FilterCreation/ContentTypes/ContentTypeGroup.js?>
// <?import /JavaScript/Util/History.js?>
// <?import /JavaScript/yui-import/Container.js?>
// <?import /JavaScript/FilterCreation/FilterCreation.css?>

// <?import /JavaScript/jQuery/jquery.js?>


WR.Filters.FilterCreationManager = function( parent, computerProperties )
{
    var me = this;
    
    this.id = 'filterManager';
    this.el = WR.DOM.el( 'div' )
                .setProperty( 'id', this.id );
    this.contentDiv = WR.DOM.el( 'div' )
        .setProperty( 'id', 'filterContent' );
    this.spinnerImage = WR.DOM.el( 'img' )
                             .setProperty( 'src', '/JavaScript/yui/build/assets/skins/sam/ajax-loader.gif' )
                             .setStyle( 'display', 'none' )
                             .addClass( 'FilterSpinner' );
    
    WR.DOM.el( parent )
        .appendChild( this.contentDiv
            .appendChild( this.el.finish() )
            .appendChild( this.spinnerImage.finish() )
            .finish() );
        
    
    this._initChildren();
    
    function propertyNameCompare( a, b )
    {
        return WR.Array.caseInsensitiveCompare( a.name, b.name );
    }
    
    computerProperties = [].concat( computerProperties );
    
    WR.Array.insertElementIntoSortedArray( computerProperties, {
        id: '***Computer ID***',
        name: '<?jformat Computer ID?>'
        }, propertyNameCompare );
    
    this._calculateLongestPropertyLength( computerProperties );
    
    WR.Filters.ComputerProperties = new WR.PropertiesDataSource( computerProperties );
    WR.Filters.BooleanString = '<?jformat or?>';
    WR.Filters.OuterBooleanString = '<?jformat and?>';
    WR.Filters.AddSelectorString = '<?jformat add clause?>';
    
    this._initFilterCreator();
    
    WR.Filters.update = function()
        {
            me._update();
        };
        
    WR.Filters.applyFilter = function()
        {
            me.applyFilter();
        }
        
    WR.Filters.History = new WR.History( this.id, this, {
        generateState: this.generateState,
        loadInitialState: this.loadState
    } );
    
    WR.Filters.filterChanged = new YAHOO.util.CustomEvent( "filterChanged" );
    
    WR.Filters.FilterManagementSettings.onFilterClick = function( id ) { me._loadFilter( id, me ); };
    
    this.saveDialog = new YAHOO.widget.Dialog( 'saveAsFilterDialog', { visible: false, modal: true, fixedcenter: true, postmethod: 'none', hideaftersubmit: false, keylisteners: new YAHOO.util.KeyListener( 'saveAsFilterDialog',
                                                                { keys: 13 },
                                                                { fn: function( type, args, obj ) { me._handleSave( me ); },
                                                                  scope: this,
                                                                  correctScope: true } )  } );
    var buttons = [ { text: "<?jformat Save?>", isDefault: true, handler: function() { me._handleSave( me ); } }, { text: "<?jformat Cancel?>", handler: function() { me._handleSaveCanceled( me ); } } ];
    this.saveDialog.cfg.queueProperty( "buttons", buttons );
    this.saveDialog.render();
    
    this.hasUnsavedChanges = false;
    
    this.tooLargeWarning = WR.DOM.el( 'div' )
        .addClass( 'TooLargeWarningDiv' );
    
    this.filterName = '';
    WR.Filters.filterID = '';
};

WR.Filters.FilterCreationManager.prototype = {
    
    loadState : function( state, me )
    {
        if ( me == null )
            me = this;
        
        if ( state == null )
        {
            if ( me.defaultState != null )
                state = me.defaultState;
            else
                return;
        }
        else if ( ( state.filterID == null || state.filterID == '' )
            && ( state.filterName == null || state.filterName == '' )
            && ( state.filterDescription == null || state.filterDescription == '' ) )
        {
            return;
        }
        
        if ( state.isValid != null && state.isValid == false )
            WR.Notify.warning( "<?jformat This filter references items that either no longer exists or you don't have permission to view.  No data will be available until either the errors have been fixed or a different filter has been selected.?>" );

        
        WR.Filters.History.runWhileIgnoringUpdates( function() { me.clear(); } );
        
        me._hideUIForLoad();
        
        if ( me == null )
            me = this;
            
        if ( state.filterID != null && state.filterID != ''  && state.filterDescription == null )
        {
            //If referencing a saved filter, we need to first pull the filter down from the server
            WR.Filters.History.runWhileIgnoringUpdates( function() { me._loadFilter( state.filterID, me ) } );;
        }
        else
        {
            var parsedDescription = JSON.parse( state.filterDescription );
            if ( parsedDescription.filterIsTooLong )
            {
                var size = parsedDescription.conditionCount;
                state.filterDescription = null;
                me.loadTooLargeState( state, size, false );
            }
            else
            {
                var size = me._calculateNumConditions( state );
                if ( size >= 100 || ( YAHOO.env.ua.ie == 7 && size >= 10 ) )
                    me.loadTooLargeState( state, size, true );
                else
                {
                    me.largeState = null;
                    me.applyState( state, me );
                }
            }
            
            WR.Filters.update();
            
            me.creatorID = state.creatorID;
            
            me._updateNameDisplay();
            me._showUIAfterLoad();
            
            WR.Filters.History.runWhileIgnoringUpdates( function() { me.applyFilter(); } )
        }
    },
    
    loadTooLargeState : function( state, size, editable )
    {
        this._loadNameAndID( state );
        $( this.filterCreator.el.finish() ).hide();
        this.largeState = state;
        this.el.appendChild( this.tooLargeWarning.finish() );

        if ( editable )
        {
            var hereLink = '<a href="javascript:void(0)"><?jformat here?></a>';
            $( this.tooLargeWarning.finish() ).html( WR.format( '<?jformat This filter has {num} conditions and subconditions.  Editing it may result in poor performance.  Click {here_link} to edit it.?>', size, hereLink ) );
            
            var me = this;
            $( this.tooLargeWarning.finish() ).find( 'a' ).click( function()
            {
                $( me.filterCreator.el.finish() ).show();
                $( me.tooLargeWarning.finish() ).remove();
                me.largeState = null;
                me._hideUIForLoad();
                
                setTimeout( function()
                {
                    me.applyState( state, me );
                    me._showUIAfterLoad();
                }, 0 );
            } );
        }
        else
            $( this.tooLargeWarning.finish() ).text( WR.format( '<?jformat This filter has {num} conditions and subconditions.  It cannot be viewed or edited, but will be applied to all results on this page.?>', size ) );
    },
    
    generateState : function( me )
    {
        var state = {
            filterName: me.filterName,
            filterID: WR.Filters.filterID
        };
        
        if ( me.hasUnsavedChanges )
        {
            state.filterDescription = me.generateDescription();
            if ( WR.Filters.filterID != '' )
            {
                state.filterName = '';
                state.filterID = '';
            }
        }
            
        return state;
    },
    
    applyState : function( state, me )
    {
        me._loadNameAndID( state );
        me.filterCreator.applyState( JSON.parse( state.filterDescription ) );
    },
    
    _update : function()
    {  
        var filterDescription = this.generateDescription();
        if ( JSON.stringify( filterDescription ) != WR.Filters.filterDescription )
        {
            this.hasUnsavedChanges = true;
            
            this._updateNameDisplay();
            
            $( '#Filter-ApplyButton' ).prop( 'disabled', false );
        }
    },
    
    applyFilter :  function()
    {
        $( '#Filter-ApplyButton' ).prop( 'disabled', true );
        WR.Filters.History.update();
        WR.Filters.filterDescription = this.generateDescription();
        
        //Since we just updated the history, if another module updates their history before we go back to idle, the filter history will get overwritten, so we must wait
        if ( WR.History.isLoadComplete )
        {
            if ( this.isLegacyPage )
                return this._applyFilterLegacy();
            
            setTimeout( function()
            {
                WR.Filters.filterChanged.fire( WR.Filters.filterDescription );
            }, 1 );
        }
    },
    
    _applyFilterLegacy : function() {
        if ( !WR.Filters.filterDescription || !WR.Filters.filterCreationManager )
            return;
        
        WR.TextShortener.ShortenText( 'newFilter=true&filter=' + encodeURIComponent( WR.Filters.filterDescription ), {
            success : function( shortDescription ) {
                WR.TextShortener.ShortenText( JSON.stringify( WR.Filters.filterCreationManager.generateState( WR.Filters.filterCreationManager ) ), {
                    success : function( shortJSON ) {
                        var url = window.location.href;
                        var params = new WR.URL.ParamMap( WR.URL.ParseParams( WR.URL.getQuery( url ) ) );
                        
                        params.remove( 'filter' );
                        params.remove( 'newFilter' );
                        params.set( 'ShortenedParams', shortDescription );
                        
                        var newURL = '?' + params.finish() + '#filterManager=' + shortJSON;
                        window.location.href = url.substring( 0, url.indexOf( '?' ) ) + newURL;
                    },
                    failure : function( error ) {
                        WR.Notify.error( 'Could not shorten filter JSON.' );
                    }
                } );
            },
            failure : function( error ) {
                WR.Notify.error( 'Could not shorten filter description.' );
            }
        } );
    },
    
    clear : function()
    {
        $( this.filterCreator.el.finish() ).remove();
        $( '#Filter-ApplyButton' ).remove();
        this._initFilterCreator();
        this.largeState = null;
        $( this.tooLargeWarning.finish() ).remove();
        
        WR.Filters.filterID = '';
        this.filterName = '';
        this.creatorID = null;
        
        WR.Filters.update();
    },
    
    setupDefaultFixletFilter : function()
    {
        this.defaultState = {
            filterName: '',
            filterID: '',
            filterDescription: JSON.stringify( {
                conditionList: [
                    {
                        selectedContentTypeName: 'Fixlet',
                        selectedProperty: {
                            name: '<?jformat Visibility?>',
                            id: 'Visibility'
                        },
                        selectorList: []
                    }
                ]
            } )
        };
    },
    
    generateDescription : function()
    {
        if ( this.largeState == null )
            return JSON.stringify( this.filterCreator.generateState( this ) );
        else
            return this.largeState.filterDescription;
    },
    
    _hideUIForLoad : function()
    {
        $( this.el.finish() ).hide();
        $( this.spinnerImage.finish() ).show();
    },
    
    _showUIAfterLoad : function()
    {
        $( this.el.finish() ).show();
        $( this.spinnerImage.finish() ).hide();
    },
    
    _loadNameAndID : function( state )
    {
        this.filterName = state.filterName ? state.filterName : '';
        WR.Filters.filterID = state.filterID ? state.filterID : '';
        this._updateNameDisplay();
    },
    
    _updateNameDisplay : function()
    {
        var displayName = this.filterName;
        if ( this.hasUnsavedChanges && this.filterName != '' )
            displayName += '*';
            
        $( '#filterSection .CollapsibleHeaderLabel' ).text( '<?jformat Filter?>' +
            ( displayName != ''
            ? ' - ' + displayName
            : '' ) );
        
        if ( this.creatorID != null && this.creatorID != WR.currentUserID && !WR.currentUserIsAdmin )
        {
            $( '#SaveAsFilterLink' ).show();
            $( '#SaveFilterLink' ).hide();
        }
        else
        {
            if ( WR.Filters.filterID == '' )
            {
                $( '#SaveAsFilterLink' ).hide();
                $( '#SaveFilterLink' ).show();
            }
            else if ( this.hasUnsavedChanges )
            {
                $( '#SaveAsFilterLink' ).show();
                $( '#SaveFilterLink' ).show();
            }
            else
            {
                $( '#SaveAsFilterLink' ).show();
                $( '#SaveFilterLink' ).hide();
            }
        }
    },
    
    _initFilterCreator : function()
    {
        this.filterCreator = new WR.Filters.FilterCreator( this.el,
            new WR.Filters.ContentTypeGroup( [ new WR.Filters.ComputerContentType(),
                                                        new WR.Filters.FixletContentType(),
                                                        new WR.Filters.ActionContentType(),
                                                        new WR.Filters.SavedFilterContentType(),
                                                        new WR.Filters.SiteContentType() ] ) );
        
        if ( !WR.Filters.hideApplyButton )
            this._initApplyButton();
    
    },
    
    _initChildren : function()
    {
        var filterManagementDiv = WR.DOM.el( 'div' )
                .addClass( 'FilterCreationManager-ManageDiv' )
                .appendChild( WR.DOM.el( 'span' )
                    .setProperty( 'id', 'SaveFilterLink' )
                    .appendChild( WR.HTMLGenerator.createJavaScriptLink( '<?jformat Save Filter?>', this._saveClicked, this ).finish() )
                    .appendChild( WR.DOM.el( 'span' ).addClass( 'CollapsibleLinkSeparator' ).finish() )
                    .finish() )
                .appendChild( WR.DOM.el( 'span' )
                    .setProperty( 'id', 'SaveAsFilterLink' )
                    .setStyle( 'display', 'none' )
                    .appendChild( WR.HTMLGenerator.createJavaScriptLink( '<?jformat Save Filter As?>', this._saveAsClicked, this )
                                .finish() )
                    .appendChild( WR.DOM.el( 'span' ).addClass( 'CollapsibleLinkSeparator' ).finish() )
                    .finish() )
                .appendChild( WR.HTMLGenerator.createJavaScriptLink( '<?jformat Load Filter?>', this._loadClicked, this )
                            .setProperty( 'id', 'LoadFilterLink' ).finish() )
                .appendChild( WR.DOM.el( 'span' ).addClass( 'CollapsibleLinkSeparator' ).finish() )
                .appendChild( WR.HTMLGenerator.createJavaScriptLink( '<?jformat Clear?>', this._clearClicked, this )
                            .setProperty( 'id', 'ClearFilterLink' ).finish() )
                
        this.el.appendChild( filterManagementDiv.finish() );
        
        WR.MakeSectionCollapsibleWithSpecialHeader( this.contentDiv.finish(), '<?jformat Filter?>', 'Filter', filterManagementDiv );
        
    },
    
    _initApplyButton : function()
    {
        var me = this;
        this.el.appendChild( WR.DOM.el( 'input' )
            .setProperty( 'type', 'button' )
            .setProperty( 'value', '<?jformat Apply Filter?>' )
            .setProperty( 'id', 'Filter-ApplyButton' )
            .setProperty( 'disabled', 'disabled' )
            .addClass( 'WR-button' )
            .addListener( 'click', function()
                         {
                            me.applyFilter();
                         } ) 
            .finish() );
    },
    
    _saveClicked : function( me )
    {
        if ( WR.Filters.filterID == '' )
            me.saveDialog.show();
        else
            me._sendSaveToServer();
    },
    
    _saveAsClicked : function( me )
    {
        $( '#filterNameInput' ).val( me.filterName );
        me.saveDialog.show();
    },
    
    _handleSave : function( me )
    {
        var newFilterName = $( '#filterNameInput' ).val();
        if ( newFilterName != '' )
        {
            if ( newFilterName != me.filterName )
                WR.Filters.filterID = '';
            me.filterName = newFilterName;
            WR.Filters.update();
            me.saveDialog.hide();
            me._sendSaveToServer();
        }
    },
    
    _sendSaveToServer : function()
    {
        var params = {};
        params.filterID = WR.Filters.filterID;
        params.filterName = this.filterName;
        params.filterDescription = this.generateDescription();
        
        var me = this;
        WR.postRequest( '/post/savefilter', { success: function( o ) {
            var newFilter = JSON.parse( o.responseText );
            var newID = WR.Filters.filterID != newFilter.info.filterID;
            WR.Filters.filterID = newFilter.info.filterID;
            me.hasUnsavedChanges = false;
            me.applyFilter();
            me._updateNameDisplay();
            WR.Notify.update( '<?jformat Filter saved.?>' );
            if ( newID )
            {
                WR.Array.insertElementIntoSortedArray( WR.Filters.SavedFilterNames, newFilter, function( a, b ) {
                    return WR.Array.caseInsensitiveCompare( a.info.filterName, b.info.filterName );
                } );
            }
            else
            {
                var index = WR.Array.binarySearchForExisting( WR.Filters.SavedFilterNames, newFilter, function( a, b ) {
                    return WR.Array.caseInsensitiveCompare( a.info.filterName, b.info.filterName );
                } );
                WR.Filters.SavedFilterNames[index] = newFilter;
            }
            
            WR.Filters.FilterManagementDataTable.refreshData();
        },
        failure: function( o ) {
            WR.Notify.error( '<?jformat Failed to save filter: ?>' + o.responseText );
        } }, new WR.URL.ParamMap( params ) );
    },
    
    _handleSaveCanceled : function( me )
    {
        me.saveDialog.hide();
    },
    
    _loadClicked : function( me )
    {
        WR.Filters.filterManagementPanel.show();
        
        if ( !WR.Filters.SavedFiltersLoaded )
        {
            WR.Filters.FilterManagementDataTable.showSpinner();

            me.loadAllFilters( true, {
                    success: function( o, me ) {
                        WR.Filters.filterManagementPanel.show(); // Needed to display properly in IE
                        WR.Filters.FilterManagementDataTable.hideSpinner();
                    },
                    failure: function( o, me ) {
                        WR.Notify.error( WR.format( '<?jformat Failed to load saved filters: {errorMessage}?>', o.responseText ) );
                    }
                }, me
            );
        }
    },
    
    _loadFilter : function ( id, scope )
    {
        scope.clear();
        WR.Filters.filterManagementPanel.hide();
        
        scope._hideUIForLoad();
        
        WR.History.loadTimeSafeJSONRequest( 'getfilter', { success: function( o, me ) {
            var state = o;
            me.loadState( state, me );
            me.hasUnsavedChanges = false;
            me._updateNameDisplay();
            WR.Filters.History.update();
        },
        failure: function( o, me ) {
            WR.Notify.error( '<?jformat Failed to load saved filter.?>' );
            scope._showUIAfterLoad();
        } }, { filterID: id }, scope );
        
    },
    
    loadAllFilters : function( isVisible, callbacks, scope ) {
        
        var newCallbacks = {
            success: function( o, me ) {
                if (isVisible)
                {
                    WR.Filters.SavedFilterNames = o;
                    WR.Filters.SavedFiltersLoaded = true;
                    WR.Filters.FilterManagementDataTable.refreshData();
                }
                else
                {
                    WR.Filters.HiddenSavedFilterNames = o;
                    WR.Filters.HiddenSavedFiltersLoaded = true;
                }
                if (callbacks.success != null)
                    callbacks.success( o, me );
            },
            failure: callbacks.failure != null ? callbacks.failure : function( o, me ) {
                WR.Notify.error( WR.format( '<?jformat Failed to load saved filters: {errorMessage}?>', o.responseText ) );
            },
            start: callbacks.start
        };

        WR.jsonRequest( 'getallfilters', newCallbacks, {visible: isVisible}, scope );
    },
    
    _calculateNumConditions : function( state )
    {
        var conditionList = JSON.parse( state.filterDescription ).conditionList;
        var conditions = 0;
        for ( i in conditionList )
        {
            if ( conditionList[i].selectorList )
                conditions += conditionList[i].selectorList.length;
            else
                conditions++;
        }
        return conditions;
    },
    
    _clearClicked : function( me )
    {
        me.clear();
        me.applyFilter();
    },
    
    _calculateLongestPropertyLength : function( computerProperties )
    {
        WR.Filters.LongestComputerPropertyLength = 0;
        
        for ( i in computerProperties )
        {
            if ( computerProperties[i].name.length > WR.Filters.LongestComputerPropertyLength )
                WR.Filters.LongestComputerPropertyLength = computerProperties[i].name.length;
        }
    }
};
