// FilterCreator.js

// <?import /JavaScript/Util/HTMLGenerator.js?>
// <?import /JavaScript/FilterCreation/FilterCreationManager.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/FilterCreation/ConditionList.js?>
// <?import /JavaScript/FilterCreation/FilterCreation.js?>
// <?import /JavaScript/FilterCreation/FilterCreation.css?>
// <?import /JavaScript/jQuery/jquery.js?>


WR.Filters.FilterCreator = function( parent, contentTypes )
{
    this.id = parent.finish().id + '_filterCreator';
    this.el = WR.DOM.el( 'div' )
                .setProperty( 'id', this.id )
                .addClass( 'FilterCreator-Div' );
    WR.DOM.el( parent ).appendChild( this.el.finish() );
    
    this.contentTypes = contentTypes;
    
    this._initChildren();
    
    this.conditionList = new WR.Filters.ConditionList( this.el, this.contentTypes );
    
    this._setupEmptyConditionListHandling();
    
    this.el.appendChild( WR.DOM.el( 'div' ).addClass( 'DummyDiv' ).finish() );
};

WR.Filters.FilterCreator.prototype = {
    
    generateState : function()
    {
        var state = {};
        state.matchType = $('.FilterCreator-MatchTypeDiv select option:selected').val();
        state.conditionList = this.conditionList.generateState();
        
        if ( this.databaseSelect != null )
            state.conditionList.push( this._generateDatabaseCondition() );
        
        return state;
    },
    
    applyState : function( state )
    {
        if( state.matchType != null && state.matchType != '' )
            $('.FilterCreator-MatchTypeDiv select').val( state.matchType );
        
        this._allAnyChanged();
      
        var newList = [];
        for ( var i in state.conditionList )
        {
            if ( state.conditionList[i].selectedContentTypeName == 'Database' )
                this._applySpecialCondition( state.conditionList[i] );
            else
                newList.push( state.conditionList[i] );
        }
        
        this.conditionList.applyState( newList );
    },
    
    _generateSpecialCondition : function( name, selector )
    {   
        var condition = {
            selectedContentTypeName: name,
            selectedProperty: {
                id: '',
                name: ''
            },
            selectorList: []
        }
        
        var values = $( selector.finish() ).val();
        
        for ( var i in values )
        {
            condition.selectorList.push( {
                selectedOperatorName: 'is',
                selectedOperatorValue: values[i]
            } );
        }
        
        return condition; 
    },
    
    _generateDatabaseCondition : function()
    {
        return this._generateSpecialCondition( 'Database', this.databaseSelect );      
    },
    _applySpecialCondition : function( condition )
    {
        var name = condition.selectedContentTypeName;
        var selector;
        if ( name == 'Database' )
        {
            var databases = [];
            for ( var i in condition.selectorList )
            {
                databases[i] = { name: condition.selectorList[i].selectedOperatorValue, id: condition.selectorList[i].selectedOperatorValue }
            }
            if ( this.databaseSelect == null )
                this._addDatabaseFilter( databases );
            selector = this.databaseSelect;
        }
        
        var values = [];
        for ( var i in condition.selectorList )
        {
            values.push( condition.selectorList[i].selectedOperatorValue );
        }
        
        $( selector.finish() ).val( values );
        $( '#pickDatabaseDiv' ).show();
    },
    
    _setupEmptyConditionListHandling : function()
    {
        var me = this;
        this.conditionList.onConditionRemoved.subscribe(
            function()
            {
                if ( me.conditionList.length == 0 )
                {
                    $( me.emptyConditionListButtons.finish() ).show();
                    $( me.conditionList.el.finish() ).hide();
                }
            } );
        
        this.conditionList.onConditionAdded.subscribe(
            function() {
                $( me.emptyConditionListButtons.finish() ).hide();
                $( me.conditionList.el.finish() ).show();
            } );
    },
    
    _initChildren : function()
    {
        this.addDatabaseLink = WR.HTMLGenerator.createJavaScriptLink( '<?jformat Add Datasource Filter?>', function( me ) {
            me._addDatabaseFilter();
            WR.Filters.update();
        }, this );
        
        var databaseDiv = WR.DOM.el( 'div' )
                    .setProperty( 'id', 'pickDatabaseDiv' )
                    .setStyle( 'display', 'none' );
        if ( WR.Filters.DatabaseNames.length > 1 )
        {
            databaseDiv.appendChild( this.addDatabaseLink.finish() );
            databaseDiv.setStyle( 'display', 'block' );
        }
        
        var me = this;
        this.el.appendChild( databaseDiv.finish() )
            .appendChild( WR.DOM.el( 'div' )
                .addClass( 'FilterCreator-MatchTypeDiv' )
                .appendChild( WR.DOM.el( 'label' )
                    .innerHTML( '<?jformat Results match ?>' )
                    .finish())
                .appendChild( new WR.DOM.Element( 'select' )
                    .addClass( 'MatchTypeSelect' )
                    .addListener( 'change', function( e ) { me._allAnyChanged(); } )
                    .appendChild( new WR.DOM.Element( 'option' )
                        .setProperty( 'value', 'all' )
                        .innerHTML( '<?jformat all?>' )
                        .finish() )
                    .appendChild( new WR.DOM.Element( 'option' )
                        .setProperty( 'value', 'any' )
                        .innerHTML( '<?jformat any?>' )
                        .finish() )
                    .finish() )
                .appendChild( WR.DOM.el( 'label' )
                    .innerHTML( '<?jformat  conditions.?>' )
                    .finish() )
                .finish() );
        
        this.emptyConditionListButtons = WR.DOM.el( 'div' )
                        .addClass( 'AddToEmptyListDiv' )
                        .appendChild( WR.HTMLGenerator.createJavaScriptLink( '<?jformat Add Filter Condition?>',
                                                                            function( e ) {
                                                                                me.conditionList.addNewConditionAfter( -1 );
                                                                            } )
                                    .finish() );
        this.el.appendChild( this.emptyConditionListButtons.finish() );
        $( this.emptyConditionListButtons.finish() ).hide();
    },
    
    _addDatabaseFilter : function( databases )
    {
        var names = [];
        var values = [];
        
        if ( databases == null )
            databases = WR.Filters.DatabaseNames;
        else
        {
            for ( var i in WR.Filters.DatabaseNames )
            {
                var found = false;
                for ( var j in databases )
                {
                    if ( databases[j].id == WR.Filters.DatabaseNames[i].id )
                    {
                        found = true;
                        databases[j].name = WR.Filters.DatabaseNames[i].name;
                        break;
                    }
                }
                if ( !found )
                    databases.push( WR.Filters.DatabaseNames[i] );
            }
        }
        
        jQuery.each( databases, function() {
            names.push( this.name );
            values.push( this.id );
        } );
        
        this.databaseSelect = WR.HTMLGenerator.createSelectFromEscapedEntries( '', names, '', values )
            .setProperty( 'multiple', true )
            .setProperty( 'size', 5 )
            .addListener( 'change', function( e ) { WR.Filters.update(); } );
            
        $( '#pickDatabaseDiv' ).children().remove();
            
        WR.DOM.get( 'pickDatabaseDiv' )
            .appendChild( WR.DOM.el( 'label' )
                    .setProperty( 'id', 'pickDatabaseLabel' )
                    .innerText( '<?jformat Datasources to include:?>' )
                    .finish() )
            .appendChild( this.databaseSelect.finish() );
        
    },
    
    _allAnyChanged : function()
    {
        var matchType = $( '#' + this.id + ' .MatchTypeSelect' ).val();
        WR.Filters.BooleanString = matchType == 'all'? '<?jformat or?>' : '<?jformat and?>';
        WR.Filters.OuterBooleanString = matchType == 'all'? '<?jformat and?>' : '<?jformat or?>';
        $( '#' + this.id + ' .AddSelectorLink' ).html( WR.Filters.AddSelectorString );
        $( '#' + this.id + ' .BooleanLabel' ).html( WR.Filters.BooleanString );
        $( '#' + this.id + ' .OuterBooleanLabel' ).html( WR.Filters.OuterBooleanString );
        WR.Filters.update();
    }
};