// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/FilterCreation/Operators/Operator.js?>
// <?import /JavaScript/yui-import/YahooGlobalObject.js?>
// <?import /JavaScript/jQuery/jquery.js?>

WR.Filters.MultipleOpsOperator = function( id, name, operators )
{
    this.operators = [];
    
    for ( var i in operators )
    {
        var op = new operators[i].operatorClass();
        operators[i].operatorClass.apply( op, operators[i].operatorArgs );
        this.operators[i] =
        {
            key: operators[i].key,
            label: operators[i].label,
            operator: op
        }
    }
    
    WR.Filters.MultipleOpsOperator.superclass.constructor.call( this, id, name );
};

WR.Filters.MultipleOpsOperator.prototype = {
    
    generateValuePicker : function( div )
    {
        div.addClass( 'MultipleOpsValueField' );
        if ( $( div.finish() ).children().length == 0 )
        {
            for ( var i in this.operators )
            {
                if ( this.operators[i].label != null )
                    div.appendChild( WR.DOM.el( 'label' ).innerText( this.operators[i].label ).finish() ).finish();
                var operatorDiv = WR.DOM.el( 'div' );
                div.appendChild( operatorDiv.finish() );
                this.operators[i].operator.generateValuePicker( operatorDiv );
            
            }
        }
        else
        {
            var me = this;
            $( div.finish() ).find( '.ValuePickerField' ).map( function( index, el )
            {
                me.operators[index].operator.valueField = WR.DOM.el( el );
            } );
        }
    },
    
    getValue : function()
    {
        var value = {};
        if ( this.operators[0].operator.valueField != null )
        {
            for ( var i in this.operators )
            {
                value[ this.operators[i].key ] = this.operators[i].operator.getValue();
            }
            return JSON.stringify( value );
        }
        else
            return null;
    },
    
    setValue : function( value )
    {
        var parsedValue = JSON.parse( value );
        for ( var i in this.operators )
        {   
            this.operators[i].operator.setValue( parsedValue[ this.operators[i].key ] );
        }
    }
    
};

YAHOO.lang.extend( WR.Filters.MultipleOpsOperator, WR.Filters.Operator, WR.Filters.MultipleOpsOperator.prototype );