// RelativeDateOperator.js

// <?import /JavaScript/FilterCreation/FilterCreation.js?>
// <?import /JavaScript/FilterCreation/FilterCreationManager.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/Util/HTMLGenerator.js?>
// <?import /JavaScript/FilterCreation/Operators/Operator.js?>
// <?import /JavaScript/yui-import/YahooGlobalObject.js?>
// <?import /JavaScript/FilterCreation/FilterCreation.css?>
// <?import /JavaScript/jQuery/jquery.js?>


WR.Filters.RelativeDateOperator = function( id, name )
{
    WR.Filters.RelativeDateOperator.superclass.constructor.call( this, id, name );
};

WR.Filters.RelativeDateOperator.prototype = {
    
    generateValuePicker : function( div )
    {
        
        if ( $( div.finish() ).children().length == 0 )
        {
            this.textField = WR.DOM.el( 'input' )
                .addClass( 'NumberPickerField' )
                .addListener( 'blur', function( e ) { WR.Filters.update(); } );
                
            this.rangePicker = WR.HTMLGenerator.createSelectFromEscapedEntries( '', [ '<?jformat days?>', '<?jformat hours?>', '<?jformat minutes?>', '<?jformat seconds?>' ],
                                                              '', [ 'days', 'hours', 'minutes', 'seconds' ] )
                                    .addClass( 'ValuePickerField' )
                                    .addListener( 'change', function( e ) { WR.Filters.update(); } );
            
            div.appendChild( this.textField.finish() )
                .appendChild( this.rangePicker.finish() )
                .appendChild( WR.DOM.el( 'label' )
                             .addClass( 'ValuePickerField' )
                             .innerHTML( '<?jformat ago?>' )
                             .finish() );
        }
        else
        {
            this.textField = WR.DOM.el( $( div.finish() ).children().get( 0 ) );
            this.rangePicker = WR.DOM.el( $( div.finish() ).children().get( 1 ) );
        }
        
        
        
    },
    
    getValue : function()
    {
        if ( this.textField )
        {
            var val = $( this.textField.finish() ).val();
            var rangeVal = $( this.rangePicker.finish() ).val();
            if ( rangeVal == 'seconds' )
                return String( val );
            else if ( rangeVal == 'minutes' )
                return String( val * 60 );
            else if ( rangeVal == 'hours' )
                return String( val * 60 * 60 );
            else if ( rangeVal == 'days' )
                return String( val * 60 * 60 * 24 );
            else
                throw "invalid time range selected";
        }
        else
            return '';
    },
    
    setValue : function( value )
    {
        if ( value % 60 != 0 )
        {
            $( this.textField.finish() ).val( value );
            $( this.rangePicker.finish() ).val( 'seconds' );
            return;
        }
        value = Math.floor( value / 60 );
        
        if ( value % 60 != 0 )
        {
            $( this.textField.finish() ).val( value );
            $( this.rangePicker.finish() ).val( 'minutes' );
            return;
        }
        value = Math.floor( value / 60 );
        
        if ( value % 24 != 0 )
        {
            $( this.textField.finish() ).val( value );
            $( this.rangePicker.finish() ).val( 'hours' );
            return;
        }
        value = Math.floor( value / 24 );
        
        $( this.textField.finish() ).val( value );
        $( this.rangePicker.finish() ).val( 'days' );
        
    }
    
};

YAHOO.lang.extend( WR.Filters.RelativeDateOperator, WR.Filters.Operator, WR.Filters.RelativeDateOperator.prototype );