// ActionPropertyPicker.js

// <?import /JavaScript/FilterCreation/FilterCreation.js?>
// <?import /JavaScript/Util/HTMLGenerator.js?>
// <?import /JavaScript/FilterCreation/ContentTypes/ActionContentType.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/FilterCreation/PropertyPickers/PropertyPicker.js?>
// <?import /JavaScript/Util/Array.js?>
// <?import /JavaScript/yui-import/YahooGlobalObject.js?>
// <?import /JavaScript/FilterCreation/FilterCreation.js?>
// <?import /JavaScript/jQuery/jquery.js?>

WR.Filters.ActionPropertyPicker = function( div )
{
    WR.Filters.ActionPropertyPicker.superclass.constructor.call( this, div, new WR.Filters.ActionContentType() );
    
    var propertyNames = [];
    jQuery.each( WR.Filters.ActionProperties, function() {
        if ( WR.Array.indexOf( WR.Filters.ActionPropertyPicker.EXCLUDED_ACTION_PROPERTIES, this.id ) < 0 )
            propertyNames.push( this.name );
    } );
    
    this.selectEl = WR.HTMLGenerator.createSelectFromEscapedEntries( '<?jformat Select A Property?>', propertyNames );
    
    WR.DOM.el( div ).appendChild( this.selectEl.finish() );
    
    var me = this;
    this.selectEl.addListener( 'change', function( e ) {
        var selectedName = jQuery( me.selectEl.finish() ).val();
        
        var selectedProperty = { id: '', name: '' };
        for ( i in WR.Filters.ActionProperties )
        {
            if ( WR.Filters.ActionProperties[i].name == selectedName ){
                selectedProperty = WR.Filters.ActionProperties[i];
                break;
            }
        }
        
        me.onPropertySelected.fire( selectedProperty );
    } );
};

WR.Filters.ActionPropertyPicker.EXCLUDED_ACTION_PROPERTIES = []; //[ 'Sitename', 'Download Size', 'Mean Time to Remediate', 'Activation Time (Analysis)' ];


WR.Filters.ActionPropertyPicker.prototype = {
    
    setSelected : function( propertyData )
    {
        var name = propertyData.name;
        jQuery( this.selectEl.finish() ).val( name );
        
        this.onPropertySelected.fire( propertyData );
    }
    
};

YAHOO.lang.extend( WR.Filters.ActionPropertyPicker, WR.Filters.PropertyPicker, WR.Filters.ActionPropertyPicker.prototype );


