// ComputerPropertyPicker.js

// <?import /JavaScript/FilterCreation/FilterCreation.js?>
// <?import /JavaScript/FilterCreation/FilterCreationManager.js?>
// <?import /JavaScript/FilterCreation/PropertyPickers/PropertyPicker.js?>
// <?import /JavaScript/FilterCreation/ContentTypes/ComputerContentType.js?>
// <?import /JavaScript/Properties/PropertiesComboBox.js?>
// <?import /JavaScript/yui-import/YahooGlobalObject.js?>


WR.Filters.ComputerPropertyPicker = function( div )
{
    WR.Filters.ComputerPropertyPicker.superclass.constructor.call( this, div, new WR.Filters.ComputerContentType() );
    
    this.propertiesComboBox = new WR.PropertiesComboBox( this.div, WR.Filters.ComputerProperties, WR.Filters.ComputerPropertyPicker.WIDTH );
        
    var me = this;
    this.propertiesComboBox.itemSelectEvent.subscribe( function( sType, sArgs ) {
        me.onPropertySelected.fire( me.propertiesComboBox.getCurrentData() );
    } );
    
    this.propertiesComboBox.unmatchedItemSelectEvent.subscribe( function( sType, sArgs ) {
        me.onPropertySelected.fire( me.propertiesComboBox.getCurrentData() );
    } );
};

WR.Filters.ComputerPropertyPicker.WIDTH = 380;

WR.Filters.ComputerPropertyPicker.prototype = {
    
    setSelected : function( propertyData )
    {
        this.propertiesComboBox.forceSetCurrentData( propertyData );
        
        this.onPropertySelected.fire( propertyData );
    }
    
};

YAHOO.lang.extend( WR.Filters.ComputerPropertyPicker, WR.Filters.PropertyPicker, WR.Filters.ComputerPropertyPicker.prototype );


