// <?import /JavaScript/FilterCreation/Selectors/Selector.js?>
// <?import /JavaScript/yui-import/YahooGlobalObject.js?>
// <?import /JavaScript/jQuery/jquery.js?>


WR.Filters.ListOfOperatorsSelector = function( parent, operatorsList )
{
    WR.Filters.ListOfOperatorsSelector.superclass.constructor.call( this, parent );
    
    this.operatorList = operatorsList;
    
    this.operatorSelector = this.operatorList.generateSelect();
    this.selectedOperator = this.operatorList.get( 0 );
    
    var me = this;
    this.operatorSelector.addListener( 'change', function( e ) {
        me.operatorSelected();
    } );
    
    this.operatorDiv.setStyle( 'display', 'inline' )
					.appendChild( this.operatorSelector.finish() );
    
    this.operatorSelected();
};

WR.Filters.ListOfOperatorsSelector.prototype = {
    
    applyState : function( state )
    {
        this.selectedOperator = this.operatorList.findOperatorByID( state.selectedOperatorName );
        $( this.operatorSelector.finish() ).val( this.selectedOperator.id );
        
        WR.Filters.ListOfOperatorsSelector.superclass.applyState.call( this, state );
    }
    
};

YAHOO.lang.extend( WR.Filters.ListOfOperatorsSelector, WR.Filters.Selector, WR.Filters.ListOfOperatorsSelector.prototype );