// SavedFilterSelector.js

// <?import /JavaScript/FilterCreation/Selectors/Selector.js?>
// <?import /JavaScript/yui-import/YahooGlobalObject.js?>
// <?import /JavaScript/FilterCreation/Operators/SavedFilterSelectFromListOperator.js?>
// <?import /JavaScript/FilterCreation/FilterCreation.js?>
// <?import /JavaScript/Util/HTML.js?>


WR.Filters.SavedFilterSelector = function( parent )
{
    WR.Filters.SavedFilterSelector.superclass.constructor.call( this, parent );
    this._initSelectedOperator();
        
    if ( !WR.Filters.SavedFiltersLoaded || !WR.Filters.HiddenSavedFiltersLoaded ) 
        this._showSpinner();
    
    var filterCallbacks = {
        success: function( o, me ) {
            if ( WR.Filters.HiddenSavedFiltersLoaded && WR.Filters.SavedFiltersLoaded )
                me._updateSelectedOperator();
        },
        failure: function( o, me ) {
            me._updateSelectedOperator();
            WR.Notify.error( WR.format( '<?jformat Failed to load saved filters: {errorMessage}?>', o.responseText ) );
        }
    };
    
    if ( !WR.Filters.SavedFiltersLoaded )
        WR.Filters.filterCreationManager.loadAllFilters( true, filterCallbacks , this );
    
    if ( !WR.Filters.HiddenSavedFiltersLoaded )
        WR.Filters.filterCreationManager.loadAllFilters( false, filterCallbacks , this );
};

WR.Filters.SavedFilterSelector.prototype = {
    
    _showSpinner : function() {
        this.valuePickerDiv.innerHTML( '<img width="20px" height="20px" src="/JavaScript/yui/build/assets/skins/sam/ajax-loader.gif"/>' );
    },
    
    _updateSelectedOperator : function() {
        this.valuePickerDiv.innerHTML( '' );
        this._initSelectedOperator();
    },
    
    _initSelectedOperator : function() {
        var savedFilters = [];
        for ( var i in WR.Filters.SavedFilterNames )
        {
            savedFilters[i] = { name: WR.HTML.escape( WR.Filters.SavedFilterNames[i].info.filterName ), id: WR.Filters.SavedFilterNames[i].info.filterID };
        }
        
        var hiddenSavedFilters = [];
        for ( var i in WR.Filters.HiddenSavedFilterNames )
        {
            hiddenSavedFilters[i] = { name: WR.HTML.escape( WR.Filters.HiddenSavedFilterNames[i].info.filterName ), id: WR.Filters.HiddenSavedFilterNames[i].info.filterID };
        }
        
        this.selectedOperator = new WR.Filters.SavedFilterSelectFromListOperator( savedFilters, hiddenSavedFilters );
        this.selectedOperator.generateValuePicker( this.valuePickerDiv );
        this.reapplyLatestState();
        
        var me = this;
        $( this.selectedOperator.valueField.finish() ).change(
            function()
            {
                var value = me.selectedOperator.getValue();
                WR.jsonRequest( 'hasdbfilter',
                    {
                        success: function( hasDBFilter )
                        {
                            if ( hasDBFilter )
                            {
                                WR.Notify.warning( WR.format( '<?jformat The filter "{filter_name}" contains a datasource filter.  Datasource filters in saved filter conditions will not be applied to your result.  In order to filter results based on datasource, you must add a datasource filter directly to this filter.?>',
                                                              savedFilters[me.selectedOperator.valueField.finish().selectedIndex].name ) );
                            }
                        },
                        failure: function() {} //If filter doesn't exist or there's a problem, we just want to ignore it because we might overwrite more useful error messages
                    },
                    { filterID: $( me.selectedOperator.valueField.finish() ).val() }
                );
            }
        );
    }
};

YAHOO.lang.extend( WR.Filters.SavedFilterSelector, WR.Filters.Selector, WR.Filters.SavedFilterSelector.prototype );
