// SelectorList.js

// <?import /JavaScript/FilterCreation/FilterCreation.js?>
// <?import /JavaScript/FilterCreation/FilterCreationManager.js?>
// <?import /JavaScript/Util/HTMLGenerator.js?>
// <?import /JavaScript/FilterCreation/FilterCreation.css?>
// <?import /JavaScript/jQuery/jquery.js?>

WR.Filters.SelectorList = function( div, selectorClass, optionalSelectorArgument )
{
    this.id = div.finish().id;
    this.el = div;
    this.el.setProperty( 'id', this.id );
    
    this.selectorClass = selectorClass;
    this.optionalSelectorArgument = optionalSelectorArgument;
    
    this.addSelectorLink = WR.HTMLGenerator.createJavaScriptLink( WR.Filters.AddSelectorString, this._addSelectorWithScope, this )
                                .addClass( 'AddSelectorLink' );
    
    this.selectors = [];
    
    this.addSelector();
    this.updateDisplay( true );
};

WR.Filters.SelectorList.prototype = {
    
    generateState : function()
    {
        var state = [];
        for ( i in this.selectors )
        {
            if ( this.selectors[i].hasValidState() )
                state.push( this.selectors[i].generateState() );
        }
        
        return state;
    },
    
    applyState : function( state )
    {
        
        while ( this.selectors.length < state.length )
        {
            this.addSelector();
        }
    
        for ( i in state )
        {
            this.selectors[i].applyState( state[i] );
        }
        
        this.updateDisplay();
    },
    
    addSelector : function()
    {
        var newSelector = new this.selectorClass( this.el, this.optionalSelectorArgument );
        this.selectors.push( newSelector );
    },
    
    _addSelectorWithScope : function( me )
    {
        me.addSelector();
        me.updateDisplay();
    },
    
    removeSelector : function( selector )
    {
        $( selector.el.finish() ).remove();
        var newSelectors = [];
        for ( var i in this.selectors )
        {
            if ( this.selectors[i].id != selector.id )
                newSelectors.push( this.selectors[i] );
        }
        this.selectors = newSelectors;
        WR.Filters.update();
        
        this.updateDisplay();
    },
    
    updateDisplay : function( dontNeedToRemoveItems )
    {
        if ( !dontNeedToRemoveItems )
        {
            $( '#' + this.id + ' .AddSelectorLink' ).remove();
            $( '#' + this.id + ' .BooleanLabel' ).remove();
            $( '#' + this.id + ' .RemoveSelectorButton' ).remove();
        }
        
        for ( var i in this.selectors )
        {
            if ( this.selectors.length > 1 )
                this.selectors[i].addRemoveButton( this );
            this.selectors[i].addBooleanLabel( WR.Filters.BooleanString );
        } 
        
        var latest = this.selectors[ this.selectors.length - 1];
        latest.el.appendChild( this.addSelectorLink.finish() );
    }
    
};