function EmptySelect(selectChosen) 
{
	if ( selectChosen ) 
	{
		selectChosen.options.length = 0;
	}
};

function Reset( completeList )
{
	if ( completeList )
	{
		for ( var key in completeList )
		{
			completeList[key] = 0;
		}
	}
};

function NameValueArrayCompare( a, b ) 
{
	if (a[1].toLowerCase() < b[1].toLowerCase()) 
	{
		return -1;
	} 
	else if (a[1].toLowerCase() > b[1].toLowerCase()) 
	{
		return 1;
	} 
	else 
	{
		return 0;
	}
};

function FillSelect( selectChosen, optionArray, defaultSelect, addNoneString ) 
{
	if ( addNoneString != "" )
	{
		var option = new Option( addNoneString, '' );
		selectChosen.options[0] = option;
	}
	for ( var i = 0; i < optionArray.length; i++) 
	{
		var option = new Option(optionArray[i][1], optionArray[i][0]);
		selectChosen.options[selectChosen.options.length] = option;
		if ( optionArray[i][1] == defaultSelect ) 
		{
			selectChosen.options[selectChosen.options.length - 1].selected = 1;
		}
	}
};

function ChangeSelect( chooseSelectId, modifySelectId, keyValueMap, completeList, addNoneString ) 
{
	chooseSelect = document.getElementById(chooseSelectId);
	modifySelect = document.getElementById(modifySelectId);
	var newSelect = new Array();
	var databaseChosen = 0;
	var showAll = 0;
	if ( modifySelect == null)
	{
		document.body.style.cursor = 'default';
		return;
	}
	
	EmptySelect( modifySelect );
	Reset( completeList );
	if ( chooseSelect == null ) 
	{
		showAll = 1;
	} 
	else 
	{		
		for ( var i = 0; i < chooseSelect.options.length; i++ ) 
		{
			if ( chooseSelect.options[i].selected ) 
			{
				var keyName = chooseSelect.options[i].value;
				var keyChosen = 1;
				if ( typeof keyValueMap[keyName] != "undefined" ) 
				{
					for ( var j = 0; j < keyValueMap[keyName].length; j++ ) 
					{
						if ( completeList[keyValueMap[keyName][j][0]] == 0 ) 
						{
							newSelect[newSelect.length] = keyValueMap[keyName][j];
							completeList[keyValueMap[keyName][j][0]] = 1;
						}
					}
				}
			}
		}
	}
	
	if ( showAll || !keyChosen )
	{
		for (var key in keyValueMap ) 
		{
			for ( var j = 0; j < keyValueMap[key].length; j++) 
			{
				if (completeList[keyValueMap[key][j][0]] == 0) 
				{
					newSelect[newSelect.length] = keyValueMap[key][j];
					completeList[keyValueMap[key][j][0]] = 1;
				}
			}
		}
	}
	
	newSelect.sort( NameValueArrayCompare );
	FillSelect( modifySelect, newSelect, '', addNoneString );
};

function PreselectByName( selectID, arrayName )
{
	var selectName = document.getElementById(selectID);
	for ( var i = 0; i < selectName.options.length; i++ )
	{
		if ( arrayName[selectName.options[i].value] == 1 ) 
		{
			selectName.options[i].selected = 1;
		}
	}
};

function MakeSelectedList( formSelectID, listID, defaultMessage ) 
{
	var formSelect = document.getElementById(formSelectID);
	var listObject = document.getElementById(listID);
	var str = '';
	for ( var i = 0; i < formSelect.length; i++) 
	{
		if (formSelect[i].selected) 
		{
			str += '<li>' +  formSelect[i].innerHTML + '</li>';
		}
	}
	if (str == '') 
	{
		str = defaultMessage;
	}
	listObject.innerHTML = str;
};