// <?import /JavaScript/Util/Set.js?>
// <?import /JavaScript/Util/PostRequest.js?>
// <?import /JavaScript/Notification/Notification.js?>
// <?import /JavaScript/DropDownPicker/DropDownPicker.js?>
// <?import /JavaScript/yui-import/Event.js?>
// <?import /JavaScript/Util/Array.js?>
// <?import /JavaScript/Util/URL.js?>
// <?import /JavaScript/Util/HTML.js?>
// <?import /JavaScript/Util/JSONRequest.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/DropDownSelect/DropDownSelect.js?>

// <?import /JavaScript/Labels/LabelPicker.css?>

WR.Labels = {};

WR.Labels.LabelPicker = function( id, dataTable, text ) {
    var me = this;
    
    this.isAdmin = text.isAdmin;
    this.isReadOnly = text.isReadOnly;
    
    this.picker = new WR.DropDownPicker( {
        id : id,
        buttonText : text.button,
        availableItemsText : text.availableItems,
        activeItemsText : text.activeItems,
        createNewText : text.createNew,
        isAdmin : text.isAdmin,
        isReadOnly : text.isReadOnly,
        addLabel : function( label ) { me.addLabel( label ); },
        removeLabel : function( label ) { me.removeLabel( label ); },
        getActiveLabels : function( label ) { return me.getActiveLabels( label ); }
    });
    
    this.picker.getLabelHTML = function( key ) {
        return WR.HTML.escape( me.options[key].name );
    };
    
    
    this.picker.formatLabelUI = function( key, container ) {
        var label = me.options[key];

        var deleteLabelSpan = WR.DOM.el( 'span' )
            .addClass( 'labelDelete' );
        
        var deleteLabelImg = WR.DOM.el( 'img' )
            .setProperty( 'src', '/images/besreports/' + WR.language + '/x.bmp' )
            .addListener( 'click', function() {
                var buttons = [ { text: '<?jformat Delete?>', isDefault: true, handler: function() {
                    var idType = label.domainLabel
                                ? 'domainID'
                                : 'labelID';
                                
                    var id = label.domainLabel
                            ? label.domainID
                            : label.localID;
                            
                    WR.postRequest( '/post/delete-label', {
                        success : function() {
                            me.dataTable.update();
                            me.update();
                            WR.Notify.update( text.labelDeleted + ": '" + label.name + "'" );
                        }
                    }, new WR.URL.ParamMap().add( idType, id ) );
                    me.picker.disable();
                    me.confirmDelete.hide();
                    } }, { text: '<?jformat Cancel?>', handler: function() {
                        me.confirmDelete.hide();
                    } } ];
                me.confirmDelete.cfg.queueProperty( "buttons", buttons );
                me.confirmDelete.render();
                me.confirmDelete.show();
            } );
            
        if ( !this.isAdmin )
            deleteLabelImg.addClass( 'hidden' );
        deleteLabelSpan.appendChild( deleteLabelImg.finish() );             
         
        var isCurrentLabel = YAHOO.util.Dom.get( 'visibility_options_' + label.localID + '_false' ) != null;
        
        WR.DOM.el( container )
            .appendChild( WR.DOM.el( 'span' )
                .appendChild( deleteLabelSpan.finish() )
            .finish() )
        .finish();
    };
    
    this.picker.entryMatches = function( key, regex ) {
        return me.options[key].name.search( regex ) != -1;
    };
    
    this.labelsChanged = new YAHOO.util.CustomEvent( 'labelsChanged', this );
    
    this.confirmDelete = new YAHOO.widget.SimpleDialog( 'wr_confirmDelete',
    {
        width: '300px',
        fixedcenter: true,
        visible: false,
        draggable: false,
        close: true,
        text: '<?jformat Are you sure you want to delete this label??>'
    } );
    this.confirmDelete.setHeader( '<?jformat Delete Label?>' );
    this.confirmDelete.render( 'wr_confirmDeleteContainer' );
    
    
    this.dataTable = dataTable;
    this.options = {};
    this.setLabels( text.labels );
};

WR.Labels.LabelPicker.prototype = {

    _findLabel : function( name ) {
        for ( var i in this.options )
            if ( this.options[i].localID && this.options[i].name == name )
                return this.options[i];
                
        return null;
    },

    addLabel : function( key ) {
        var me = this;
        var params = new WR.URL.ParamMap();
        var label = this.options[key];
        
        if ( label == null )
            label = this._findLabel( key );
        
        if ( label == null )
            params.add( 'label', key );
        else if ( label.localID )
            params.add( 'labelID', label.localID );
        else
            params
                .add( 'label', label.name )
                .add( 'domainID', label.domainID );
        
        for ( var i in this.dataTable.checkedRows )
        {
            var id     = this.dataTable.checkedRows[i].getData( 'id' );
            var siteid = this.dataTable.checkedRows[i].getData( 'siteid' );
            params.add( 'ReportID', id );
            params.add( 'ReportSiteID', siteid ? siteid : 'null' );
        }
        
        var updated = false;
        WR.postRequest( WR.URL( '/post/add-label' ), {
            success : function( o ) {
                me.dataTable.update();
                if ( !updated )
                {
                    updated = true;
                    me.update();
                }
            },
            failure : function( o ) {
                WR.Notify.error( o.responseText );
            }
        },
        params );
    },
    
    removeLabel : function( key ) {
        var me = this;
        var params = new WR.URL.ParamMap();
        
        var label = this.options[key];
        
        if ( !label )
            label = this._findLabel( key.substring( 0, key.lastIndexOf( ' ' ) ) );
        
        if ( label == null )
            return;
        
        if( label.domainID )
            params.add( 'domainID', label.domainID );
        
        if( label.localID )
            params.add( 'labelID', label.localID );

        for ( var i in this.dataTable.checkedRows ) {
            var id     = this.dataTable.checkedRows[i].getData( 'id' );
            var siteid = this.dataTable.checkedRows[i].getData( 'siteid' );
            params.add( 'ReportID', id );
            params.add( 'ReportSiteID', siteid ? siteid : 'null' );
        }
            
        var updated = false;
        WR.postRequest( WR.URL( '/post/remove-label' ), {
            success : function( o ) {
                me.dataTable.update();
                if ( !updated )
                {
                    updated = true;
                    me.update();
                }
            },
            failure : function( o ) {
                WR.Notify.error( o.responseText );
            }
        },
        params );
    },
    
    _getLabelKey : function( label ) {
        return label.name + ' ' + ( label.localID ? label.localID : label.domainID );
    },
    
    _existsLabel : function( labels, label ) {
        if ( !label.public )
            return false;
        
        for ( var i=0; i<labels.length; i++ )
            if ( labels[i].public && label.name == labels[i].name )
                return true;
            
        return false;
    },
    
    _reduceLabels : function( labels ) {
        var localLabels = [];
        var domainLabels = [];
        
        for ( var i=0; i<labels.length; i++ )
        {
            if ( labels[i].localID )
                localLabels.push( labels[i] );
            else
                domainLabels.push( labels[i] );
        }
        
        for ( var i=0; i<domainLabels.length; i++ )
            if ( !this._existsLabel( localLabels, domainLabels[i] ) )
                localLabels.push( domainLabels[i] );
                
        return localLabels;
    },
    
    getActiveLabels : function() {
        var labelSet = new WR.Set();
        
        for( var i in this.dataTable.checkedRows )
        {
            var labels = this.dataTable.checkedRows[i].getData( 'labels' );
            
            for ( var j in labels )
                labelSet.insert( this._getLabelKey( labels[j] ) );
        }
        
        return labelSet;
    },
    
    setLabels : function( labels ) {
        var reducedLabels = this._reduceLabels( labels );
        var labelArray = new Array( labels.length );
        this.options = {};
        
        for ( var i=0; i<reducedLabels.length; i++ )
        {
            var key = this._getLabelKey( reducedLabels[i] );
            labelArray[i] = key;
            this.options[key] = reducedLabels[i];
        }
        
        labelArray.sort( WR.Array.caseInsensitiveCompare );
        this.picker.setLabels( labelArray );
    },
    
    update : function() {
        var me = this;
        
        WR.jsonRequest( 'labels-full', {
            success : function( o ) {
                var labels = o;
                me.setLabels( labels );
                me.labelsChanged.fire( labels );
            }
        } );
    },
    
    disable : function() {
        this.picker.disable();
    },
    
    enable : function() {
        this.picker.enable();
    }

};
