// <?import /JavaScript/WR.js?>
// <?import /JavaScript/Util/HTML.js?>
// <?import /JavaScript/Util/DOM.js?>

// <?import /JavaScript/yui-import/Dom.js?>

WR.Notify = {
	
	_enabled : true,
	
	update : function( msg ) {
		WR.Notify.updateHTML( WR.HTML.escape( msg ) );
	},
	
	updateHTML : function( html ) {
		WR.Notify._add( "wr_successbox", html );
	},
	
	warning : function( msg ) {
		WR.Notify.warningHTML( WR.HTML.escape( msg ) );
	},
	
	warningHTML : function( html ) {
		WR.Notify._add( "wr_warningbox", html );

	},
	
	error : function( msg ) {
		WR.Notify.errorHTML( WR.HTML.escape( msg ) );
	},
	
	errorHTML : function( html ) {
		WR.Notify._add( "wr_errorbox", html );

	},
	
	clear : function() {
		WR.Notify._getContainer()
			.innerHTML( "" );
	},
	
	disableNotifications : function() {
		WR.Notify._enabled = false;
	},
	
	enableNotifications : function() {
		WR.Notify._enabled = true;
	},
	
	_add : function( style, html ) {
		if ( !WR.Notify._enabled )
			return;
		
		WR.Notify.clear();
		
		WR.Notify._getContainer()
			.appendChild(
				WR.DOM.el( "div" )
					.addClass( style )
					.innerHTML( html )
				.finish()
			);
	},
	
	_getContainer : function() {
		return WR.DOM.el( YAHOO.util.Dom.get( "wr_notifications" ) );
	}

};
