// <?import /JavaScript/yui-import/DataSource.js?>
// <?import /JavaScript/yui-import/YahooGlobalObject.js?>
// <?import /JavaScript/WR.js?>

WR.PropertiesDataSource = function( propertyArray ) {
	if ( propertyArray != null )
		this._computeDisplayNames( propertyArray );
	WR.PropertiesDataSource.superclass.constructor.call( this, propertyArray );
	
	// displayName is generated when we load the data.  This is instead of using getDisplayValue to generate the display name, which
	// doesn't work well with filtering. See bug 35816
	this.responseSchema = { fields: [ "displayName", "name", "id", "type", "analysis" ] };
};

WR.PropertiesDataSource.computeDisplayName = function( oResultData ) {
	if ( oResultData.analysis != null && oResultData.analysis.name != null )
		return WR.format( '<?jformat {propertyName} ({analysisName})?>', oResultData.name, oResultData.analysis.name );
	else
		return oResultData.name;
}

WR.PropertiesDataSource.prototype = {
	
	_computeDisplayNames : function( results )
	{
		for ( var i = 0; i < results.length; i++ )
			results[i].displayName = WR.PropertiesDataSource.computeDisplayName( results[i] );
	}
	
};

YAHOO.lang.extend( WR.PropertiesDataSource, YAHOO.util.LocalDataSource, WR.PropertiesDataSource.prototype );
