// Array.js

// <?import /JavaScript/WR.js?>

WR.Array = {};

WR.Array.equals = function( o1, o2 ) {
    if ( typeof o1 != typeof o2 )
        return false;
    else if ( typeof o1 == 'object' )
    {
        if ( o1.length != o2.length )
            return false;
        
        for ( var i in o1 )
            if ( !WR.Array.equals( o1[i], o2[i] ) )
                return false;
        
        for ( var i in o2 )
            if ( !WR.Array.equals( o1[i], o2[i] ) )
                return false;
            
        return true;
    }
    else
        return o1 == o2;
};

WR.Array.equalsIgnoreOrder = function( o1, o2 ) {
    if ( typeof o1 != typeof o2 )
        return false;
    
    if ( o1.length != o2.length )
        return false;
    
    for ( var i = 0; i < o1.length; i++ )
    {
        if ( WR.Array.indexOf( o2, o1[i] ) < 0 )
            return false;
    }
    
    return true;
};

WR.Array.removeAll = function( array, key ) {
    var ret = [];
    for( var i in array )
    {
        if( !WR.Array.equals( array[i], key ) )
            ret.push( array[i] );
    }
    
    return ret;
};

WR.Array.caseInsensitiveCompare = function( a, b ) {
    var aLower = a.toLowerCase();
    var bLower = b.toLowerCase();
    
    if( aLower < bLower )
        return -1;
    else if( aLower > bLower )
        return 1;
    
    return 0;
};

WR.Array.indexOf = function( array, element )
{
    for( i = 0; i < array.length; i++ )
    {
        if ( array[i] == element )
            return i;
    }
    return -1;
};

WR.Array.insertElementIntoSortedArray = function( array, element, compareFn )
{
    var index = WR.Array.binarySearchForInsertionPoint( array, element, compareFn );
    array.splice( index, 0, element );
};

WR.Array.binarySearchForExisting = function( array, element, compareFn )
{
    var result = WR.Array.binarySearch( array, element, compareFn );
    if ( result.found )
        return result.index;
    else
        return -1;
};

WR.Array.binarySearchForInsertionPoint = function( array, element, compareFn )
{
    return WR.Array.binarySearch( array, element, compareFn ).index;
};

WR.Array.binarySearch = function( array, element, compareFn )
{
    var min = 0;
    var max = array.length - 1;
    while ( min <= max )
    {
        var mid = Math.floor( min + ( max - min ) / 2 );
        var compareResult = compareFn( element, array[mid] );
        if ( compareResult > 0 )
            min = mid + 1;
        else if ( compareResult < 0 )
            max = mid - 1;
        else
            return { index: mid, found: true };
    }
    return { index: min, found: false };
};

