// DOM.js

// <?import /JavaScript/WR.js?>

// <?import /JavaScript/yui-import/Dom.js?>
// <?import /JavaScript/yui-import/Event.js?>

WR.DOM = {};

WR.DOM.el = function( tagOrEl ) {
    return new WR.DOM.Element( tagOrEl );
};

WR.DOM.get = function( tag ) {
    return new WR.DOM.Element( YAHOO.util.Dom.get( tag ) );
};

WR.DOM.Element = function( tagOrEl ) {
    if( typeof tagOrEl == 'string' )
        this.el = document.createElement( tagOrEl );
    else
        this.el = tagOrEl;
};

WR.DOM.Element.prototype = {
    
    addClass : function( className ) {
        YAHOO.util.Dom.addClass( this.el, className );
        
        return this;
    },
    
    removeClass : function( className ) {
        YAHOO.util.Dom.removeClass( this.el, className );
        
        return this;
    },
    
    setID : function ( id ) {
        this.el.id = id;
        
        return this;
    },
    
    setProperty : function( name, value ) {
        this.el[ name ] = value;
        
        return this;
    },
    
    setStyle : function( name, value ) {
        YAHOO.util.Dom.setStyle( this.el, name, value );
        
        return this;
    },
    
    setAttribute : function( name, value ) {
        this.el.setAttribute( name, value );
        
        return this;
    },
    
    appendTo : function( parent ) {
        if( typeof parent == 'string' )
            YAHOO.util.Dom.get( parent ).appendChild( this.el );
            
        return this;
    },
    
    appendChild : function( child ) {
        this.el.appendChild( child );
        
        return this;
    },
    
    addListener : function( sType, fn, obj, overrideContext ) {
        YAHOO.util.Event.addListener( this.el, sType, fn, obj, overrideContext );
        
        return this;
    },
    
    innerHTML : function( html ) {
        this.el.innerHTML = html;
        
        return this;
    },
    
    innerText : function( text ) {
        this.el.innerHTML = WR.HTML.escape( text );
        
        return this;
    },
    
    finish : function() {
        return this.el;
    }
    
};

WR.DOM.postUserRequest = function( pageId, userId ) {
    var params = [ { name: "page", value: pageId }, { name: "user", value: userId } ];
    WR.DOM.PostParameters( '/webreports', params );
}

WR.DOM.PostParameters = function( url, parameterArray ) {
    var postForm = new WR.DOM.Element( 'form' )
            .setProperty( 'action', url )
            .setProperty( 'method', 'POST' )
            .finish();
        
    for( var i in parameterArray )
        postForm.appendChild(
            new WR.DOM.Element( 'input' )
                .setProperty( 'type', 'hidden' )
                .setProperty( 'name', parameterArray[ i ].name )
                .setProperty( 'value', parameterArray[ i ].value )
                .finish()
        );
        
    document.body.appendChild( postForm );
        
    postForm.submit();
};
