// <?import /JavaScript/WR.js?>

WR.HTML = {};

WR.HTML.escape = function( s )
{
    if ( typeof s === "undefined" )
        return s;

    s = new String( s );
    
    var ret = new Array( s.length );
    for ( var i=0; i<s.length; i++ )
    {
        if ( s.charAt( i ) == '"' )
            ret[i] = '&quot;';
        else if ( s.charAt( i ) == '<' )
            ret[i] = '&lt;';
        else if ( s.charAt( i ) == '>' )
            ret[i] = '&gt;';
        else if ( s.charAt( i ) == '&' )
            ret[i] = '&amp;';
        else
            ret[i] =s.charAt( i );
    }
    
    return ret.join( '' );
};

WR.HTML.unescape = function( s )
{
    if ( typeof s === "undefined" )
        return s;

    s = new String( s );
    
    var ret = '';
    for ( var i=0; i<s.length; i++ )
    {
        if ( s.charAt( i )== '&' )
        {
            var semicolonIndex = s.indexOf( ';', i );
            var escaped = s.substring( i, semicolonIndex + 1 );
            if ( escaped == '&quot;' )
                ret += '"';
            else if ( escaped == '&lt;' )
                ret += '<';
            else if ( escaped == '&gt;' )
                ret += '>';
            else if ( escaped == '&amp;' )
                ret += '&';
            else
                ret += escaped;
                
            i += semicolonIndex - i;
        }
        else
            ret += s.charAt( i );
    }
    
    return ret;
};
