
WR.HTMLGenerator = {};

WR.HTMLGenerator.createSelect = function( defaultEntry, entries, defaultValue, values )
{
    var escapedDefault = WR.HTML.escape( defaultEntry );
    var escaped = new Array( entries.length );
    for ( i in entries )
    {
        escaped[i] = WR.HTML.escape( entries[i] );
    }
    
    return WR.HTMLGenerator.createSelectFromEscapedEntries( escapedDefault, escaped, defaultValue, values );
};

WR.HTMLGenerator.createSelectFromEscapedEntries = function( defaultEntry, entries, defaultValue, values )
{
    var selectEl = new WR.DOM.Element( 'select' );
    
    if ( values == null )
        values = entries;
    if ( defaultValue == null )
        defaultValue = defaultEntry;
    
    if ( defaultEntry != '' )
    {
    selectEl.appendChild( new WR.DOM.Element( 'option' )
        .setProperty( 'value', defaultValue )
        .innerHTML( defaultEntry )
        .finish() );
    }
    for ( i in entries )
    {
        selectEl.appendChild( new WR.DOM.Element( 'option' )
            .setProperty( 'value', values[i] )
            .innerHTML( entries[i] )
            .finish() );
    }

    return selectEl;
};

WR.HTMLGenerator.createJavaScriptLink = function( label, callback, scope )
{
    return WR.DOM.el( 'a' ).innerHTML( WR.HTML.escape( label ) )
            .setProperty( 'href', 'javascript:void(0)' )
            .addListener( 'click', function( e ) { callback( scope ); }  );
};

WR.HTMLGenerator.createImageButton = function( imagePath, callback, scope )
{
    return new WR.DOM.Element( 'input' )
            .setProperty( 'type', 'image' )
            .setProperty( 'src', imagePath )
            .addListener( 'click', function(e) { callback( scope ); } );
};

WR.HTMLGenerator.createButton = function( label, callback, scope )
{
    return WR.DOM.el( 'input' )
            .setProperty( 'value', WR.HTML.escape( label ) )
            .setProperty( 'type', 'button' )
            .addListener( 'click', function( e ) { callback( scope ); }  );
}

//IE7 has a bug that if you first create an input el, and then set type=radio, that radio button will be unselectable, so we have to create radio buttons like this.  See bug 32853.
WR.HTMLGenerator.createRadioButton = function( groupName )
{
    return WR.DOM.el( WR.DOM.el( 'div' ).innerHTML( '<input type="radio" name="' + groupName + '"/>' ).finish().firstChild );
}