// <?import /JavaScript/json2.js?>
// <?import /JavaScript/Util/GetRequest.js?>
// <?import /JavaScript/Util/Format.js?>

var matched, browser;

$.uaMatch = function( ua ) {
    ua = ua.toLowerCase();

    var match = /(chrome)[ \/]([\w.]+)/.exec( ua ) ||
        /(webkit)[ \/]([\w.]+)/.exec( ua ) ||
        /(opera)(?:.*version|)[ \/]([\w.]+)/.exec( ua ) ||
        /(msie) ([\w.]+)/.exec( ua ) ||
        ua.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec( ua ) ||
        [];

    return {
        browser: match[ 1 ] || "",
        version: match[ 2 ] || "0"
    };
};

matched = $.uaMatch( navigator.userAgent );
browser = {};

if ( matched.browser ) {
    browser[ matched.browser ] = true;
    browser.version = matched.version;
}

// Chrome is Webkit, but Webkit is also Safari.
if ( browser.chrome ) {
    browser.webkit = true;
} else if ( browser.webkit ) {
    browser.safari = true;
}

$.browser = browser;

WR.jsonRequest = function ( url, callbacks, params /* optional */, scope /* optional */ )
{
    function isTooLongToParse( text )
    {
        return $.browser.msie && $.browser.version == '7.0' && text.length > 200000;
    }
    
    function failToParse( o, scope, message )
    {
        if ( callbacks.failure != null )    
            callbacks.failure( o, scope, message );
        else
        {
            var errorMessage;
            
            if ( message != null )
                errorMessage = message;
            else if ( o.responseText != null )
                errorMessage = o.responseText;
            else
                errorMessage = '<?jformat Unknown Error?>';
                
            WR.Notify.error( WR.format( '<?jformat Unable to parse JSON response for {url} request: {error}?>', url, errorMessage )  );
        }
    }
    
    var newCallbacks = {
        success : function( o, scope )
        {
            if ( isTooLongToParse( o.responseText ) )
            {
                if ( callbacks.failureTooLong != null )
                    callbacks.failureTooLong( o, scope );
                else
                    failToParse( o, scope, '<?jformat Result set is too large to be parsed by Internet Explorer 7.  Please upgrade your browser to view this report.?>'   );
            }
            else
            {
                try
                {
                    var parsedResponse = JSON.parse( o.responseText );
                }
                catch (e)
                {
                    failToParse( o, scope );
                    return;
                }
                callbacks.success( JSON.parse( o.responseText ), scope );
            }
        },
        
        failure : callbacks.failure,
        start: callbacks.start
    }
    
    WR.getRequest( '/json/' + url, newCallbacks, params, scope );
}
