// <?import /JavaScript/Notification/Notification.js?>
// <?import /JavaScript/json2.js?>
// <?import /JavaScript/Util/HTML.js?>
// <?import /JavaScript/WR.js?>
// <?import /JavaScript/jQuery/jquery.js?>

WR.run = function( functionToRun )
{
    try
    {
        return functionToRun();
    }
    catch ( e )
    {
        var message = '[JavaScript Error] ';
        if ( e.message != null )
        {
            if ( e.fileName != null )
                message += 'File: ' + e.fileName + '; ';
            if ( e.lineNumber != null )
                message += 'Line Number: ' + e.lineNumber + '; ';
            if ( e.name != null )
                message += 'Type: ' + e.name + '; ';
            message += 'Message: ' + e.message;
        }
        else
            message += JSON.stringify( e );
            
        if ( e.stack != null )
        {
            var prettyStack = '';
            for ( var i = 0; i < e.stack.length; i++ )
            {
                if ( e.stack[i] != '\n' )
                    prettyStack += WR.HTML.escape( e.stack[i] );
                else
                    prettyStack += '<br/>';
            }
            
            var messageWithLink = message + '; <a id="wr_stackTraceLink" href="javascript:void(0)"><?jformat View Stack Trace?></a>';
            WR.Notify.errorHTML( messageWithLink );
            $( '#wr_stackTraceLink' ).unbind().bind( 'click', 
                function()
                {
                    WR.Notify.errorHTML( WR.HTML.escape( message ) + '<br/><br/>Stack:<br/>' + prettyStack );
                }
            );
        }
        else
        {
            WR.Notify.error( message );
        }
        
        throw e;
    }
}