// <?import /JavaScript/WR.js?>
// <?import /JavaScript/Util/PostRequest.js?>
// <?import /JavaScript/Util/URL.js?>
// <?import /JavaScript/Util/JSONRequest.js?>
// <?import /JavaScript/json2.js?>
// <?import /JavaScript/PHP_JS/sha1.js?>

WR.TextShortener = {};

WR.TextShortener.ShortenText = function( fullText, callbacks )
{
    var shortenedText = sha1( fullText );
    
    var newCallbacks = {
        success: function( o )
        {
            if ( callbacks == null )
                return;
            
            var result = o.responseText;
            if ( o.status == 200 )
            {
                if ( shortenedText == result )
                    callbacks.success( result );
                else
                    callbacks.failure( 'Server returned different shortened text than was calculated locally' );
            }
            else
                callbacks.failure( o.statusText );
        },
        
        failure: function( o )
        {
            if( callbacks == null )
                return;
            callbacks.failure( o.statusText );
        }
    };
        
    //Post URL to shorten
    WR.postRequest( WR.URL( '/post/shortentext' ), newCallbacks, new WR.URL.ParamMap().addAll( { fullText: fullText } ) );
    
    //Immediately return shortened text we calculated locally
    return shortenedText;
};

WR.TextShortener.UnshortenText = function( shortText, callbacks )
{
    var newCallbacks = {
        success: function( o )
        {
            if ( callbacks == null )
                return;
            
            var result = o;
            if ( result.hasOwnProperty( 'fullText' ) )
                callbacks.success( result.fullText );
            else if ( result.hasOwnProperty( 'error' ) )
                callbacks.failure( result.error );
            else
                callbacks.failure( 'Incomplete response from server.' );
        },
        failure: function( o )
        {
            if ( callbacks == null )
                return;
            
            callbacks.failure( o.responseText );
        }
    }
    
    WR.jsonRequest( 'unshortentext', newCallbacks, { shortText: shortText } );
    
};