// URL.js

// <?import /JavaScript/WR.js?>
// <?import /JavaScript/Util/Array.js?>


WR.URL = function( url, parameterMap )
{
    var params = WR.URL.paramsToString( parameterMap );
    if ( params.length == 0 )
        return url;
        
    var combined = WR.URL.combineParams( WR.URL.getQuery( url ), params );
    return WR.URL.setQuery( url, combined );
};

WR.URL.combineParams = function( a, b )
{
    if ( a.length == 0 )
        return b;
    
    if ( b.length == 0 )
        return a;
    
    return a + '&' + b;
}

WR.URL.paramsToString = function( parameterMap )
{
    var params = new Array();
    for ( var key in parameterMap )
    {
        if ( parameterMap[key] != undefined )
        {
            var paramArray = ( typeof parameterMap[key] == 'object'
                ? parameterMap[key]
                : [ parameterMap[key] ] );
            
            for ( var i=0; i<paramArray.length; i++ )
                params.push( encodeURIComponent( key ) + '=' + encodeURIComponent( paramArray[i] ) );
        }
    }
    
    return params.join( '&' );
};

WR.URL.decode = function( s )
{
    return decodeURIComponent( s ).replace( /\+/g, ' ' );
}

WR.URL.ParseParams = function( params )
{
    if ( !params )
        return {};
    
    var map = {};
    
    var paramArray = params.toString().split( '&' );
    for ( var i=0; i<paramArray.length; i++ )
    {
        var keyValue = paramArray[i].split( '=' );
        var key = WR.URL.decode( keyValue[0] );
        
        if( key )
        {
            if( !map[ key ] )
                map[ key ] = [];
                
            map[ key ].push( WR.URL.decode( keyValue[1] ) );
        }
    }
    
    return map;
};

WR.URL.ParamMap = function( parameters /* optional */ ) {
    this.params = {};
    this.addAll( parameters );
};

WR.URL.ParamMap.prototype = {
    
    add : function( name, value ) {
        if ( this.params[name] )
            this.params[name].push( value );
        else
            this.params[name] = [ value ];
        
        return this;
    },
    
    set : function( name, value ) {
        this.remove( name );
        
        if ( typeof value == "object" )
            this.params[name] = value;
        else
            this.add( name, value );
    },
    
    remove : function( name ) {
        delete this.params[name];
    },
    
    addAll : function( o ) {
        for ( var i in o )
            this.set( i, o[i] );
            
        return this;
    },
    
    empty : function() {
        for ( var i in this.params )
            return false;
        return true;
    },
    
    finish: function() {
        return WR.URL.paramsToString( this.params );
    },
    
    equals: function( other ) {
        if ( other.params == null  )
            return false;
        
        for ( var i in this.params )
        {
			// order matters in 'dir' and 'sort'. At least that means we don't have to do it twice
			if ( ( i == 'dir' || i== 'sort' ) && !WR.Array.equals( other.params[i], this.params[i] ) )
				return false;
            else if ( !WR.Array.equalsIgnoreOrder( other.params[i], this.params[i] ) )
                return false;
        }
        
        for ( var i in other.params )
        {
            if ( !WR.Array.equalsIgnoreOrder( other.params[i], this.params[i] ) )
                return false;
        }
        
        return true;
    }
};

WR.URL.getHash = function ( url )
{
    var i = url.indexOf( "#" );
    return i >= 0 ? url.substr( i + 1 ) : '';
};

WR.URL.getQuery = function( url )
{
    var begin = url.indexOf( '?' );
    if ( begin < 0 )
        return '';
    
    var end = url.indexOf( '#' );
    if ( end < 0 )
        end = url.length;
        
    if ( end < begin )
        return '';
    
    return url.substr( begin + 1, end - begin - 1 );
}

WR.URL.removeQuery = function( url )
{
    var query = url.indexOf( '?' );
    if ( query < 0 )
        return url;
    
    var hash = url.indexOf( '#' );
    if ( hash < 0 )
        hash = url.length;
    
    if ( hash < query )
        return url;
    
    return url.substr( 0, query ) + url.substr( hash );
}

WR.URL.setQuery = function( url, newQuery )
{
    url = WR.URL.removeQuery( url );
    
    if ( newQuery.length == 0 )
        return url;
    
    var hash = url.indexOf( '#' );
    if ( hash < 0 )
        return url + '?' + newQuery;
    
    return url.substr( 0, hash ) + '?' + newQuery + url.substr( hash );
}
