'
' Run compliance test and dump results to the Windows registry.
'
' Copyright (c) 2004, BigFix.


'

' Call this script at least once as "ComplienceInit" then subsequently as "CompliancePreaudit"
' or "CompliancePass"
'
' gWhoAmI must be one of:
' 	ComplienceInit
' 	CompliancePreaudit
' 	CompliancePass

CONST gWhoAmI           = "CompliancePreaudit"
CONST gDEBUG            = 0


SET gAPISessionObj  = WScript.CreateObject( "BESClientComplianceMod.Session" )
SET gAPIProgressObj = WScript.CreateObject( "BESClientComplianceMod.Progress" )
SET gAPIResponseObj = WScript.CreateObject( "BESClientComplianceMod.Response" )


' See ClientCompliance.h for numeric constants
'
CONST COMPLIANCE_PROGRESS_COMPLETE         = 1
CONST COMPLIANCE_PROGRESS_ERROR            = 2
CONST COMPLIANCE_PROGRESS_BUSY             = 3

CONST COMPLIANCE_FLAG_GATHER               = 1  
CONST COMPLIANCE_FLAG_EVALUATE_ALL         = 2
CONST COMPLIANCE_FLAG_IDLE_CPU_USAGE       = 4

CONST COMPLIANCE_ERROR_CHANGING_CONDITIONS = -22


' HKEY_LOCAL_MACHINE
'
CONST HKLM   = &H80000002 

	
ON ERROR RESUME NEXT
Err.Clear


' locations of compliance parameters and compliance test results in the registry.
'
gBeginTestTime          = Now
gComplianceRegKey       = "HKLM\SOFTWARE\BigFix\ClientComplianceAPI\"
gComplianceResultRegKey = "HKLM\SOFTWARE\BigFix\ClientComplianceResult\"

SET WSHShell           = CreateObject( "WScript.Shell" )
gURL                   = WSHShell.RegRead( gComplianceRegKey & "SiteURL" )
gCDoc                  = WSHShell.RegRead( gComplianceRegKey & "ComplianceDocName" )
gFullEval              = WSHShell.RegRead( gComplianceResultRegKey & "EvalControl" )
gCurrAPIProgress       = COMPLIANCE_PROGRESS_COMPLETE


IF ( gURL = "" ) OR ( gCDoc = "" ) THEN
    IF ( gDEBUG = 1 ) THEN
	WScript.echo "Bad API parameters!"
    END IF
    WriteErrorErrorToReg gBeginTestTime, "-999: Bad API parameters"
    WScript.quit
END IF

IF ( gFullEval = "" ) THEN
    gFullEval = 1
END IF


SELECT CASE gWhoAmI

    CASE "ComplienceInit"
	' init the client evaluation script. perform a full gather and evaluation on
 	' the next "CompliancePreaudit" call
	'
	gFullEval = 1
	WSHShell.RegWrite gComplianceResultRegKey & "EvalControl", gFullEval, "REG_SZ"

	' cleanup the previous result set pending the results evaluation
	'
    	ResultCleanup

	' update the stats for the compliance test
    	'
	WriteStatsToReg ( gBeginTestTime )
	
    CASE "CompliancePreaudit"
	' perform a full gather and evaluation if indicated by gFullEval, but do not
	' block waiting for the result. delete the previous results, pending a subsequent
	' compliance evaluation
	'
	' if we are not doing a full gather and evaluation, then block until the
	' compliance tests have been run. leave compliance results in the registry
	'
	gFullEval = DoComplianceEvaluation ( gFullEval )
	WSHShell.RegWrite gComplianceResultRegKey & "EvalControl", gFullEval, "REG_SZ"

    CASE "CompliancePass"
	' test compliance without gathering and re-evaluation, but setup a full test
	' on the next "CompliancePreaudit". 
	'
	' save compliance results to the registry
	'
	gFullEval = DoComplianceEvaluation ( 0 )
        gFullEval = 1
	WSHShell.RegWrite gComplianceResultRegKey & "EvalControl", gFullEval, "REG_SZ"

    CASE ELSE
	' should never get here...
	'
	WriteErrorErrorToReg gBeginTestTime, "-999: Unexpected API state"
	WScript.quit

END SELECT

WScript.quit



' --------------------------------------------------------------------------------------
FUNCTION DoComplianceEvaluation ( ByRef doFullEval )

    DIM apiFlags
    DIM tmpAPISession
    DIM tmpAPIProgress
    DIM apiError

    IF ( doFullEval = 1 ) THEN
	apiFlags = COMPLIANCE_FLAG_GATHER + COMPLIANCE_FLAG_EVALUATE_ALL
    ELSE
	apiFlags = COMPLIANCE_FLAG_IDLE_CPU_USAGE
    END IF


    tmpAPISession = gAPISessionObj.Open( gURL, gCDoc, apiFlags )
    IF tmpAPISession <> 0 THEN
	IF gDEBUG = 1 THEN
	    WScript.echo "gAPISessionObj.Open failed"
	END IF
	WriteError gBeginTestTime, "-999: gAPISessionObj.Open failed: " + FormatNumber(t)
	gAPISessionObj.Close
	WScript.quit
    END IF


    IF ( doFullEval = 0 ) THEN

	' if we are not doing a full eval with gather, so the compliance test will be fast
	' block until not busy and save the results
	'
	DO
	    WScript.Sleep( 100 )
	    tmpAPIProgress = gAPIProgressObj.SessionProgress
	LOOP WHILE tmpAPIProgress = COMPLIANCE_PROGRESS_BUSY


	' the API is not longer busy, so cleanup the previous result set pending
	' the results evaluation
	'
    	ResultCleanup
	

	' the API is no longer busy, test for errors
	'
	IF tmpAPIProgress = COMPLIANCE_PROGRESS_ERROR THEN
	    apiError = gAPIProgressObj.GetError
	    IF apiError = COMPLIANCE_ERROR_CHANGING_CONDITIONS THEN
		IF gDEBUG = 1 THEN
		    WScript.echo "COMPLIANCE_ERROR_CHANGING_CONDITIONS"
	    	END IF
		WriteErrorToReg gBeginTestTime, FormatNumber( apiError )+ ": COMPLIANCE_ERROR_CHANGING_CONDITIONS"
	    ELSE
		IF gDEBUG = 1 THEN
		    WScript.echo "COMPLIANCE_PROGRESS_ERROR"
	    	END IF
		WriteErrorToReg gBeginTestTime, FormatNumber( apiError )+ ": COMPLIANCE_PROGRESS_ERROR"
	    END IF
	ELSE
	    ' no errors found, so write results
	    '
	    WriteAllResultsToReg ( gAPIResponseObj )
	END IF

    ELSE
	' we are doing a full evaluation, so don't wait around, but cleanup previous results
	'
	ResultCleanup
	doFullEval = 0
    END IF


    ' cleanup the API
    '
    gAPISessionObj.Close


    ' update the stats for the compliance test
    '
    WriteStatsToReg ( gBeginTestTime )


    ' return the new value of doFullEval
    '
    doFullEval

END FUNCTION	'DoComplianceEvaluation


' --------------------------------------------------------------------------------------
' Write compliance stats to registry
'
SUB WriteStatsToReg ( startTime )

	thenTime  = Now
	totalTime = DateDiff( "s", startTime, thenTime )

	WSHShell.RegWrite gComplianceResultRegKey & "\Error",        "0",       "REG_SZ"
	WSHShell.RegWrite gComplianceResultRegKey & "\LastStarted",  startTime, "REG_SZ"
	WSHShell.RegWrite gComplianceResultRegKey & "\LastFinished", thenTime,  "REG_SZ"
	WSHShell.RegWrite gComplianceResultRegKey & "\TotalSeconds", totalTime, "REG_SZ"

END SUB	'WriteStatsToReg


' --------------------------------------------------------------------------------------
' Write compliance stats and errors to registry
'
SUB WriteErrorToReg( startTime, strError )

	WriteStatsToReg( startTime )
	WSHShell.RegWrite gComplianceResultRegKey & "\ComplianceError", strError, "REG_SZ"

END SUB	'WriteErrorToReg


' --------------------------------------------------------------------------------------
' Write a single compliance result to the registry
'
SUB WriteResultToReg ( strDesignator, strResult, strDesc, strComment )

    DIM resultsKey

    IF gDEBUG = 1 THEN
	WScript.echo "WriteResultToReg D: " + strDesignator + "  R: " + strResult + "  X: " + strDescription+ "  C: " + strComment
    END IF

    resultsKey = gComplianceResultRegKey & "\Results\" & strDesignator & "\"
    WSHShell.RegWrite resultsKey, ""
    WSHShell.RegWrite resultsKey & "\Value",       strResult,  "REG_SZ"
    WSHShell.RegWrite resultsKey & "\Description", strDesc,    "REG_SZ"
    WSHShell.RegWrite resultsKey & "\Comment",     strComment, "REG_SZ"

END SUB	' WriteResultToReg


' --------------------------------------------------------------------------------------
' Write all the compliance results to the registry
'
SUB WriteAllResultsToReg ( apiR )

    DIM rCount

    rCount = apiR.ResultCount - 1

    IF gDEBUG = 1 THEN
	WScript.echo "WriteAllResultsToReg count is " + FormatNumber( rCount )
    END IF

    FOR i = 0 TO rCount
	resultDesignator  = apiR.GetDesignator( i )
	resultResult      = apiR.GetRelevanceResult( i )
	resultDescription = apiR.GetDescription( i )
	resultComment     = apiR.GetComment( i )
	resultType        = apiR.GetResultType( i )
	resultEvalTime    = apiR.GetEvalTime( i )

	WriteResultToReg resultDesignator, resultResult, resultDescription, resultComment, resultType, resultEvalTime
    NEXT

    WSHShell.RegWrite gComplianceResultRegKey & "\Results\ResultsTotal", ( rCount + 1 ), "REG_SZ"

END SUB	' WriteAllResultsToReg



' --------------------------------------------------------------------------------------
' Delete a registry key and any subkeys
'
' stupid windows cant have an easy way to delete a reg key with subkeys... I think this routine requires WMI...
'
SUB DeleteRegistryKey( ByVal sHive, ByVal sKey )
	
    DIM aSubKeys
    DIM sSubKey
    DIM iRC
    
    strComputer = "."    '  use "." for local computer
    SET oReg    = GetObject("winmgmts:{impersonationLevel=impersonate}!\\" & strComputer & "\root\default:StdRegProv")

    ON ERROR RESUME NEXT

    iRC = oReg.EnumKey( sHive, sKey, aSubKeys )

    IF ( iRC = 0 ) AND IsArray( aSubKeys ) THEN
	FOR EACH sSubKey IN aSubKeys
	    IF ( Err.Number <> 0 ) THEN
		Err.Clear
		EXIT SUB
	    END IF

	    DeleteRegistryKey sHive, sKey & "\" & sSubKey
	NEXT
    END IF

    oReg.DeleteKey sHive, sKey

END SUB	'DeleteRegistryKey



' --------------------------------------------------------------------------------------
' Remove result reg key and subkeys
'
SUB ResultCleanup ()

    ON ERROR RESUME NEXT

    ' Clean up possible previous result set
    '
    WSHShell.RegDelete( gComplianceResultRegKey & "Results\" ) ' Works on 9x
    DeleteRegistryKey HKLM, "SOFTWARE\BigFix\ClientComplianceResult\Results\" ' Works on NT based OSes (requires WMI)

END SUB	' ResultCleanup

