######################################################################
# Installation core functions
######################################################################

basicVariableValidation()
{
  logFnBegin "${FUNCNAME[0]}"
  LA_ACCEPT=$(checkChoice "LA_ACCEPT" "$LA_ACCEPT" "${ALLOWED_BOOLEAN[*]}")
  IS_PREREQ_CHECK=$(checkChoice "IS_PREREQ_CHECK" "$IS_PREREQ_CHECK" "${ALLOWED_BOOLEAN[*]}")
  IS_EVALUATION=$(checkChoice "IS_EVALUATION" "$IS_EVALUATION" "${ALLOWED_BOOLEAN[*]}")
  BES_AUTH_FILE=$(checkFile "false" "BES_AUTH_FILE" "$BES_AUTH_FILE")
  SUBMIT_LIC_REQUEST=$(checkChoice "SUBMIT_LIC_REQUEST" "$SUBMIT_LIC_REQUEST" "${ALLOWED_YES_NO[*]}")
  CONTINUE_FROM_CRT=$(checkChoice "CONTINUE_FROM_CRT" "$CONTINUE_FROM_CRT" "${ALLOWED_YES_NO[*]}")
  CONF_FIREWALL=$(checkChoice "CONF_FIREWALL" "$CONF_FIREWALL" "${ALLOWED_YES_NO[*]}")
  BES_CERT_FILE=$(checkFile "false" "BES_CERT_FILE" "$BES_CERT_FILE")
  BES_SETUP_TYPE=$(checkChoice "BES_SETUP_TYPE" "$BES_SETUP_TYPE" "${ALLOWED_SETUP_TYPE[*]}")
  BES_LIC_FOLDER=$(checkFolder "false" "BES_LIC_FOLDER" "$BES_LIC_FOLDER") 
  WEBUI_SRC_CERT_FOLDER=$(checkFolder "false" "WEBUI_SRC_CERT_FOLDER" "$WEBUI_SRC_CERT_FOLDER") 
  PVK_KEY_SIZE=$(checkChoice "PVK_KEY_SIZE" "$PVK_KEY_SIZE" "${ALLOWED_KEY_VAL[*]}")
  BES_PREREQ_INSTALL=$(checkChoice "BES_PREREQ_INSTALL" "$BES_PREREQ_INSTALL" "${ALLOWED_INST_PREREQ[*]}")
  BES_PREREQ_DB2_INSTALL=$(checkChoice "BES_PREREQ_DB2_INSTALL" "$BES_PREREQ_DB2_INSTALL" "${ALLOWED_INST_PREREQ[*]}")
  BES_LICENSE_PVK=$(checkFile "false" "BES_LICENSE_PVK" "$BES_LICENSE_PVK")
  BES_MASTHEAD_FILE=$(checkFile "false" "BES_MASTHEAD_FILE" "$BES_MASTHEAD_FILE")
  checkVars_COMPONENTS
  BES_WWW_FOLDER=$(checkFolder "false" "BES_WWW_FOLDER" "$BES_WWW_FOLDER")
  WR_WWW_FOLDER=$(checkFolder "false" "WR_WWW_FOLDER" "$WR_WWW_FOLDER")
  WR_WWW_PORT=$(checkNumber "false" "WR_WWW_PORT" "$WR_WWW_PORT")
  SINGLE_DATABASE=$(checkChoice "SINGLE_DATABASE" "$SINGLE_DATABASE" "${ALLOWED_BOOLEAN[*]}")
  LOCAL_DATABASE=$(checkChoice "LOCAL_DATABASE" "$LOCAL_DATABASE" "${ALLOWED_BOOLEAN[*]}")
  DB_PORT=$(checkNumber "false" "DB_PORT" "$DB_PORT")
  BES_SERVER_PORT=$(checkNumber "false" "BES_SERVER_PORT" "$BES_SERVER_PORT")
  BES_GATHER_INTERVAL=$(checkChoice "BES_GATHER_INTERVAL" "$BES_GATHER_INTERVAL" "${ALLOWED_INTERVAL[*]}")
  DB_ADMIN_USER=$(checkUserExists "false" "DB_ADMIN_USER" "$DB_ADMIN_USER")
  DB_ADMIN_USER=$(checkDb2LibPath "false" "DB_ADMIN_USER" "$DB_ADMIN_USER")
  DB_ADMIN_PWD=$(checkPassword "false" "DB2_ADMIN_PWD" "$DB_ADMIN_PWD")
  DB2INST_CONFIGURE=$(checkChoice "DB2INST_CONFIGURE" "$DB2INST_CONFIGURE" "${ALLOWED_YES_NO[*]}")
  TEM_USER_PWD=$(checkPassword "false" "TEM_USER_PWD" "$TEM_USER_PWD")
  BES_LICENSE_PVK_PWD=$(checkPassword "false" "BES_LICENSE_PVK_PWD" "$BES_LICENSE_PVK_PWD")
  ENABLE_FIPS=$(checkChoice "ENABLE_FIPS" "$ENABLE_FIPS" "${ALLOWED_BOOLEAN[*]}")
  ENABLE_LOCK_EXEMPT=$(checkChoice "ENABLE_LOCK_EXEMPT" "$ENABLE_LOCK_EXEMPT" "${ALLOWED_BOOLEAN[*]}")
  INITIAL_LOCK=$(checkChoice "INITIAL_LOCK" "$INITIAL_LOCK" "${ALLOWED_INIT_LOCK[*]}")
  LOCK_CONTROLLER=$(checkChoice "LOCK_CONTROLLER" "$LOCK_CONTROLLER" "${ALLOWED_LOCK_CONTROLLER[*]}")
  LOCK_DURATION=$(checkNumber "false" "LOCK_DURATION" "$LOCK_DURATION")
  ENABLE_ARCHIVE_UTF8=$(checkChoice "ENABLE_ARCHIVE_UTF8" "$ENABLE_ARCHIVE_UTF8" "${ALLOWED_BOOLEAN[*]}")
  ADV_MASTHEAD_DEFAULT=$(checkChoice "ADV_MASTHEAD_DEFAULT" "$ADV_MASTHEAD_DEFAULT" "${ALLOWED_BOOLEAN[*]}")
  USE_PROXY=$(checkChoice "USE_PROXY" "$USE_PROXY" "${ALLOWED_BOOLEAN[*]}")
  PROXY_PORT=$(checkNumber "false" "PROXY_PORT" "$PROXY_PORT")
  PROXY_PWD=$(checkPassword "false" "PROXY_PWD" "$PROXY_PWD")
  TEST_PROXY=$(checkChoice "TEST_PROXY" "$TEST_PROXY" "${ALLOWED_TEST_PROXY[*]}")
  DB2_MASTER_PORT=$(checkNumber "false" "DB2_MASTER_PORT" "$DB2_MASTER_PORT")
  DB2_MASTER_PWD=$(checkPassword "false" "DB2_MASTER_PWD" "$DB2_MASTER_PWD")
  EXCEPTION_URL=$(checkHttpUrl "false" "EXCEPTION_URL" "$EXCEPTION_URL")
  ENCODE_VALUE=$(checkEncoding "false" "ENCODE_VALUE" "$ENCODE_VALUE")
  CREDENTIAL_EMAIL=$(checkMailAddress "false" "CREDENTIAL_EMAIL" "$CREDENTIAL_EMAIL")
  IGNORE_WARNING=$(checkChoice "IGNORE_WARNING" "$IGNORE_WARNING" "${ALLOWED_YES_NO[*]}")
  IGNORE_DB2_WARNING=$(checkChoice "IGNORE_DB2_WARNING" "$IGNORE_DB2_WARNING" "${ALLOWED_YES_NO[*]}")
  IGNORE_REPL_CRED_WARNING=$(checkChoice "IGNORE_REPL_CRED_WARNING" "$IGNORE_REPL_CRED_WARNING" "${ALLOWED_YES_NO[*]}")
  DB2_USERS_PWD=$(checkPassword "false" "DB2_USERS_PWD" "$DB2_USERS_PWD")
  DB2_SETUP_FILE=$(checkFile "false" "DB2_SETUP_FILE" "$DB2_SETUP_FILE")
  INSTALL_DB2=$(checkChoice "INSTALL_DB2" "$INSTALL_DB2" "${ALLOWED_YES_NO_EXIT[*]}")
  DB2_EXTR_DIR=$(checkFolderAll "false" "DB2_EXTR_DIR" "$DB2_EXTR_DIR")
  WEBUI_PORT=$(checkPortIsFree "false" "WEBUI_PORT" "$WEBUI_PORT" "$WR_WWW_PORT")
  WEBUI_REDIRECT=$(checkChoice "WEBUI_REDIRECT" "$WEBUI_REDIRECT" "${ALLOWED_BOOLEAN[*]}")
  WEBUI_REDIRECT_PORT=$(checkPortIsFree "false" "WEBUI_REDIRECT_PORT" "$WEBUI_REDIRECT_PORT" "$WR_WWW_PORT" "$WEBUI_PORT")
  DB_WEBUI_PORT=$(checkNumber "false" "DB_WEBUI_PORT" "$DB_WEBUI_PORT")
  SERVICE_FOLDER=$(setServiceFolder)
  logFnEnd "${FUNCNAME[0]}"
}

setServiceFolder()
{
  logFnBegin "${FUNCNAME[0]}"
  serviceFolder="/etc/init.d"
  systemdPid=`pgrep -o systemd`
  if [[ -n "$systemdPid" ]] && [[ $systemdPid -eq 1 ]]; then
    serviceFolder="/usr/lib/systemd/system/"
  fi
  logFnEnd "${FUNCNAME[0]}"
  echo $serviceFolder
}

checkVars_COMPONENTS()
{
  logFnBegin "${FUNCNAME[0]}"
  srvVal=$COMPONENT_SRV
  wrVal=$COMPONENT_WR
  webuiVal=$COMPONENT_WEBUI
  if [[ $srvVal != "" || $wrVal != "" || $webuiVal != "" ]]
  then
    isValid="true"
    srvVal=$(checkChoice "COMPONENT_SRV" "$srvVal" "${ALLOWED_BOOLEAN[*]}")
    wrVal=$(checkChoice "COMPONENT_WR" "$wrVal" "${ALLOWED_BOOLEAN[*]}")
    webuiVal=$(checkChoice "COMPONENT_WEBUI" "$webuiVal" "${ALLOWED_BOOLEAN[*]}")
    if [[ $COMPONENT_SRV != $srvVal || $COMPONENT_WR != $wrVal || $COMPONENT_WEBUI != $webuiVal ]]
    then
      #WRN: "Warning: The values specified for the following variables will be ignored: 'var1Name', 'var2Name', 'var3Name'"
      writeMsg stdout "`nls_replace 'TEM0010W' \"COMPONENT_SRV\" \"COMPONENT_WR\" \"COMPONENT_WEBUI\"`"
      COMPONENT_SRV=""
      COMPONENT_WR=""
      COMPONENT_WEBUI=""
    fi
  fi
  logFnEnd "${FUNCNAME[0]}"
}

checkNumber()
{
  logFnBegin "${FUNCNAME[0]}"
  isInteractive=$1
  key_name=$2
  key_value=$3
  if [[ $key_value != "" ]]
  then
    if ! [[ $key_value =~ ^[0-9]+$ ]]
    then
      [[ $isInteractive = "true" ]] || writeMsg stdout "`nls_replace 'TEM0007W' \"$key_name\" \"$key_value\"`"
      key_value=""
    fi
  fi
  logFnEnd "${FUNCNAME[0]}"
  echo $key_value
}

checkFile()
{
  logFnBegin "${FUNCNAME[0]}"
  isInteractive=$1
  key_name=$2
  key_value=$3
  if [[ $key_value != "" ]]
  then
    if [[ ! -f $key_value ]]
    then
      [[ $isInteractive = "true" ]] || writeMsg stdout "`nls_replace 'TEM0012W' \"$key_name\" \"$key_value\"`"
      key_value=""
    fi
  fi
  logFnEnd "${FUNCNAME[0]}"
  echo $key_value
}

checkChoice()
{
  logFnBegin "${FUNCNAME[0]}"
  key_name=$1
  key_value=$2
  key_allowed_value=$3
  writeMsg log "Checking value of $key_name"
  if [[ $key_value != "" ]]
  then
    isValid="false"
    for str in ${key_allowed_value[*]}
    do
      if [[ $str = $key_value ]]
      then
        isValid="true"
        break
      fi
    done
    if [[ $isValid != "true" ]]
    then
      writeMsg stdout "`nls_replace 'TEM0022W' \"${key_allowed_value[*]}\" \"$key_name\" \"$key_value\"`"
      key_value=""
    fi
  fi
  logFnEnd "${FUNCNAME[0]}"
  echo $key_value
}

checkPortIsFree()
{
  logFnBegin "${FUNCNAME[0]}"
  isInteractive=$1
  key_name=$2
  key_value=$3
  port1=$4
  port2=$5
  if [[ $key_value != "" ]]
  then
    if ! [[ $key_value =~ ^[0-9]+$ ]]
    then
      [[ $isInteractive = "true" ]] || writeMsg stdout "`nls_replace 'TEM0007W' \"$key_name\" \"$key_value\"`"
      key_value=""
    else
      if [[ $key_value = "$port1" ]]
      then
        writeMsg both "`nls_replace 'TEM0168E' \"$key_value\"`"
        key_value=""
      elif [[ $port2 != "" ]] && [[ $key_value = "$port2" ]]
      then
        writeMsg both "`nls_replace 'TEM0168E' \"$key_value\"`"
        key_value=""
      fi
    fi
  fi
  logFnEnd "${FUNCNAME[0]}"
  echo $key_value
}

checkMailAddress()
{
  logFnBegin "${FUNCNAME[0]}"
  isInteractive=$1
  key_name=$2
  key_value=$3
  if [[ $key_value != "" ]]
  then
    echo $key_value | egrep -c "^.+@.+$" > /dev/null
    if [[ $? -ne 0 ]]
    then
      [[ $isInteractive = "true" ]] || writeMsg stdout "`nls_replace 'TEM0092W' \"$key_name\" \"$key_value\"`"
      [[ $isInteractive = "false" ]] || writeMsg stdout "`nls_replace 'TEM0093W'`"
      key_value=""
    fi
  fi
  logFnEnd "${FUNCNAME[0]}"
  echo $key_value
}

checkHttpUrl()
{
  logFnBegin "${FUNCNAME[0]}"
  isInteractive=$1
  key_name=$2
  key_value=$3
  if [[ $key_value != "" ]]
  then
    echo $key_value | egrep "^http://.+$" > /dev/null
    if [[ $? -ne 0 ]]
    then
      [[ $isInteractive = "true" ]] || writeMsg stdout "`nls_replace 'TEM0074W' \"$key_name\" \"$key_value\"`"
      [[ $isInteractive = "false" ]] || writeMsg stdout "`nls_replace 'TEM0075W'`"
      key_value=""
    fi
  fi
  logFnEnd "${FUNCNAME[0]}"
  echo $key_value
}

checkEncoding()
{
  logFnBegin "${FUNCNAME[0]}"
  isInteractive=$1
  key_name=$2
  key_value=$3
  if [[ $key_value != "" ]]
  then
    cat $DEF_BES_ENCODING_MAP_FILE | egrep "=$key_value$" > /dev/null
    if [[ $? -ne 0 ]]
    then
      [[ $isInteractive = "true" ]] || writeMsg stdout "`nls_replace 'TEM0145W' \"$key_name\" \"$key_value\"`"
      [[ $isInteractive = "false" ]] || writeMsg stdout "`nls_replace 'TEM0146W'`"
      key_value=""
    fi
  fi
  logFnEnd "${FUNCNAME[0]}"
  echo $key_value
}

checkUserExists()
{
  logFnBegin "${FUNCNAME[0]}"
  isInteractive=$1
  key_name=$2
  key_value=$3
  if [[ $key_value != "" ]]
  then
    userExists "$key_value"
    if [[ $? -ne 0 ]]
    then
      [[ $isInteractive = "true" ]] || writeMsg stdout "`nls_replace 'TEM0096W' \"$key_name\" \"$key_value\"`"
      key_value=""
    fi
  fi
  logFnEnd "${FUNCNAME[0]}"
  echo $key_value
}

userExists()
{
  logFnBegin "${FUNCNAME[0]}"
  userName=$1
  tempUserData=""
  tempUserData=`su - $userName -c "pwd" 2>/dev/null` 
  lastrc=$?
  logFnEnd "${FUNCNAME[0]}"
  return $lastrc
}

checkDb2LibPath()
{
  logFnBegin "${FUNCNAME[0]}"
  isInteractive=$1
  key_name=$2
  key_value=$3
  if [[ $key_value != "" ]] && [[ $DB_TARGET = "db2" ]]
  then
    db2LibPath=$(extractDB2Lib64Path "$key_value")
    if [[ $db2LibPath = "" ]]
    then
      [[ $isInteractive = "true" ]] || writeMsg stdout "`nls_replace 'TEM0097W' \"DB2_LIB_PATH\" \"$key_name\" \"$key_value\"`"
      [[ $isInteractive = "false" ]] || writeMsg stdout "`nls_replace 'TEM0098W' \"DB2_LIB_PATH\"`"
      key_value=""
    fi
  fi
  logFnEnd "${FUNCNAME[0]}"
  echo $key_value
}

checkFolder()
{
  logFnBegin "${FUNCNAME[0]}"
  isInteractive=$1
  key_name=$2
  key_value=$3
  if [[ $key_value != "" ]]
  then
    key_value=$(folderExists $key_value)
    if [[ $? -ne 0 ]]
    then
      if ! mkdir -p $key_value 2>/dev/null
      then
        [[ $isInteractive = "true" ]] || writeMsg stdout "`nls_replace 'TEM0008W' \"$key_name\" \"$key_value\"`"
        key_value=""
      fi
    fi
  fi
  logFnEnd "${FUNCNAME[0]}"
  echo $key_value
}

checkFolderAll()
{
  logFnBegin "${FUNCNAME[0]}"
  isInteractive=$1
  key_name=$2
  key_value=$3
  if [[ $key_value != "" ]]
  then
    key_value=$(folderExists $key_value)
    if [[ $? -ne 0 ]]
    then
      if ! mkdir -p $key_value 2>/dev/null
      then
        [[ $isInteractive = "true" ]] || writeMsg stdout "`nls_replace 'TEM0094W'`"
        key_value=""
      fi
      isFolderNotWritable $key_value
      if [[ $? -ne 0 ]]
      then
        if [[ $isInteractive = "true" ]]
        then
          writeMsg stdout "`nls_replace 'TEM0142E' \"$key_value\"`"
        fi
        key_value=""
      fi
    fi
  fi
  logFnEnd "${FUNCNAME[0]}"
  echo $key_value
}

folderExists()
{
  logFnBegin "${FUNCNAME[0]}"
  folderName=$1
  exists=0
  #Remove latest '/' if exists
  case "$folderName" in
    */) folderName=${folderName%?};;
  esac
  if [[ ! -d "$folderName" ]]
  then
    exists=1
  fi
  logFnEnd "${FUNCNAME[0]}"
  echo "$folderName"
  return $exists
}

isFolderNotWritable()
{
  logFnBegin "${FUNCNAME[0]}"
  inFolder="$1"
  fnRc=1
  touch "$inFolder/canWrite" 2>> /dev/null
  if [[ $? -eq 0 ]]
  then
    \rm -f "$inFolder/canWrite" 2>> /dev/null
    fnRc=0
  fi
  logFnEnd "${FUNCNAME[0]}"
  return $fnRc
}

isPortInUse()
{
  logFnBegin "${FUNCNAME[0]}"
  port=$1
  out=`netstat -tan | grep "$port"`
  lastrc=$?
  logFnEnd "${FUNCNAME[0]}"
  return $lastrc
}

checkPassword()
{
  logFnBegin "${FUNCNAME[0]}"
  isInteractive=$1
  key_name=$2
  key_value=$3
  if [[ $key_value != "" ]]
  then
    if [[ ${#key_value} -lt 6 ]]
    then
      [[ $isInteractive = "true" ]] || writeMsg stdout "`nls_replace 'TEM0040W' \"$key_name\"`"
      key_value=""
    fi
  fi
  logFnEnd "${FUNCNAME[0]}"
  echo $key_value
}

silentCheckNotNull()
{
  logFnBegin "${FUNCNAME[0]}"
  key_name=$1
  key_value=$2
  fnRc=0
  if [[ "$IS_SILENT" = "true" && $key_value = "" ]]
  then
    writeMsg both "`nls_replace 'TEM0139E' \"$key_name\"`"
    fnRc=1
  fi
  logFnEnd "${FUNCNAME[0]}"
  return $fnRc
}
