#!/bin/sh
#
# besclient.sh: Handles the BigFix Client
#
# description: Handles the BigFix Client service
# processname: BESClient

stop() {
	prog=BESClient
	pid=`pgrep -o -f /opt/BESClient/bin/$prog`
	if [ -n "$pid" ]; then
		args=`cat /proc/$pid/cmdline | tr -d '\0'`
	fi
	if [ -z "$pid" ] || [ -z "$args" ] || [ "$args" != "/opt/BESClient/bin/$prog" ]; then
		ret=1
	else
		kill -TERM $pid
		ret=$?
		sleep 0.2
		ps --pid $pid &>/dev/null
		running=$?
		delay=120
		count=0
		while [ "$running" -eq 0 ] && [ "$count" -lt "$delay" ]; do
			sleep 5 
			count=$(($count+5));
			ps --pid $pid &>/dev/null
			running=$?
		done 
		if [ "$count" -ge "$delay" ]; then
			kill -KILL $pid &>/dev/null
			ret=$?
		fi
		sleep 0.2
		ps --pid $pid &>/dev/null
		if [ $? -eq 0 ]; then
			ret=1
		fi
	fi
	return $ret
}

error() {
	echo besclient.sh shall be used only within systemd unitfile with the stop argument
	return 1
}

case "$1" in
	stop)
		# The stop argument can be only used within the systemd unit file
		if [ $PPID -eq 1 ]; then
			stop
		else 
			error
		fi
		;;
	*)
		error
esac

exit $?
