#!/bin/sh
#
# beswebreports.sh: Starts the BigFix WebReports
#
# description: Starts the BigFix WebReports service
# processname: BESWebReportsServer

start() {
	SKIP_CLIENT_RESTART="${SKIP_CLIENT_RESTART:-noskip$1}"
	
	echo SKIP_CLIENT_RESTART: "$SKIP_CLIENT_RESTART"

	clientActionMastheadPath=/etc/opt/BESClient/actionsite.afxm
	webreportsActionMastheadPath=/etc/opt/BESWebReportsServer/actionsite.afxm
	if [ -f $clientActionMastheadPath ]; then
		cp -f $clientActionMastheadPath $webreportsActionMastheadPath
	fi

	export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/opt/BESWebReportsServer/bin:/var/opt/BESWebReportsServer/BESReportsData/BESExe
	CLIENT_RESTART_NEEDED=0
	reportsConfigPath=/var/opt/BESWebReportsServer/beswebreports.config
	reportsConfigObfPath=/var/opt/BESWebReportsServer/beswebreports.obf
	if [ ! -f $reportsConfigPath ]; then
		cat $reportsConfigPath.default > $reportsConfigPath
		CLIENT_RESTART_NEEDED=1
	fi

	stackSizeHardLimitKB=$(ulimit -Hs)
	if [ "$stackSizeHardLimitKB" != "unlimited" ] && [ $stackSizeHardLimitKB -lt 10240 ]; then
		failure "Stack size hard limit ( ulimit -Hs ) too low = $stackSizeHardLimitKB."
		/bin/echo
		return 1
	fi

	stackSizeSoftLimitKB=$(ulimit -Ss)
	if [ "$stackSizeSoftLimitKB" = "unlimited" ] || [ $stackSizeSoftLimitKB -lt 10240 ]; then
		ulimit -Ss 10240
	fi

	mkdir -p /var/log/BESWebReports
	if [ -f /var/opt/BESWebReportsServer/.user ]; then
		blkidcommand=/sbin/blkid
		if [ -f $blkidcommand ] ; then
			$blkidcommand >& /dev/null
		fi
		user=$(cat /var/opt/BESWebReportsServer/.user)
		xhost +local:$user &> /dev/null
		chown $user:$user $webreportsActionMastheadPath &> /dev/null
		blkidOut=$(su - $user -c $blkidcommand)
		initUUID=""
		if [ "$blkidOut" = "" ]; then
			initUUID="--initUUID"
		fi
		/opt/BESWebReportsServer/bin/BESWebReportsServer --initializeHost $initUUID
		chown $user:$user $reportsConfigPath &> /dev/null
		if [ "$initUUID" != "" ]; then
			chown $user:$user /var/opt/BESWebReportsServer/.uuid &> /dev/null
		fi
		if [ -f $reportsConfigObfPath ]; then
			chown $user:$user $reportsConfigObfPath &> /dev/null
		fi

		chown $user:$user /var/log/BESWebReports &> /dev/null

		##### Add ACL to '/var/opt/BESCommon' folder and files for user #####
		setfacl -m "u:$user:rx" /var/opt/BESCommon

  		setfacl -m "u:$user:r" \
		/var/opt/BESCommon/BESComm.id \
		/var/opt/BESCommon/BESDeploy.id \
		/var/opt/BESCommon/BESLib.id \
		/var/opt/BESCommon/BESShared.id

		setfacl -m "u:$user:rw" \
		/var/opt/BESCommon/BESHostname.id \
		/var/opt/BESCommon/.HostIDAccess.read \
		/var/opt/BESCommon/.HostIDAccess.write \
		/var/opt/BESCommon/.IDAccess.read \
		/var/opt/BESCommon/.IDAccess.write

		runuser -mu $user /opt/BESWebReportsServer/bin/BESWebReportsServer 2> /dev/null
	else
		/opt/BESWebReportsServer/bin/BESWebReportsServer 2> /dev/null
	fi
	ret=$?
	
	if [[ $CLIENT_RESTART_NEEDED -eq 1 && $SKIP_CLIENT_RESTART == "noskip" ]]; then
		/bin/systemctl restart besclient >& /dev/null 
	fi
	
	return $ret
}

start_skipclientrestart() {
	echo SKIP_CLIENT_RESTART=skip > /etc/opt/BESWebReportsServer/beswebreports.env
	/bin/systemctl start beswebreports >& /dev/null 
}

error() {
	echo The argument "$1" is not supported. Usage: beswebreports.sh start_skipclientrestart
	return 1
}

case "$1" in
	start)
		# The start argument can be only used within the systemd unit file
		if [ $PPID -eq 1 ]; then
			start
		else 
			error "$1"
		fi
		;;
	start_skipclientrestart)
		start_skipclientrestart
		;;
	*)
		error "$1"
esac

exit $?
