// Graph.js

// <?import /JavaScript/Charts/Charts.css?>
// <?import /JavaScript/Charts/Charts.js?>
// <?import /JavaScript/Util/HTMLGenerator.js?>
// <?import /JavaScript/Util/URL.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/Charts/ChartBox.js?>

// <?import /JavaScript/json2.js?>

// <?import /JavaScript/yui-import/Dom.js?>

// <?import /JavaScript/jQuery/jquery.js?>
// <?import /JavaScript/jqPlot/jquery.jqplot.js?>
// <?import /JavaScript/jqPlot/plugins/jqplot.pieRenderer.js?>
// <?import /JavaScript/jqPlot/plugins/jqplot.categoryAxisRenderer.js?>
// <?import /JavaScript/jqPlot/plugins/jqplot.barRenderer.js?>
// <?import /JavaScript/jqPlot/plugins/jqplot.canvasTextRenderer.js?>
// <?import /JavaScript/jqPlot/plugins/jqplot.canvasAxisTickRenderer.js?>
// <?import /JavaScript/jqPlot/plugins/jqplot.highlighter.js?>
// <?import /JavaScript/jqPlot/plugins/jqplot.dateAxisRenderer.js?>
// <?import /JavaScript/jqPlot/jquery.jqplot.css?>

WR.Charts.Graph = function( chartBox )
{
    this.chartBox = chartBox;
    this.id = 'WR_ChartGraph_' + WR.Charts.Graph._nextIdNo++;
    
    this.exportLinkDrawn = false;
    
    this.div = new WR.DOM.Element( 'div' )
        .setProperty( 'id', this.id )
        .setProperty( 'className', 'chartgraph' );
    
};

WR.Charts.Graph.shortenNameForBarGraph = function( name )
{
    if ( name.length < WR.Charts.Graph._BAR_NAMES_LENGTH - 3 )
        return name;
    else
        return name.slice(0, WR.Charts.Graph._BAR_NAMES_LENGTH) + '...';
};

WR.Charts.Graph._nextIdNo = 0;

WR.Charts.Graph._BAR_NAMES_LENGTH = 20;

WR.Charts.Graph.prototype = {
    
    draw : function()
    {
        var newDiv = new WR.DOM.Element( 'div' )
            .setProperty( 'id', this.id )
            .setProperty( 'className', 'chartgraph' );
        this.div.finish().parentNode.replaceChild( newDiv.finish(), this.div.finish() );
        this.div = newDiv;
        
        if ( this.chartBox.configuration.chartType == WR.Charts.ChartBox.CHARTTYPE_PIE )
            this._drawPie();
        else if ( this.chartBox.configuration.chartType == WR.Charts.ChartBox.CHARTTYPE_BAR )
            this._drawBar();
        else if ( this.chartBox.configuration.chartType == WR.Charts.ChartBox.CHARTTYPE_LINE )
            this._drawLine();
    },
    
    _drawBar : function()
    {
        var barData = this.chartBox.generateBarData();
        if ( 0 == barData.counts.length || 0 == barData.counts[0].length )
            return;

        var shortenedValues = [];
        for ( i in barData.values )
        {
            shortenedValues.push( WR.Charts.Graph.shortenNameForBarGraph( barData.values[i] ) );
        }
        
        $.jqplot( this.id, barData.counts, {
            seriesDefaults: { renderer: $.jqplot.BarRenderer },
            seriesColors: WR.Charts.ChartBox.COLORS,
            axes:{
                xaxis: { renderer: $.jqplot.CategoryAxisRenderer,
                ticks: shortenedValues,
                rendererOptions: { tickRenderer:$.jqplot.CanvasAxisTickRenderer },
                tickOptions: {
                    angle: -40          
                    }
                },
                yaxis:{ min:0 }
            },
            highlighter: {
                tooltipLocation: 'n',
                formatString: '<table class="jqplot-highlighter">' +
                               '<tr><td class="tooltip-row1" id=' + this.chartBox.id + '_highlighterRow1></td></tr>' + 
                               '<tr><td class="tooltip-row2" id=' + this.chartBox.id + '_highlighterRow2></td></tr>' +
                               '\u003Cscript>' +
                               'var values = ' + JSON.stringify( barData.values ) + ';' +
                               'WR.DOM.el( YAHOO.util.Dom.get( "' + this.chartBox.id + '_highlighterRow1" ) ).innerHTML( values[%s - 1] );' +
                               'WR.DOM.el( YAHOO.util.Dom.get( "' + this.chartBox.id + '_highlighterRow2" ) ).innerHTML( %s );' +
                               '\u003C/script>'
            }
        });
    },
    
    _drawPie : function()
    {
        var data = this.chartBox.generatePieData();
        if ( 0 == data.length || 0 == data[0].length )
            return;

        var colors = [];
        colors = colors.concat( WR.Charts.ChartBox.COLORS );
        colors.reverse();
        var offset = data[0].length % colors.length;
        var offsetColors = colors.splice( colors.length - offset, offset );
        colors = offsetColors.concat( colors );
        
        $.jqplot( this.id, data, {
            seriesDefaults : { renderer:$.jqplot.PieRenderer },
            seriesColors: colors
        });
    },
    
    _drawLine : function()
    {
        var data = this.chartBox.generateLineData();
        if ( 0 == data.length || 0 == data[0].length )
            return;

        $.jqplot( this.id, data, {
            legend: { show: data.length > 1 },
            seriesColors:  WR.Charts.ChartBox.COLORS,
            series: [
                { label: data.length >= 1? data[0].name : '' },
                { yaxis: 'y2axis', label: data.length >= 2? data[1].name : '' },
                { yaxis: 'y3axis', label: data.length >= 3? data[2].name : '' },
                { yaxis: 'y4axis', label: data.length >= 4? data[3].name : '' }
            ],
            seriesDefaults: { markerOptions: { size: 5 } },
            axesDefaults: { useSeriesColor: true },
            axes: {
                xaxis: {
                    renderer: $.jqplot.DateAxisRenderer
                },
                yaxis: { min: 0, label: data.length == 1 ? data[0].name : '' },
                y2axis: { min: 0 },
                y3axis: { min: 0 },
                y4axis: { min: 0 }
            
            }
        });
        
        if ( !this.exportLinkDrawn )
        {
            this.exportLinkDrawn = true;
            var me = this;
            $( this.div.finish() ).after( WR.HTMLGenerator.createJavaScriptLink( '<?jformat Export to CSV?>', function() {
                WR.buildGetParams( me.chartBox.configuration.generateRequestParams(), function( newQuery ) {
                    window.location = '/csv/chartdata.csv?' + newQuery;
                });
            } )
                .addClass( 'csvExportLink' )
                .finish() );
        }
    },
    
    
    
    addTo : function( div )
    {
        div.appendChild( this.div.finish() )
    }
    
};
